/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.interfaces;

import butterfly.xmlview.model.interfaces.IDocument;

/**
 * Insert the type's description here.
 * Creation date: (11/30/2002 9:23:47 AM)
 * @author: 
 */
public interface IDocumentEditorOrganizer extends IComponent {
	public static final String ROLE ="butterfly.xmlview.gui.interfaces.IDocumentEditorOrganizer";
	public static final String DOCUMENT_EDITOR_ADDED_EVENT = "document-editor-added";
	public static final String DOCUMENT_EDITOR_REMOVED_EVENT = "document-editor-removed";
	public static final String DOCUMENT_EDITOR_SHOWN_EVENT = "document-editor-shown";
	public static final String DOCUMENT_EDITOR_KEY = "document-editor";
	

void addDocumentEditor(IDocument key, IDocumentEditor comp);
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:15:44 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public void changeDocumentEditorName(IDocument d,String newkey);
/**
 * Insert the method's description here.
 * Creation date: (9/20/2002 3:31:09 PM)
 * @return boolean
 * @param key java.lang.String
 */
boolean containsDocumentEditor(IDocument key);
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:15:44 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public IDocumentEditor getDocumentEditor(IDocument doc);
public IDocumentEditor getActiveDocumentEditor();
public IDocumentEditor[] getDocumentEditors();
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:15:44 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
public IDocument getActiveDocumentEditorKey();
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:15:44 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
void removeActiveDocumentEditor();
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:15:44 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
void removeDocumentEditor(IDocument key);
/**
 * Insert the method's description here.
 * Creation date: (9/18/2002 10:12:09 PM)
 * @param view butterfly.xmlview.gui.interfaces.IDocumentView
 */
void showDocumentEditor(IDocumentEditor view);
/**
 * Insert the method's description here.
 * Creation date: (8/29/2002 4:15:44 PM)
 * @param key java.lang.String
 * @param comp java.awt.Component
 */
void showDocumentEditor(IDocument key);
}
