/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.interfaces;

import javax.swing.JComponent;

import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (8/15/2002 10:31:27 AM)
 * @author: 
 */
public interface IXmlRenderer extends IDocumentEditor{
	public static final String ROLE = "butterfly.xmlview.gui.interfaces.IXmlRenderer";
/**
 * Insert the method's description here.
 * Creation date: (10/17/2002 7:11:36 PM)
 * @return java.lang.String
 */
String getSelectedTag();

void addNodeSelectionListener(INodeSelectionListener l);
void removeNodeSelectionListener(INodeSelectionListener l);
/**
 * Insert the method's description here.
 * Creation date: (10/17/2002 7:11:36 PM)
 * @return java.lang.String
 */
String getSelectedTagXPath();
/**
 * 
 * @return XmlDocument
 */
public IXmlDocument getXmlModel();
/**
 * 
 * @return java.awt.Component
 * @param doc XmlDocument
 */
public JComponent renderXmlDocument(IXmlDocument doc);
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:35:55 AM)
 * @param start int
 */
void setSelectionEnd(int start);
/**
 * Insert the method's description here.
 * Creation date: (12/9/2002 11:35:55 AM)
 * @param start int
 */
void setSelectionStart(int start);
}
