/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.interfaces;

import java.util.Hashtable;
import javax.swing.JOptionPane;
/**
 * Insert the type's description here.
 * Creation date: (8/20/2002 1:37:02 PM)
 * @author: 
 */
public interface IXmlViewInformer extends IComponent{
	public static final String ROLE = "butterfly.xmlview.gui.interfaces.IXmlViewInformer";

	public static final int YES_OPTION = JOptionPane.YES_OPTION;
	public static final int NO_OPTION = JOptionPane.NO_OPTION;
	public static final int CANCEL_OPTION = JOptionPane.CANCEL_OPTION;
	
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:38:02 PM)
 * @param msg java.lang.String
 */
public int displayConfirmation(String msg);
public Object displayTransientMessage(String msg);
public void closeWindow(Object key);
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:38:02 PM)
 * @param msg java.lang.String
 */
void displayError(String msg);
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:38:02 PM)
 * @param msg java.lang.String
 */
public String displayFileQuery(String msg);
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:38:02 PM)
 * @param msg java.lang.String
 */
void displayMessage(String msg);
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:38:02 PM)
 * @param msg java.lang.String
 */
public Hashtable displayQuery(String msg, String[] fields);
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:38:02 PM)
 * @param msg java.lang.String
 */
void displayWarning(String msg);

/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:38:02 PM)
 * @param msg java.lang.String
 */
public String displayQuery(String msg);
}
