/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.awt.Component;

import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IButterflyAction;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditor;
import butterfly.xmlview.model.interfaces.INode;
/**
 * Insert the type's description here.
 * Creation date: (11/24/2002 5:47:01 PM)
 * @author: 
 */
public abstract class AbstractTreeEditor
    implements ITreeEditor, IComponent, IComponentRequester, IActionRequester {
    private IActionLookup actionLookup_;
    private IComponentLookup componentLookup_;
    private JPopupMenu rightClickMenu_;
    private static Logger logger_ = Logger.getLogger(AbstractTreeEditor.class);
    /**
     * AbstractTreeEditor constructor comment.
     */
    public AbstractTreeEditor() {
        super();
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 3:31:13 PM)
     * @param tree butterfly.xmlview.gui.tree.interfaces.IDocumentTree
     * @param where javax.swing.tree.DefaultMutableTreeNode
     * @param node java.lang.Object
     */
    public void addNode(
        IDocumentTree tree,
        javax.swing.tree.DefaultMutableTreeNode parent,
        Object node) {
        DefaultTreeModel treeModel = tree.getTreeModel();

		if(parent == null){
			addNode(tree,parent,node,-1);
		}
		else{
			addNode(tree,parent,node,parent.getChildCount());
		}
        
        //if (node instanceof IMultiNode) {
            //IMultiNode mnode = (IMultiNode) node;

            //DefaultMutableTreeNode mparent = makeNode(node);
            //if (parent != null) {
	            //tree.registerNode(node,mparent);
                //treeModel.insertNodeInto(mparent, parent, parent.getChildCount());
            //} else {
	            //tree.registerNode(node,mparent);
                //tree.getTreeModel().setRoot(mparent);
            //}
            ////visitMultiNode(tree, mparent, mnode);
            //for(int i = 0 ;i < mnode.childCount(); i++){
				//addNode(tree,mparent,mnode.childAt(i));
            //}

        //} else {

            //DefaultMutableTreeNode nnode = makeNode(node);
            //if (parent != null) {
	            //tree.registerNode(node,nnode);
                //treeModel.insertNodeInto(nnode, parent, parent.getChildCount());
            //} else {
	            //tree.registerNode(node,nnode);
                //tree.getTreeModel().setRoot(nnode);

            //}
        //}

    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 3:31:13 PM)
     * @param tree butterfly.xmlview.gui.tree.interfaces.IDocumentTree
     * @param where javax.swing.tree.DefaultMutableTreeNode
     * @param node java.lang.Object
     */
    public void addNode(
        IDocumentTree tree,
        DefaultMutableTreeNode parent,
        Object node,int index) {
        DefaultTreeModel treeModel = tree.getTreeModel();

        if(tree.getTreeNode(node)!=null){
        	if(tree.getTreeNode(node).getParent() != null){
        		tree.getTreeModel().removeNodeFromParent(tree.getTreeNode(node));
        	}
        }
      //  logger_.debug("adding "+node+" to "+parent+" at "+index);
        //if (node instanceof IMultiNode) {
            INode mnode = (INode)node;

            DefaultMutableTreeNode mparent = makeNode(node);
            if (parent != null) {
	            tree.registerNode(node,mparent);
                treeModel.insertNodeInto(mparent, parent, index);
               // ((JTree)tree).scrollPathToVisible(new TreePath(mparent.getPath()));
               // logger_.debug("node added to tree:"+tree);
                
            } else {
	            tree.registerNode(node,mparent);
                tree.getTreeModel().setRoot(mparent);
            }
            //visitMultiNode(tree, mparent, mnode, index + 1);
		for(int i = 0 ;i < mnode.childCount(); i++){
			tree.addNode(mparent,mnode.childAt(i),i);
		}
        //} else {

            //DefaultMutableTreeNode nnode = makeNode(node);
            //if (parent != null) {
	            //tree.registerNode(node,nnode);
                //treeModel.insertNodeInto(nnode, parent, parent.getChildCount());
            //} else {
	            //tree.registerNode(node,nnode);
                //tree.getTreeModel().setRoot(nnode);

            //}
        //}

    }
    /**
     * Insert the method's description here.
     * Creation date: (11/24/2002 5:47:01 PM)
     * @param pop javax.swing.JMenu
     */
    public void buildEditingMenuForNode(
        IDocumentTree tree,
        Object node,
        javax.swing.JPopupMenu pop) {
        IButterflyAction[] acts = getActionsForNode(tree, node);
        if (acts != null) {
            for (int i = 0; i < acts.length; i++) {
                pop.add((Action) acts[i]);
            }
        }
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 2:00:57 PM)
     * @return butterfly.actions.interfaces.IActionLookup
     */
    public butterfly.actions.interfaces.IActionLookup getActionLookup() {
        return actionLookup_;
    }
    public abstract butterfly
        .actions
        .interfaces
        .IButterflyAction[] getActionsForNode(IDocumentTree tree, Object node);
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 2:00:57 PM)
     * @return butterfly.components.interfaces.IComponentLookup
     */
    public butterfly.components.interfaces.IComponentLookup getComponentLookup() {
        return componentLookup_;
    }
    public java.awt.Component getTreeCellRendererComponent(IDocumentTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
	    return null;
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 3:47:48 PM)
     * @return javax.swing.tree.DefaultMutableTreeNode
     * @param obj java.lang.Object
     */
    public DefaultMutableTreeNode makeNode(Object obj) {
        return new DefaultMutableTreeNode(obj);
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/24/2002 5:47:01 PM)
     * @return butterfly.actions.interfaces.IButterflyAction
     * @param node java.lang.Object
     */

    /**
     * Invoked when the mouse has been clicked on a component.
     */
    public void mouseClicked(IDocumentTree tree, java.awt.event.MouseEvent e) {
    }
    /**
     * Invoked when the mouse enters a component.
     */
    public void mouseEntered(IDocumentTree tree, java.awt.event.MouseEvent e) {
    }
    /**
     * Invoked when the mouse exits a component.
     */
    public void mouseExited(IDocumentTree tree, java.awt.event.MouseEvent e) {

    }
    /**
     * Invoked when a mouse button has been pressed on a component.
     */
    public void mousePressed(IDocumentTree tree, java.awt.event.MouseEvent e) {
        if (e.isPopupTrigger()) {
            Object node = tree.getSelectedNode().getUserObject();
            showEditingMenu(tree, node, e.getX(), e.getY());

        }
    }
    /**
     * Invoked when a mouse button has been released on a component.
     */
    public void mouseReleased(IDocumentTree tree, java.awt.event.MouseEvent e) {
        if (e.isPopupTrigger()) {
            Object node = tree.getSelectedNode().getUserObject();
            showEditingMenu(tree, node, e.getX(), e.getY());

        }
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 12:39:23 PM)
     */
    public void requestActions() {
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 12:39:23 PM)
     */
    public void requestComponents() {

    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 2:00:57 PM)
     * @param newActionLookup butterfly.actions.interfaces.IActionLookup
     */
    public void setActionLookup(
        butterfly.actions.interfaces.IActionLookup newActionLookup) {
        actionLookup_ = newActionLookup;
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 2:00:57 PM)
     * @param newComponentLookup butterfly.components.interfaces.IComponentLookup
     */
    public void setComponentLookup(
        butterfly.components.interfaces.IComponentLookup newComponentLookup) {
        componentLookup_ = newComponentLookup;
    }
    /**
     * Insert the method's description here.
     * Creation date: (11/25/2002 1:42:46 PM)
     * @param x int
     * @param y int
     */
    public void showEditingMenu(IDocumentTree tree, Object node, int x, int y) {
        if (rightClickMenu_ != null) {
            rightClickMenu_.removeAll();
        } else {
            rightClickMenu_ = new JPopupMenu();
        }
        buildEditingMenuForNode(tree, node, rightClickMenu_);
        rightClickMenu_.show((Component) tree, x, y);
    }
    /**
      * Called whenever an item in the tree has been collapsed.
      */
    public void treeCollapsed(
        IDocumentTree tree,
        javax.swing.event.TreeExpansionEvent event) {
    }
    /**
      * Called whenever an item in the tree has been expanded.
      */
    public void treeExpanded(
        IDocumentTree tree,
        javax.swing.event.TreeExpansionEvent event) {
    }
    /**
     * <p>Invoked after a node (or a set of siblings) has changed in some
     * way. The node(s) have not changed locations in the tree or
     * altered their children arrays, but other attributes have
     * changed and may affect presentation. Example: the name of a
     * file has changed, but it is in the same location in the file
     * system.</p>
     * <p>To indicate the root has changed, childIndices and children
     * will be null. </p>
     * 
     * <p>e.path() returns the path the parent of the changed node(s).</p>
     * 
     * <p>e.childIndices() returns the index(es) of the changed node(s).</p>
     */
    public void treeNodesChanged(
        IDocumentTree tree,
        javax.swing.event.TreeModelEvent e) {
    }
    /**
     * <p>Invoked after nodes have been inserted into the tree.</p>
     * 
     * <p>e.path() returns the parent of the new nodes
     * <p>e.childIndices() returns the indices of the new nodes in
     * ascending order.
     */
    public void treeNodesInserted(
        IDocumentTree tree,
        javax.swing.event.TreeModelEvent e) {
    }
    /**
     * <p>Invoked after nodes have been removed from the tree.  Note that
     * if a subtree is removed from the tree, this method may only be
     * invoked once for the root of the removed subtree, not once for
     * each individual set of siblings removed.</p>
     *
     * <p>e.path() returns the former parent of the deleted nodes.</p>
     * 
     * <p>e.childIndices() returns the indices the nodes had before they were deleted in ascending order.</p>
     */
    public void treeNodesRemoved(
        IDocumentTree tree,
        javax.swing.event.TreeModelEvent e) {
    }
    /**
     * <p>Invoked after the tree has drastically changed structure from a
     * given node down.  If the path returned by e.getPath() is of length
     * one and the first element does not identify the current root node
     * the first element should become the new root of the tree.<p>
     * 
     * <p>e.path() holds the path to the node.</p>
     * <p>e.childIndices() returns null.</p>
     */
    public void treeStructureChanged(
        IDocumentTree tree,
        javax.swing.event.TreeModelEvent e) {
    }
    public void valueChanged(
        IDocumentTree tree,
        javax.swing.event.TreeSelectionEvent e) {
    }
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#nodeEdited(Object, Object)
	 */
	public Object nodeEdited(Object obj, Object nval) {
		return nval;
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#getTreeCellEditorComponent(JTree, Object, boolean, boolean, boolean, int)
	 */
	public Component getTreeCellEditorComponent(
		JTree tree,
		Object value,
		boolean selected,
		boolean expanded,
		boolean leaf,
		int row) {
		return null;
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#isEditable(Object)
	 */
	public boolean isEditable(Object val) {
		return false;
	}

}
