/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DocumentCellEditor extends DefaultCellEditor {
	class ResizeHandler implements KeyListener{
	private JTextComponent text;
	private JTree tree;
	
	public ResizeHandler(JTree tr,JTextComponent te){
		tree=tr;
		text = te;
	}
	/**
	 * @see java.awt.event.KeyListener#keyPressed(KeyEvent)
	 */
	public void keyPressed(KeyEvent e) {
	}

	/**
	 * @see java.awt.event.KeyListener#keyReleased(KeyEvent)
	 */
	public void keyReleased(KeyEvent e) {
	}

	/**
	 * @see java.awt.event.KeyListener#keyTyped(KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
		if(e.getKeyChar()=='\n'){
			text.setPreferredSize(new Dimension(text.getPreferredSize().width,text.getPreferredSize().height+30));
			
			tree.repaint();	
			System.out.println("resized");
		}
		else{
			System.out.println("key:"+e.getKeyChar()+" code:"+e.getKeyCode());	
		}
	}

}
	/**
	 * Constructor for DocumentCellEditor.
	 * @param textField
	 */
	public DocumentCellEditor(JTextField textField) {
		super(textField);
	}

	/**
	 * Constructor for DocumentCellEditor.
	 * @param checkBox
	 */
	public DocumentCellEditor(JCheckBox checkBox) {
		super(checkBox);
	}

	/**
	 * Constructor for DocumentCellEditor.
	 * @param comboBox
	 */
	public DocumentCellEditor(JComboBox comboBox) {
		super(comboBox);
	}

	public DocumentCellEditor(final JTextArea textField,JTree tree){
		super(new JTextField());
		textField.setLineWrap(true);
		JScrollPane pane = new JScrollPane(textField){
			public Dimension getPreferredSize(){
				if(super.getPreferredSize().width < 400 ||
					super.getPreferredSize().height < 100){
						return new Dimension(400,100);	
					}
				return super.getPreferredSize();
			}	
		};
		//pane.setMinimumSize(new Dimension(400,100));
        editorComponent = pane;
		this.clickCountToStart = 2;
        delegate = new EditorDelegate() {
            public void setValue(Object value) {
		textField.setText((value != null) ? value.toString() : "");
            }
		
	    public Object getCellEditorValue() {
		return textField.getText();
	    }
	    
        };
		textField.addKeyListener(new ResizeHandler(tree,textField));
    	
	}
	
	

	/**
	 * @see javax.swing.CellEditor#stopCellEditing()
	 */
	public boolean stopCellEditing() {
		return super.stopCellEditing();
	}

	/**
	 * @see javax.swing.CellEditor#isCellEditable(EventObject)
	 */
	public boolean isCellEditable(EventObject event) {
		 if (event != null) {
            if (event.getSource() instanceof DocumentTree) {
                DocumentTree tree = (DocumentTree)event.getSource();
                if (event instanceof MouseEvent) {
                    TreePath path = tree.getPathForLocation(
                                         ((MouseEvent)event).getX(),
                                         ((MouseEvent)event).getY());
                             
                   if(path != null && path.getLastPathComponent() != null){
                   		return tree.isEditable(path.getLastPathComponent());
                   }
                }
            }
        }
		return true;
		//return super.isCellEditable(anEvent);
	}

}
