/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.statemachine.StateListenerManager;
import butterfly.statemachine.interfaces.IStateEventSource;
import butterfly.xmlview.gui.TreeGridUI;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditor;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditorLookup;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.INode;
/**
 * Insert the type's description here.
 * Creation date: (11/25/2002 12:34:08 PM)
 * @author: 
 */
public class DocumentTree
	extends JTree
	implements
		IComponent,
		IDocumentTree,
		IActionRequester,
		IComponentRequester,
		TreeSelectionListener,
		TreeModelListener,
		TreeExpansionListener,
		MouseListener,
		IStateEventSource,
		IDocumentListener,
		Runnable {
	private IComponentLookup componentLookup_;
	private Hashtable treeNodeLookup_;
	private IDocument document_;
	private IActionLookup actionLookup_;
	private ITreeEditorLookup treeEditorLookup_;
	private StateListenerManager listeners_ = new StateListenerManager();
	private Enumeration expandedPaths_;
	private boolean allowRegistration_ = true;
	//private static Logger //logger_ = Logger.getLogger(DocumentTree.class);

	class NumericPath extends java.util.Stack {
		public int nextNode() {
			Integer next = (Integer) pop();
			return next.intValue();
		}
		public void addNode(int node) {
			push(new Integer(node));
		}
		public String toString() {
			String str = "NumericPath: ";
			for (int i = 0; i < size(); i++) {
				str += elementAt(0) + ",";
			}
			return str;
		}

	}

	public Object nodeEdited(Object node, Object nval) {
		ITreeEditor ed = getTreeEditor(node);
		return ed.nodeEdited(node, nval);

	}
	/**
	 * DocumentTree constructor comment.
	 */
	public DocumentTree(DefaultTreeModel tnode) {
		super(tnode);
		
		javax.swing.ToolTipManager.sharedInstance().registerComponent(this);
		treeEditorLookup_ = new TreeEditorLookup();
		addTreeExpansionListener(this);
		addTreeSelectionListener(this);
		getTreeModel().addTreeModelListener(this);
		addMouseListener(this);
		setCellRenderer(new DocumentTreeCellRenderer());
		treeNodeLookup_ = new Hashtable();
		putClientProperty("JTree.lineStyle", "Angled");
		setBorder(javax.swing.BorderFactory.createEmptyBorder());
		setShowsRootHandles(true);

	}

	public void makeTableTree() {
		setUI(new TreeGridUI());
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/28/2002 10:26:09 PM)
	 * @param parent javax.swing.tree.DefaultMutableTreeNode
	 * @param node java.lang.Object
	 */
	public void addNode(DefaultMutableTreeNode parent, Object node) {
		
		ITreeEditor editor = getTreeEditor(node);
		if(node == null && parent == null || editor == null && parent==null){
			DefaultMutableTreeNode root = (DefaultMutableTreeNode)getModel().getRoot();
			Enumeration e= root.children();
			while(e.hasMoreElements()){
				getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)e.nextElement());
			}
		}
		if (editor != null) {
			editor.addNode(this, parent, node);
		} else {
			//logger_.debug("unable to handle node of class:" + node.getClass());
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/28/2002 10:26:09 PM)
	 * @param parent javax.swing.tree.DefaultMutableTreeNode
	 * @param node java.lang.Object
	 */
	public void addNode(
		DefaultMutableTreeNode parent,
		Object node,
		int index) {

		ITreeEditor editor = getTreeEditor(node);
		if (editor != null) {
			editor.addNode(this, parent, node, index);
		} else {
			//logger_.debug("unable to handle node of class:" + node.getClass());
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 5:55:51 PM)
	 * @param l butterfly.statemachine.interfaces.IStateEventListener
	 */
	public void addStateEventListener(
		butterfly.statemachine.interfaces.IStateEventListener l) {
		listeners_.addListener(l);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/6/2002 12:14:15 AM)
	 * @param node javax.swing.tree.DefaultMutableTreeNode
	 */
	public void expand(DefaultMutableTreeNode node) {
		TreePath path = new TreePath(node.getPath());
		expandPath(path);
	}

	public void expandAll(JTree tree, boolean expand) {
		TreeNode root = (TreeNode) tree.getModel().getRoot();

		// Traverse tree from root
		expandAll(tree, new TreePath(root), expand);
	}
	private void expandAll(JTree tree, TreePath parent, boolean expand) {
		// Traverse children
		TreeNode node = (TreeNode) parent.getLastPathComponent();
		if (node.getChildCount() >= 0) {
			for (Enumeration e = node.children(); e.hasMoreElements();) {
				TreeNode n = (TreeNode) e.nextElement();
				TreePath path = parent.pathByAddingChild(n);
				expandAll(tree, path, expand);
			}
		}

		// Expansion or collapse must be done bottom-up
		if (expand) {
			tree.expandPath(parent);
		} else {
			tree.collapsePath(parent);
		}
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (11/28/2002 4:00:02 PM)
	 */
	private void expandPath(NumericPath p) {
		DefaultMutableTreeNode curr =
			(DefaultMutableTreeNode) getTreeModel().getRoot();
		TreePath rpath = new TreePath(curr.getPath());
		expandPath(rpath);

		while (!p.isEmpty()) {
			int index = p.nextNode();
			if (index > -1 && index < curr.getChildCount()) {
				curr = (DefaultMutableTreeNode) curr.getChildAt(index);
				TreePath path = new TreePath(curr.getPath());
				expandPath(path);
			}
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/27/2002 9:11:59 PM)
	 */
	public void expandSavedPaths() {
		if (expandedPaths_ != null) {
			while (expandedPaths_.hasMoreElements()) {
				try {
					expandPath((NumericPath) expandedPaths_.nextElement());
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 5:55:51 PM)
	 * @param evt butterfly.statemachine.interfaces.IStateEvent
	 */
	public void fireStateEvent(
		butterfly.statemachine.interfaces.IStateEvent evt) {
		listeners_.fireEvent(evt);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:39:05 PM)
	 * @return butterfly.actions.interfaces.IActionLookup
	 */
	public butterfly.actions.interfaces.IActionLookup getActionLookup() {
		return actionLookup_;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 1:07:18 PM)
	 * @return butterfly.xmlview.gui.tree.interfaces.ITreeEditor
	 */
	public ITreeEditor getActiveTreeEditor() {
		DefaultMutableTreeNode node = getSelectedNode();
		if (node == null) {
			return null;
		}

		return treeEditorLookup_.getTreeEditor(node.getUserObject());
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:39:05 PM)
	 * @return butterfly.components.interfaces.IComponentLookup
	 */
	public butterfly
		.components
		.interfaces
		.IComponentLookup getComponentLookup() {
		return componentLookup_;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/26/2002 9:57:08 PM)
	 * @return javax.swing.tree.TreePath[]
	 */
	public TreePath[] getExpandedPaths() {
		Vector paths = new Vector();
		DefaultMutableTreeNode root =
			(DefaultMutableTreeNode) getTreeModel().getRoot();

		return null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/27/2002 11:08:38 PM)
	 * @param curr javax.swing.tree.DefaultMutableTreeNode
	 * @param paths java.util.Vector
	 */
	public void getExpandedPaths(DefaultMutableTreeNode curr, Vector paths) {
		DefaultMutableTreeNode child = null;
		TreePath currtoroot = new TreePath(curr.getPath());
		boolean childexpanded = false;
		for (int i = 0; i < curr.getChildCount(); i++) {
			child = (DefaultMutableTreeNode) curr.getChildAt(i);
			TreePath toroot = new TreePath(child.getPath());
			if (isExpanded(toroot)) {
				getExpandedPaths(child, paths);
				childexpanded = true;
			}
		}
		if (!childexpanded && isExpanded(currtoroot)) {
			paths.add(currtoroot);
		}

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/28/2002 3:51:14 PM)
	 * @param path javax.swing.tree.TreePath
	 */
	private NumericPath getNumericPath(TreePath tpath) {
		DefaultMutableTreeNode node =
			(DefaultMutableTreeNode) tpath.getLastPathComponent();
		DefaultMutableTreeNode parent =
			(DefaultMutableTreeNode) node.getParent();
		NumericPath path = new NumericPath();

		while (node != null) {
			if (parent != null) {
				path.addNode(parent.getIndex(node));
			}
			node = parent;
			if (node == null) {
				break;
			}
			parent = (DefaultMutableTreeNode) node.getParent();
			if (parent == null) {
				break;
			}
		}

		return path;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:34:08 PM)
	 * @return javax.swing.tree.DefaultMutableTreeNode
	 */
	public DefaultMutableTreeNode getSelectedNode() {
		return (DefaultMutableTreeNode) getLastSelectedPathComponent();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 3:39:14 PM)
	 * @return butterfly.xmlview.gui.tree.interfaces.ITreeEditor
	 * @param node java.lang.Object
	 */
	public butterfly.xmlview.gui.tree.interfaces.ITreeEditor getTreeEditor(
		java.lang.Object node) {
		////logger_.debug("tree editor lookup is "+treeEditorLookup_);
		ITreeEditor ed = treeEditorLookup_.getTreeEditor(node);
		if (ed == null) {
			//logger_.debug("no editor registered for: " + node);
		}
		if (ed != null) {
			ed.setActionLookup(getActionLookup());
			ed.setComponentLookup(getComponentLookup());
		}
		return ed;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:40:08 PM)
	 * @return butterfly.xmlview.gui.tree.interfaces.ITreeEditorLookup
	 */
	public butterfly
		.xmlview
		.gui
		.tree
		.interfaces
		.ITreeEditorLookup getTreeEditorLookup() {
		return treeEditorLookup_;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:34:08 PM)
	 * @return javax.swing.tree.DefaultTreeModel
	 */
	public javax.swing.tree.DefaultTreeModel getTreeModel() {
		return (DefaultTreeModel) getModel();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/1/2002 2:07:25 PM)
	 * @param node butterfly.xmlview.model.interfaces.INode
	 * @param tnode javax.swing.tree.DefaultMutableTreeNode
	 */
	public DefaultMutableTreeNode getTreeNode(Object node) {
		return (DefaultMutableTreeNode) treeNodeLookup_.get(node);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/5/2002 11:38:01 PM)
	 * @param evt butterfly.xmlview.model.interfaces.IDocumentEvent
	 */
	private volatile boolean running_ = false;
	private Vector updateQueue_ = new Vector();
	private Thread runner_ = new Thread(this,"Document Update Thread");
	public void handleDocumentEvent(IDocumentEvent evt){
		updateQueue_.add(evt);
		if(!running_){
			running_ = true;
			runner_.start();	
		}
		//handleDocumentEvent(evt,true);
	}
	public void run(){
		while(running_){
		while(updateQueue_.size()>0){
			IDocumentEvent e = (IDocumentEvent)updateQueue_.elementAt(0);
			updateQueue_.removeElementAt(0);
			handleDocumentEvent(e,true);
		}
		try{
			runner_.sleep(250);
		}catch(Exception e){
			e.printStackTrace();
		}
		}
	}
	
	
	public void handleDocumentEvent(IDocumentEvent evt,boolean dc) {
		//if(true){return;}
		//Profiler.start("DocumentTree.handleDocumentEvent()");
		//logger_.debug("handling a document event of type " + evt.getType());
		//saveExpandedPaths();
//		if(evt.getParent().getDocument()==null || evt.getChangedNode().getDocument()==null && evt.getType() == IDocumentEvent.NODES_ADDED){
//			return;
//		}
//		if(true){
//		//	if(evt.getParent().getDocument() != null){
//				TreeNode tnode = getTreeNode(evt.getParent());
//				TreeNode nparent = tnode.getParent();
//				getTreeModel().removeNodeFromParent((MutableTreeNode)tnode);
//				addNode((DefaultMutableTreeNode)nparent,evt.getParent());
//		//	}
//			return;
//		}
		
		if (evt.getType() == evt.MODEL_UPDATED) {

			removeAll();
			loadDocument(evt.getDocument());

		}
		else if (evt.getType() == evt.NODES_MOVED) {
			allowRegistration_=false;
					INode[] chng = evt.getChangedNodes();
					DefaultMutableTreeNode tnode = null;
					DefaultMutableTreeNode nparent = getTreeNode(evt.getChangedNode());
					DefaultMutableTreeNode tp = getTreeNode(evt.getParent());
					for(int i = 0; i < chng.length; i++){
						tnode = getTreeNode(chng[i]);
						if(tnode.getParent()==nparent){
							continue;
						}
						if(tnode != null){
						getTreeModel().removeNodeFromParent(tnode);
						getTreeModel().insertNodeInto(tnode,nparent,evt.getChangedIndex()+i);	
						}
					}
			allowRegistration_=true;
				}
		else if (evt.getType() == evt.NODES_REMOVED
			|| evt.getType() == evt.NODES_ADDED ){//|| evt.getType() == evt.NODES_MOVED) {
			//logger_.debug("children added :to tree");
			INode parent = evt.getParent();
			
			//logger_.debug("EventParent:" + parent);
			DefaultMutableTreeNode tparent = getTreeNode(parent);
			
			
			//logger_.debug("TreeParent:" + tparent);
			if (tparent != null) {
				//logger_.debug("updating the event's parent..");
				//Enumeration e = tparent.children();

				//logger_.debug("removing the children..");
				if (evt.getType() == evt.NODES_ADDED ) {
					//logger_.debug(
					//	"adding the new node:"
					//		+ evt.getChangedNode()
					//		+ " at index:"
					//		+ evt.getChangedIndex());
					addNode(
						tparent,
						evt.getChangedNode(),
						evt.getChangedIndex());
				} 
				
				else {
					//logger_.debug("removing the node");
					if (tparent.getChildCount() > evt.getChangedIndex()) {
						if(evt.getChangedNode() != null){
						DefaultMutableTreeNode rmv =
							(DefaultMutableTreeNode) tparent.getChildAt(
								evt.getChangedIndex());
						getTreeModel().removeNodeFromParent(rmv);
						}
						else{
							DefaultMutableTreeNode rmv = null;
							INode[] chng = evt.getChangedNodes();
							for(int i = 0; i < chng.length; i++){
							rmv =(DefaultMutableTreeNode) tparent.getChildAt(
								evt.getChangedIndex());
							getTreeModel().removeNodeFromParent(rmv);	
							}
						}
					}
				}
				//tparent.
				//for(int i = 0; i < parent.childCount(); i++){
				////while(e.hasMoreElements()){
				////logger_.debug("removed a node");
				//getTreeModel().removeNodeFromParent(getTreeNode(parent.childAt(i)));
				//}
				////logger_.debug("adding the children...");
				//for(int i = 0; i < parent.childCount(); i++){
				////logger_.debug("adding child:"+parent.childAt(i));
				//addNode(tparent,parent.childAt(i));
				//}
				//tparent.removeAllChildren();
				//INode[] nodes = evt.getChangedNodes();
				////logger_.debug("updating the effected children");
				//if (nodes != null) {
				//for (int i = 0; i < nodes.length; i++) {
				////logger_.debug("updating child:"+nodes[i]);
				//addNode(tparent, nodes[i]);
				//}
				//}
			} else {
				//logger_.debug("refreshing the tree since the parent of the event was not found.");
				removeAll();
				loadDocument(evt.getDocument());
			}
		}
		//if(evt.getType() == evt.NODES_CHANGED){

		//INode[] nodes = evt.getChangedNodes();
		//if (nodes != null) {
		//for (int i = 0; i < nodes.length; i++) {
		//DefaultMutableTreeNode currparent = getTreeNode(nodes[i]);
		//if(currparent == null){
		//return;
		//}
		//currparent = (DefaultMutableTreeNode)currparent.getParent();
		//if(currparent != null){
		//currparent.removeAllChildren();
		//}
		//addNode(currparent, nodes[i]);
		//}
		//}

		//}
		//Profiler.start("DocumentTree.handleDocumentEvent() - expand saved paths");
		//expandSavedPaths();
		//Profiler.end("DocumentTree.handleDocumentEvent() - expand saved paths");
		//Profiler.end("DocumentTree.handleDocumentEvent()");
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 3:26:08 PM)
	 * @param doc butterfly.xmlview.model.interfaces.IDocument
	 */
	public void loadDocument(IDocument doc) {
		if (document_ != null) {
			document_.removeDocumentListener(this);
		}
		document_ = doc;
		doc.addDocumentListener(this);
		INode root = doc.getRoot();
		addNode(null, root);
	}

	public void loadDocument(
		butterfly.xmlview.model.interfaces.IDocument doc,
		boolean showroot) {
		if (showroot) {
			loadDocument(doc);
			return;
		}
		if (document_ != null) {
			document_.removeDocumentListener(this);
		}
		document_ = doc;
		doc.addDocumentListener(this);
		INode root = doc.getRoot();
		addNode(null, root);
		setRootVisible(false);

		expand((DefaultMutableTreeNode) getTreeNode(root));
	}
	/**
	 * Invoked when the mouse has been clicked on a component.
	 */
	public void mouseClicked(java.awt.event.MouseEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.mouseClicked(this, e);
		}
	}
	/**
	 * Invoked when the mouse enters a component.
	 */
	public void mouseEntered(java.awt.event.MouseEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.mouseEntered(this, e);
		}
	}
	/**
	 * Invoked when the mouse exits a component.
	 */
	public void mouseExited(java.awt.event.MouseEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.mouseExited(this, e);
		}
	}
	/**
	 * Invoked when a mouse button has been pressed on a component.
	 */
	public void mousePressed(java.awt.event.MouseEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			//logger_.debug("forwarding a mouse pressed eventt o " + editor);
			editor.mousePressed(this, e);
		}
	}
	/**
	 * Invoked when a mouse button has been released on a component.
	 */
	public void mouseReleased(java.awt.event.MouseEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		//logger_.debug("forwarding a mouse event to:" + editor);
		if (editor != null) {
			editor.mouseReleased(this, e);
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/1/2002 2:07:25 PM)
	 * @param node butterfly.xmlview.model.interfaces.INode
	 * @param tnode javax.swing.tree.DefaultMutableTreeNode
	 */
	public void registerNode(Object node, DefaultMutableTreeNode tnode) {
		treeNodeLookup_.put(node, tnode);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 5:55:51 PM)
	 * @param l butterfly.statemachine.interfaces.IStateEventListener
	 */
	public void removeStateEventListener(
		butterfly.statemachine.interfaces.IStateEventListener l) {
		listeners_.removeListener(l);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:39:23 PM)
	 */
	public void requestActions() {
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:39:23 PM)
	 */
	public void requestComponents() {
		//treeEditorLookup_ = (ITreeEditorLookup)getComponentLookup().getComponent(ITreeEditorLookup.ROLE);	
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/27/2002 9:07:56 PM)
	 */
	public void saveExpandedPaths() {
		expandedPaths_ =
			getDescendantToggledPaths(new TreePath(getTreeModel().getRoot()));
		Vector v = new Vector();
		while (expandedPaths_.hasMoreElements()) {
			v.add(getNumericPath((TreePath) expandedPaths_.nextElement()));
		}
		expandedPaths_ = v.elements();
		//Vector v = new Vector();
		//getExpandedPaths((DefaultMutableTreeNode)getTreeModel().getRoot(),v);
		//expandedPaths_ = v.elements();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:39:05 PM)
	 * @param newActionLookup butterfly.actions.interfaces.IActionLookup
	 */
	public void setActionLookup(
		butterfly.actions.interfaces.IActionLookup newActionLookup) {
		actionLookup_ = newActionLookup;
		if (treeEditorLookup_ == null) {
			return;
		}
		if (treeEditorLookup_ instanceof IActionRequester) {
			((IActionRequester) treeEditorLookup_).setActionLookup(
				actionLookup_);
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:39:05 PM)
	 * @param newComponentLookup butterfly.components.interfaces.IComponentLookup
	 */
	public void setComponentLookup(
		butterfly.components.interfaces.IComponentLookup newComponentLookup) {
		componentLookup_ = newComponentLookup;
		if (treeEditorLookup_ == null) {
			return;
		}
		if (treeEditorLookup_ instanceof IComponentRequester) {
			((IComponentRequester) treeEditorLookup_).setComponentLookup(
				componentLookup_);
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 12:40:08 PM)
	 * @param newTreeEditorLookup butterfly.xmlview.gui.tree.interfaces.ITreeEditorLookup
	 */
	public void setTreeEditorLookup(
		butterfly
			.xmlview
			.gui
			.tree
			.interfaces
			.ITreeEditorLookup newTreeEditorLookup) {
		//logger_.debug("tree editor lookup set to " + newTreeEditorLookup);
		treeEditorLookup_ = newTreeEditorLookup;
	}
	/**
	  * Called whenever an item in the tree has been collapsed.
	  */
	public void treeCollapsed(javax.swing.event.TreeExpansionEvent event) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.treeCollapsed(this, event);
		}
	}
	/**
	  * Called whenever an item in the tree has been expanded.
	  */
	public void treeExpanded(javax.swing.event.TreeExpansionEvent event) {
		DefaultMutableTreeNode node =
			(DefaultMutableTreeNode) event.getPath().getLastPathComponent();
		ITreeEditor editor = getTreeEditor(node.getUserObject());
		////logger_.debug("forwarding an expansion event to "+editor);
		if (editor != null) {
			editor.treeExpanded(this, event);
		}
	}
	/**
	 * <p>Invoked after a node (or a set of siblings) has changed in some
	 * way. The node(s) have not changed locations in the tree or
	 * altered their children arrays, but other attributes have
	 * changed and may affect presentation. Example: the name of a
	 * file has changed, but it is in the same location in the file
	 * system.</p>
	 * <p>To indicate the root has changed, childIndices and children
	 * will be null. </p>
	 * 
	 * <p>e.path() returns the path the parent of the changed node(s).</p>
	 * 
	 * <p>e.childIndices() returns the index(es) of the changed node(s).</p>
	 */
	public void treeNodesChanged(javax.swing.event.TreeModelEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.treeNodesChanged(this, e);
		}
	}
	/**
	 * <p>Invoked after nodes have been inserted into the tree.</p>
	 * 
	 * <p>e.path() returns the parent of the new nodes
	 * <p>e.childIndices() returns the indices of the new nodes in
	 * ascending order.
	 */
	public void treeNodesInserted(javax.swing.event.TreeModelEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.treeNodesInserted(this, e);
		}
	}
	/**
	 * <p>Invoked after nodes have been removed from the tree.  Note that
	 * if a subtree is removed from the tree, this method may only be
	 * invoked once for the root of the removed subtree, not once for
	 * each individual set of siblings removed.</p>
	 *
	 * <p>e.path() returns the former parent of the deleted nodes.</p>
	 * 
	 * <p>e.childIndices() returns the indices the nodes had before they were deleted in ascending order.</p>
	 */
	public void treeNodesRemoved(javax.swing.event.TreeModelEvent e) {
		Object[] tnodes = e.getChildren();
		for (int i = 0; i < tnodes.length; i++) {
			DefaultMutableTreeNode tnode = (DefaultMutableTreeNode) tnodes[i];
			unRegisterNode(tnode.getUserObject());
			ITreeEditor editor = getTreeEditor(tnode.getUserObject());
			if (editor != null) {
				editor.treeNodesRemoved(this, e);
			}
		}
	}
	/**
	 * <p>Invoked after the tree has drastically changed structure from a
	 * given node down.  If the path returned by e.getPath() is of length
	 * one and the first element does not identify the current root node
	 * the first element should become the new root of the tree.<p>
	 * 
	 * <p>e.path() holds the path to the node.</p>
	 * <p>e.childIndices() returns null.</p>
	 */
	public void treeStructureChanged(javax.swing.event.TreeModelEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.treeStructureChanged(this, e);
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (12/1/2002 2:07:25 PM)
	 * @param node butterfly.xmlview.model.interfaces.INode
	 * @param tnode javax.swing.tree.DefaultMutableTreeNode
	 */
	public void unRegisterNode(Object node) {
		if(allowRegistration_){
		if (treeNodeLookup_.containsKey(node)) {
			treeNodeLookup_.remove(node);
		}
		}
	}
	/** 
	  * Called whenever the value of the selection changes.
	  * @param e the event that characterizes the change.
	  */
	public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
		ITreeEditor editor = getActiveTreeEditor();
		if (editor != null) {
			editor.valueChanged(this, e);
		}
		//	DocumentEditorStateEvent evt = new DocumentEditorStateEvent(null);
		//	evt.setType(evt.NODE_SELECTION_CHANGED);
		//	if(getSelectedNode() == null){return;}
		//	INode[] nodes = {((INode)getSelectedNode().getUserObject())};
		//	evt.setChangedNodes(nodes);
		//	listeners_.fireEvent(evt);
	}

	public void ensureVisible(Object key) {
		DefaultMutableTreeNode node = getTreeNode(key);
		if (node != null) {
			makeVisible(new TreePath(node.getPath()));
		}
	}
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.IDocumentTree#getSelectedNodes()
	 */

	public DefaultMutableTreeNode[] getSelectedTreeNodes() {
		TreePath[] sels = getSelectionPaths();
		if (sels == null) {
			return null;
		}
		DefaultMutableTreeNode[] nodes =
			new DefaultMutableTreeNode[sels.length];
		for (int i = 0; i < sels.length; i++) {
			nodes[i] =
				((DefaultMutableTreeNode) sels[i].getLastPathComponent());
		}
		return nodes;
	}

	public boolean isEditable(Object value) {
		if (value instanceof DefaultMutableTreeNode) {
			value = ((DefaultMutableTreeNode) value).getUserObject();
		}
		if(getTreeEditor(value)==null){
			return false;	
		}
		return getTreeEditor(value).isEditable(value);
	}

	public void expandColumn(int col) {
		DefaultMutableTreeNode curr =
			(DefaultMutableTreeNode) getModel().getRoot();
		TreePath path = new TreePath(curr.getPath());
		expandPath(path);
		expandChildren(curr,col);
	}
	
	public void expandChildren(DefaultMutableTreeNode curr,int levels){
		if(levels == 0){return;}
		Enumeration children = curr.children();
		while (children.hasMoreElements()) {
			DefaultMutableTreeNode child =
				(DefaultMutableTreeNode) children.nextElement();
			expandPath(new TreePath(child.getPath()));
			expandChildren(child,levels-1);
		}
	}
	
	public void expandLevel(DefaultMutableTreeNode curr){
		
		Enumeration children = curr.children();
		while (children.hasMoreElements()) {
			DefaultMutableTreeNode child =
				(DefaultMutableTreeNode) children.nextElement();
			if(!isExpanded(new TreePath(child.getPath()))){
				expandPath(new TreePath(child.getPath()));
			}
			else{
				expandLevel(child);
			}
		}
	}
	
	public void collapseLevel(DefaultMutableTreeNode curr){
		boolean collapse = false;
		Enumeration children = curr.children();
		while (children.hasMoreElements()) {
			DefaultMutableTreeNode child =
				(DefaultMutableTreeNode) children.nextElement();
			if(isExpanded(new TreePath(child.getPath()))){
				collapseLevel(child);
			}
			else if(!child.isLeaf() || curr.getChildCount() <=1){
				collapse=true;
			}
		}
		if(collapse){
			collapsePath(new TreePath(curr.getPath()));	
		}
	}

}
