/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import java.util.Vector;

import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;

import butterfly.xmlview.gui.tree.interfaces.IButterflyTreeNode;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditor;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DocumentTreeCellEditor implements TreeCellEditor {

	Vector listeners_ = new Vector();
	DocumentTree tree_;
	JTextComponent editor_;
	/**
	 * Constructor for DocumentTreeCellEditor.
	 */
	public DocumentTreeCellEditor(DocumentTree tree) {
		super();
		tree_ = tree;
	}

	/**
	 * @see javax.swing.tree.TreeCellEditor#getTreeCellEditorComponent(JTree, Object, boolean, boolean, boolean, int)
	 */
	public Component getTreeCellEditorComponent(
		JTree tree,
		Object value,
		boolean selected,
		boolean expanded,
		boolean leaf,
		int row) {
		JTextArea comp = null;
		if (value instanceof DefaultMutableTreeNode) {
			value = ((DefaultMutableTreeNode) value).getUserObject();
		}
		if (tree instanceof IDocumentTree) {
			ITreeEditor editor = ((IDocumentTree) tree).getTreeEditor(value);
			if (editor != null) {
				Component ecomp =
					editor.getTreeCellEditorComponent(
						tree,
						value,
						selected,
						expanded,
						leaf,
						row);

				if (ecomp != null) {
					return ecomp;
				}
			}
		}

		if (value instanceof IButterflyTreeNode) {
			comp =
				new JTextArea(
					value.toString());

		} else {
			comp = new JTextArea(value.toString());
		}
		comp.setPreferredSize(new Dimension(400,400));
		comp.setWrapStyleWord(true);
		if (selected) {
			//comp.set
			comp.setOpaque(true);
			comp.setBackground(java.awt.Color.cyan);
			//comp.setFont(comp.getFont().deriveFont(java.awt.Font.BOLD));
			//comp.setForeground(java.awt.Color.blue);
		}
		//comp.addKeyListener(new ResizeHandler(tree));
		return comp;
	}

	/**
	 * @see javax.swing.CellEditor#getCellEditorValue()
	 */
	public Object getCellEditorValue() {
		return editor_.getText();
	}

	/**
	 * @see javax.swing.CellEditor#isCellEditable(EventObject)
	 */
	public boolean isCellEditable(EventObject anEvent) {
		return true;
	}

	/**
	 * @see javax.swing.CellEditor#shouldSelectCell(EventObject)
	 */
	public boolean shouldSelectCell(EventObject anEvent) {
		return true;
	}

	/**
	 * @see javax.swing.CellEditor#stopCellEditing()
	 */
	public boolean stopCellEditing() {
		for (int i = 0; i < listeners_.size(); i++) {
			((CellEditorListener) listeners_.elementAt(i)).editingStopped(
				new ChangeEvent(this));
		}
		return true;
	}

	/**
	 * @see javax.swing.CellEditor#cancelCellEditing()
	 */
	public void cancelCellEditing() {
		for (int i = 0; i < listeners_.size(); i++) {
			((CellEditorListener) listeners_.elementAt(i)).editingCanceled(
				new ChangeEvent(this));
		}
	}

	/**
	 * @see javax.swing.CellEditor#addCellEditorListener(CellEditorListener)
	 */
	public void addCellEditorListener(CellEditorListener l) {
		listeners_.add(l);
	}

	/**
	 * @see javax.swing.CellEditor#removeCellEditorListener(CellEditorListener)
	 */
	public void removeCellEditorListener(CellEditorListener l) {
		listeners_.remove(l);
	}

}
