/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.JTree;
import java.awt.Component;
import java.awt.event.MouseEvent;

import butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderer;
import butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderingComponent;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditor;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import javax.swing.JLabel;
import butterfly.xmlview.gui.tree.interfaces.IButterflyTreeNode;
/**
 * Insert the type's description here.
 * Creation date: (11/27/2002 11:58:40 PM)
 * @author: 
 */
public class DocumentTreeCellRenderer extends DefaultTreeCellRenderer implements IInteractiveTreeCellRenderer{

private Object lastFocused_;
/**
 * DocumentTreeCellRenderer constructor comment.
 */
public DocumentTreeCellRenderer() {
	super();
}

public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
	JLabel comp = null;
	if(value instanceof DefaultMutableTreeNode){
		value = ((DefaultMutableTreeNode)value).getUserObject();
	}
	//System.out.println("value:"+value);
	if(tree instanceof IDocumentTree){
		ITreeEditor editor = ((IDocumentTree)tree).getTreeEditor(value);
		if(editor != null){
			Component ecomp = editor.getTreeCellRendererComponent((IDocumentTree)tree,value,selected,expanded,leaf,row,hasFocus);
			//System.out.println("editor"+editor);
			if(ecomp != null){
				return ecomp;
			}
		}
		
	}
	
	if(value instanceof IButterflyTreeNode){
		comp = new JLabel(value.toString(),((IButterflyTreeNode)value).getIcon(),JLabel.LEFT);
		
	}
	else{
		comp = new JLabel(value.toString());
	}
	if(selected){
			//comp.set
			comp.setOpaque(true);
			comp.setBackground(java.awt.Color.cyan);
			//comp.setFont(comp.getFont().deriveFont(java.awt.Font.BOLD));
			//comp.setForeground(java.awt.Color.blue);
	}
	return comp;
	
}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderer#mousePressed(javax.swing.JTree, java.lang.Object, java.awt.event.MouseEvent)
	 */
	public void mousePressed(JTree tree, Object value, MouseEvent me,int x, int y) {
		// TODO Auto-generated method stub
		//System.out.println("tree press x:"+me.getX()+" y:"+me.getY());
		if(value instanceof DefaultMutableTreeNode){
			value = ((DefaultMutableTreeNode)value).getUserObject();
		}
		if(tree instanceof IDocumentTree){
			ITreeEditor editor = ((IDocumentTree)tree).getTreeEditor(value);
			if(editor != null){
				Component ecomp = editor.getTreeCellRendererComponent((IDocumentTree)tree,value,selected,true,false,0,hasFocus);
				//System.out.println("editor"+editor);
				if(ecomp instanceof IInteractiveTreeCellRenderingComponent){
					((IInteractiveTreeCellRenderingComponent)ecomp).mousePressed(value,me,x,y);
				}
			}
			
		}
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderer#mouseReleased(javax.swing.JTree, java.lang.Object, java.awt.event.MouseEvent)
	 */
	public void mouseReleased(JTree tree, Object value, MouseEvent me,int x, int y) {
		if(value instanceof DefaultMutableTreeNode){
			value = ((DefaultMutableTreeNode)value).getUserObject();
		}
		if(tree instanceof IDocumentTree){
			ITreeEditor editor = ((IDocumentTree)tree).getTreeEditor(value);
			if(editor != null){
				Component ecomp = editor.getTreeCellRendererComponent((IDocumentTree)tree,value,selected,true,false,0,hasFocus);
				//System.out.println("editor"+editor);
				if(ecomp instanceof IInteractiveTreeCellRenderingComponent){
					((IInteractiveTreeCellRenderingComponent)ecomp).mouseReleased(value,me,x,y);
				}
			}
			
		}

	}

//	/* (non-Javadoc)
//	 * @see butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderer#focusGained()
//	 */
//	public void focusGained(JTree tree, Object value) {
//		if(value instanceof DefaultMutableTreeNode){
//			value = ((DefaultMutableTreeNode)value).getUserObject();
//		}
//		if(tree instanceof IDocumentTree){
//			ITreeEditor editor = ((IDocumentTree)tree).getTreeEditor(value);
//			if(editor != null){
//				Component ecomp = editor.getTreeCellRendererComponent((IDocumentTree)tree,value,selected,true,false,0,hasFocus);
//				//System.out.println("editor"+editor);
//				if(lastFocused_!= null){
//					focusLost(tree,lastFocused_);
//				}
//				if(ecomp instanceof IInteractiveTreeCellRenderingComponent){
//					lastFocused_=value;
//					((IInteractiveTreeCellRenderingComponent)ecomp).focusGained(value);
//				}
//			}
//			
//		}
//		
//	}
//
//	/* (non-Javadoc)
//	 * @see butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderer#focusLost()
//	 */
//	public void focusLost(JTree tree,Object value) {
//		if(value instanceof DefaultMutableTreeNode){
//			value = ((DefaultMutableTreeNode)value).getUserObject();
//		}
//		if(tree instanceof IDocumentTree){
//		ITreeEditor editor = ((IDocumentTree)tree).getTreeEditor(value);
//		if(editor != null){
//			Component ecomp = editor.getTreeCellRendererComponent((IDocumentTree)tree,value,selected,true,false,0,hasFocus);
//			//System.out.println("editor"+editor);
//			if(ecomp instanceof IInteractiveTreeCellRenderingComponent){
//				((IInteractiveTreeCellRenderingComponent)ecomp).focusLost(value);
//			}
//		}
//		
//		}
//
//	}

}
