/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DocumentTreeModel extends DefaultTreeModel{
		private DocumentTree tree_;
		/**
		 * Constructor for DocumentTreeModel.
		 * @param root
		 */
		public DocumentTreeModel(TreeNode root) {
			super(root);
			
		}
		
		

		/**
		 * Constructor for DocumentTreeModel.
		 * @param root
		 * @param asksAllowsChildren
		 */
		public DocumentTreeModel(TreeNode root, boolean asksAllowsChildren) {
			super(root, asksAllowsChildren);
		}
		
			/**
		 * @see javax.swing.tree.TreeModel#valueForPathChanged(TreePath, Object)
		 */
		public void valueForPathChanged(TreePath path, Object newValue) {
			DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
			Object val = node.getUserObject();
			newValue = tree_.nodeEdited(val,newValue);
			super.valueForPathChanged(path, newValue);
		}
		/**
		 * Returns the tree.
		 * @return DocumentTree
		 */
		public DocumentTree getTree() {
			return tree_;
		}

		/**
		 * Sets the tree.
		 * @param tree The tree to set
		 */
		public void setTree(DocumentTree tree) {
			tree_ = tree;
		}

	}
