/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.SAXException;

import sun.security.action.GetLongAction;

import butterfly.actions.GoToLineAction;
import butterfly.actions.contenthandlers.interfaces.IContentHandler;
import butterfly.actions.contenthandlers.interfaces.IContentHandlerLookup;
import butterfly.actions.interfaces.IDebugXslAction;
import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.actions.interfaces.IOpenInBrowserAction;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.interfaces.IBrowserManager;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.io.XmlViewFileSystem;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.pipeline.PipelineDocument;
import butterfly.xmlview.model.pipeline.PipelineNode;
import butterfly.xmlview.model.pipeline.ResultNode;
import butterfly.xmlview.model.pipeline.TransformationNode;
import butterfly.xmlview.model.transformation.DocumentResult;
import butterfly.xmlview.model.transformation.XSLTTransformation;
import butterfly.xmlview.model.transformation.interfaces.IPipelineListener;
import butterfly.xmlview.xslt.XsltDebugger;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PipelineTreeEditor extends XmlTreeEditor {
	class OpenInBrowserAction extends AbstractAction{
		private DocumentTree tree_;
		private String browser_;
		public OpenInBrowserAction(DocumentTree tree,String b){
			tree_ = tree;	
			putValue(NAME,"Open in Browser");
			browser_=b;
		}
		public void actionPerformed(ActionEvent ae) {
			DefaultMutableTreeNode node = tree_.getSelectedNode();
			DefaultTreeModel model = tree_.getTreeModel();
			INode el = (INode) node.getUserObject();
			
			IContentHandlerLookup handlerlookup =
			(IContentHandlerLookup) tree_.getComponentLookup().getComponent(IContentHandlerLookup.ROLE);
			//logger_.debug("looking up the content handler for the file extension: " + fext);
			//IContentHandler handler = handlerlookup.getContentHandlerForFiletype(".xml");
			IDocument doc = ((ResultNode)el).getResult();
//			try{
//				doc = handler.createDocument(doc.toString());
//			}catch(Exception e){}
			// sanity(doc.getRoot());
			//doc = new XmlDocument(doc.toString());
			if(doc.getName()==null){
				doc.setName(XmlViewFileSystem.newFileName("xml"));
			}
			doc.setExists(false);
			//handler.showDocument(doc);
			IOpenInBrowserAction open = (IOpenInBrowserAction)tree_.getActionLookup().getAction(IOpenInBrowserAction.ROLE);
			open.setDocument(doc);
			open.setBrowser(browser_);
			open.actionPerformed(null);
		}
	}
	
	class OpenForEditingAction extends AbstractAction{
		private DocumentTree tree_;
		public OpenForEditingAction(DocumentTree tree){
			tree_ = tree;	
			putValue(NAME,"Open for Editing");
		}
	public void actionPerformed(ActionEvent ae) {
		DefaultMutableTreeNode node = tree_.getSelectedNode();
			DefaultTreeModel model = tree_.getTreeModel();
			INode el = (INode) node.getUserObject();
			
			IContentHandlerLookup handlerlookup =
                (IContentHandlerLookup) tree_.getComponentLookup().getComponent(IContentHandlerLookup.ROLE);
            //logger_.debug("looking up the content handler for the file extension: " + fext);
            IContentHandler handler = handlerlookup.getContentHandlerForFiletype(".xml");
            IDocument doc = ((ResultNode)el).getResult();
            try{
            doc = handler.createDocument(doc.toString());
            }catch(Exception e){}
           // sanity(doc.getRoot());
            //doc = new XmlDocument(doc.toString());
            if(doc.getName()==null){
         		doc.setName(XmlViewFileSystem.newFileName("xml"));
            }
            handler.showDocument(doc);
            
	}
	
	public void sanity(INode node){
		if(!(node instanceof DocumentRoot)){
		IDocument doc = node.getDocument();
		System.out.println(">"+node.toString()+"<=>"+doc.toString().substring(node.getStart(),node.getStart()+node.getLength())+"<");
		}
		for(int i = 0; i < node.childCount(); i++){
			sanity(node.childAt(i));	
		}	
	}
	
	}
	
	
	class AddTransformationAction extends AbstractAction{
		private DocumentTree tree_;
		public AddTransformationAction(DocumentTree tree){
			tree_ = tree;	
			putValue(NAME,"Add XSL Transformation");
		}
	public void actionPerformed(ActionEvent ae) {
			//System.out.println("adding new node");
			DefaultMutableTreeNode node = tree_.getSelectedNode();
			DefaultTreeModel model = tree_.getTreeModel();
			INode el = (INode) node.getUserObject();
			INode parent = el.getParent();
			if (parent != null) {
				
				IFileChooseAction fc = (IFileChooseAction)getActionLookup().getAction(IFileChooseAction.ROLE);
				//String result =inform.displayFileQuery("Select the XSL file for the transformation.");
				//fc.s"Select the XSL file for the transformation."
				fc.actionPerformed(null);
				File file = fc.getSelectedFile();//getnew File(result);
				if(file==null){return;}
//				if(!file.exists()){
//					inform.displayError("Unable to load: "+result);
//					return;	
//				}
				
				Properties props =new Properties();
				props.setProperty(XSLTTransformation.XSL_PROPERTY,file.getAbsolutePath());
				XSLTTransformation trans = new XSLTTransformation();
				int where = parent.indexOfChild(el)+1;
				if(el instanceof PipelineNode){
					where = el.childCount();	
				}
				((PipelineDocument)el.getDocument()).getPipeline().addTransformation(where,trans,props);
				((PipelineDocument)el.getDocument()).addTransformation(where,trans,props);
			}
		}
		
	}
	class RemoveTransformationAction extends AbstractAction{
		private DocumentTree tree_;
		public RemoveTransformationAction(DocumentTree tree){
			tree_ = tree;	
			putValue(NAME,"Remove Transformation");
		}
		public void actionPerformed(ActionEvent ae) {
			//System.out.println("adding new node");
			DefaultMutableTreeNode node = tree_.getSelectedNode();
			DefaultTreeModel model = tree_.getTreeModel();
			INode el = (INode) node.getUserObject();
			INode parent = el.getParent();
			if (parent != null && el instanceof TransformationNode) {
				
				
				((PipelineDocument)el.getDocument()).removeTransformation(((TransformationNode)el).getTransformation());

			}
		}
		
	}
	class DebugAction extends RefreshAction{
		
			/**
		 * @param tree
		 */
		public DebugAction(DocumentTree tree) {
			super(tree);
			putValue(NAME,"Debug");
			// TODO Auto-generated constructor stub
		}
		public void actionPerformed(ActionEvent ae){
			DefaultMutableTreeNode node = getTree().getSelectedNode();
			ResultNode rnode = (ResultNode)node.getUserObject();
			//if(!(rnode.childAt(0) instanceof DocumentRoot)){
						TransformationNode trans = (TransformationNode)rnode.getParent();
			 PipelineDocument pdoc = (PipelineDocument)trans.getDocument();
			 String result = null;
			 int index=trans.getParent().indexOfChild(trans);
			 try{
			 	
			 result = pdoc.getPipeline().execute(index,null);
			 }catch(Exception e){
			 e.printStackTrace();
			 StringWriter writer = new StringWriter();
			 e.printStackTrace(new PrintWriter(writer));
			 result = "<error>"+writer.toString()+"</error>";
			 }
			 
			 XmlDocument doc = new XmlDocument(result);
			 doc.setName("Pipeline Result #"+index);
			 
			 Properties props = pdoc.getPipeline().propertiesAt(index);
			 String xfile = props.getProperty(XSLTTransformation.XSL_PROPERTY);
			 File file = new File(xfile);
			 IFileOpenAction open = (IFileOpenAction)getActionLookup().getAction(IFileOpenAction.ROLE);
			 open.setFile(file);
			 open.setShowFile(false);
			 open.actionPerformed(null);
			 XmlDocument xsl = (XmlDocument)open.getDocument();
			 if(xsl != null){
			 	IDebugXslAction debug = (IDebugXslAction)getActionLookup().getAction(IDebugXslAction.ROLE);
			 	debug.setInput(doc);
			 	debug.setXsl(xsl);
			 	debug.actionPerformed(null);
			 }
		}

}
	
	class RefreshAction extends AbstractAction{
		private DocumentTree tree_;
		public RefreshAction(DocumentTree tree){
			tree_ = tree;	
			putValue(NAME,"Refresh");
		}
	public IPipelineListener getPipelineListener(){
		return null;
	}
	
		
	public void actionPerformed(ActionEvent ae) {
			
			DefaultMutableTreeNode node = getTree().getSelectedNode();
			ResultNode rnode = (ResultNode)node.getUserObject();
			//if(!(rnode.childAt(0) instanceof DocumentRoot)){
/*			TransformationNode trans = (TransformationNode)rnode.getParent();
			PipelineDocument pdoc = (PipelineDocument)trans.getDocument();
			String result = null;
			try{
			result = pdoc.getPipeline().execute(trans.getParent().indexOfChild(trans)+1,getPipelineListener());
			}catch(Exception e){
				e.printStackTrace();
				StringWriter writer = new StringWriter();
				e.printStackTrace(new PrintWriter(writer));
				result = "<error>"+writer.toString()+"</error>";
			}
			XmlDocument doc = new XmlDocument(result);*/
//			doc.setName(XmlViewFileSystem.newFileName("xml"));
			//while(rnode.childCount()>0){
			//	pdoc.removeChild(rnode,rnode.childAt(0));	
			//}
			DefaultMutableTreeNode tnode = tree_.getTreeNode(rnode);
			DocumentTreeModel model=((DocumentTreeModel)tree_.getTreeModel());
			while(tnode.getChildCount()>0){
				model.removeNodeFromParent((DefaultMutableTreeNode)tnode.getChildAt(0));
			}
			Transformer transformer = new Transformer();
			transformer.listener=getPipelineListener();
			transformer.node=node;
			transformer.rnode=rnode;
			transformer.tree=getTree();
			Thread t = new Thread(transformer);
			t.start();
//			rnode.setResult(doc);
//			INode root = doc.getRoot();
//			for(int i = 0; i < root.childCount(); i++){
//				tree_.addNode(node,root.childAt(i));
//			}
			//pdoc.addChild(rnode,doc.getRoot(),0,false);
			//}
		}
		/**
		 * Returns the tree.
		 * @return DocumentTree
		 */
		public DocumentTree getTree() {
			return tree_;
		}

		/**
		 * Sets the tree.
		 * @param tree The tree to set
		 */
		public void setTree(DocumentTree tree) {
			tree_ = tree;
		}
	}

	ImageIcon resulticon = new ImageIcon("icons/result.jpg");
	JLabel resultLabel_ = new JLabel("Result",resulticon,JLabel.HORIZONTAL);	
	

	/**
	 * Constructor for PipelineTreeEditor.
	 */
	public PipelineTreeEditor() {
		super();
		resultLabel_.setFont(resultLabel_.getFont().deriveFont(Font.BOLD));
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#buildEditingMenuForNode(IDocumentTree, Object, JPopupMenu)
	 */
	public void buildEditingMenuForNode(
		IDocumentTree tree,
		Object node,
		JPopupMenu pop) {
		if(node instanceof PipelineNode){
			//Addtr
			AddTransformationAction add = new AddTransformationAction((DocumentTree)tree);
			
			pop.add(add);
			
		}
		if(node instanceof ResultNode){
			
			RefreshAction ref = new RefreshAction((DocumentTree)tree);
			pop.add(ref);
			DebugAction debug = new DebugAction((DocumentTree)tree);
			pop.add(debug);
			
			ResultNode res = (ResultNode)node;
			DefaultMutableTreeNode tnode = tree.getTreeNode(node);
			
			//Object val = ((DefaultMutableTreeNode)tnode.getChildAt(0)).getUserObject();
				//if(val instanceof DocumentRoot){
			pop.add(new OpenForEditingAction((DocumentTree)tree)).setEnabled(res.getResult()!=null);	
			
			IOpenInBrowserAction open = (IOpenInBrowserAction)((DocumentTree)tree).getActionLookup().getAction(IOpenInBrowserAction.ROLE);
			IBrowserManager bm = (IBrowserManager)((DocumentTree)tree).getComponentLookup().getComponent(IBrowserManager.ROLE);
			
			String[] browsers = bm.getBrowserNames();
			
			JMenu ob = new JMenu("Open in Browser");
			for(int i =0; i < browsers.length; i++){
				ob.add(new OpenInBrowserAction((DocumentTree)tree,browsers[i])).setText(browsers[i]);
			}
			pop.add(ob);
			ob.setEnabled(res.getResult()!=null);
			//}
			//if(res.getResult()!=null){
			//}
		}
		if(node instanceof TransformationNode){
			AddTransformationAction add = new AddTransformationAction((DocumentTree)tree);
			pop.add(add);
			RemoveTransformationAction remove = new RemoveTransformationAction((DocumentTree)tree);
			pop.add(remove);
		}
	}

	class Transformer implements Runnable,IDocumentListener{
		public ResultNode rnode;
		public IDocumentTree tree;
		public IPipelineListener listener;
		public DefaultMutableTreeNode node;
		public boolean debug=false;
		
		
		
		public void run(){
				XmlDocument doc = new XmlDocument();
				DocumentResult result = new DocumentResult(doc);
				doc.addDocumentListener(this);
				rnode.setResult(doc);
				TransformationNode trans = (TransformationNode)rnode.getParent();
				PipelineDocument pdoc = (PipelineDocument)trans.getDocument();
				//String result = null;
				
				try{
					//result = 
					pdoc.getPipeline().execute(trans.getParent().indexOfChild(trans)+1,result,listener);
				}catch(Exception e){
					e.printStackTrace();
					StringWriter writer = new StringWriter();
					e.printStackTrace(new PrintWriter(writer));
					
						int line =-1;
						int col = -1;
						e.printStackTrace();
						String msg = "Error:";
						if(e instanceof SAXException){
							SAXException se = (SAXException)e;
							msg=se.getMessage();
						}
						else if(e instanceof TransformerException){
							TransformerException te = (TransformerException)e;
							SourceLocator sl = te.getLocator();
							if(sl!=null){
							
								line = sl.getLineNumber();
								col = sl.getColumnNumber();
							}
							msg = te.getMessage();
						}else{
							msg = e.getMessage();
						}
						
							IXmlViewInformer informer = (IXmlViewInformer)ButterflyApplication.getInstance().getComponent(IXmlViewInformer.ROLE);
							informer.displayError(msg);
							
						if(line > -1){			
							GoToLineAction gotoline= (GoToLineAction)ButterflyApplication.getInstance().getAction("butterfly.actions.GoToLineAction");
							gotoline.setLine(line);
							gotoline.setColumn(col);
							gotoline.actionPerformed(null);			
						}
						
							
						
					
					//result = "<error>"+writer.toString()+"</error>";
				}
				
				doc.removeDocumentListener(this);
				//XmlDocument doc = new XmlDocument(result);
				//doc.setName(XmlViewFileSystem.newFileName("xml"));
//				DefaultMutableTreeNode tnode = tree.getTreeNode(rnode);
//				DocumentTreeModel model=((DocumentTreeModel)tree.getTreeModel());
//				while(tnode.getChildCount()>0){
//					model.removeNodeFromParent((DefaultMutableTreeNode)tnode.getChildAt(0));
//				}
//				rnode.setResult(doc);
//				INode root = doc.getRoot();
//				//tree.addNode(node,root);
//				for(int i = 0; i < root.childCount(); i++){
//					tree.addNode(node,root.childAt(i));
//				}
				//pdoc.addChild(rnode,doc.getRoot(),0,false);
			}
			
		/* (non-Javadoc)
		 * @see butterfly.xmlview.model.interfaces.IDocumentListener#handleDocumentEvent(butterfly.xmlview.model.interfaces.IDocumentEvent)
		 */
		public void handleDocumentEvent(IDocumentEvent evt) {
			// TODO Auto-generated method stub
			if(evt.getType()==IDocumentEvent.NODES_ADDED){
				DefaultMutableTreeNode tnode = tree.getTreeNode(evt.getChangedNode().getParent());
				if(tnode == null){
					tnode = node;
					if(tnode.getChildCount()>0){
						tree.getTreeModel().removeNodeFromParent((MutableTreeNode)tnode.getChildAt(0));
					}
				}
				tree.addNode(tnode,evt.getChangedNode());
			}
		}

		}
	
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#treeExpanded(IDocumentTree, TreeExpansionEvent)
	 */
	public void treeExpanded(IDocumentTree tree, TreeExpansionEvent event) {
		
		DefaultMutableTreeNode node =
			(DefaultMutableTreeNode) event.getPath().getLastPathComponent();
		if (node.getUserObject() instanceof ResultNode) {
			
			ResultNode rnode = (ResultNode)node.getUserObject();
			if(node.getChildCount()>0){
			if(((ResultNode)((DefaultMutableTreeNode)node).getUserObject()).getResult()==null){
			
			Transformer trans = new Transformer();
			trans.node=node;
			trans.rnode=rnode;
			trans.tree=tree;
			Thread t = new Thread(trans);
			t.start();
			/*TransformationNode trans = (TransformationNode)rnode.getParent();
			PipelineDocument pdoc = (PipelineDocument)trans.getDocument();
			
			
			String result = null;
			
			try{
			result = pdoc.getPipeline().execute(trans.getParent().indexOfChild(trans)+1);
			}catch(Exception e){
				e.printStackTrace();
				StringWriter writer = new StringWriter();
				e.printStackTrace(new PrintWriter(writer));
				result = "<error>"+writer.toString()+"</error>";
			}
			XmlDocument doc = new XmlDocument(result);
			//doc.setName(XmlViewFileSystem.newFileName("xml"));
			DefaultMutableTreeNode tnode = tree.getTreeNode(rnode);
			DocumentTreeModel model=((DocumentTreeModel)tree.getTreeModel());
			while(tnode.getChildCount()>0){
				model.removeNodeFromParent((DefaultMutableTreeNode)tnode.getChildAt(0));
			}
			rnode.setResult(doc);
			INode root = doc.getRoot();
			//tree.addNode(node,root);
			for(int i = 0; i < root.childCount(); i++){
				tree.addNode(node,root.childAt(i));
			}*/
			//pdoc.addChild(rnode,doc.getRoot(),0,false);
			}
			}
		}
		super.treeExpanded(tree, event);
	}

	
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#getTreeCellRendererComponent(IDocumentTree, Object, boolean, boolean, boolean, int, boolean)
	 */
	
	public Component getTreeCellRendererComponent(
		IDocumentTree tree,
		Object value,
		boolean selected,
		boolean expanded,
		boolean leaf,
		int row,
		boolean hasFocus) {
		if(value instanceof ResultNode){
			if(selected){
				resultLabel_.setBackground(Color.CYAN);
				resultLabel_.setOpaque(true);	
			}	
			else{
				resultLabel_.setOpaque(false);	
			}
			return resultLabel_;
		}
		 return super.getTreeCellRendererComponent(
			tree,
			value,
			selected,
			expanded,
			leaf,
			row,
			hasFocus);
	}

}
