/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Hashtable;

import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.actions.interfaces.IFileSaveAction;
import butterfly.statemachine.ProjectFileSelectionEvent;
import butterfly.xmlview.IProject;
import butterfly.xmlview.IProjectElement;
import butterfly.xmlview.IProjectFile;
import butterfly.xmlview.IProjectFolder;
import butterfly.xmlview.ProjectElement;
import butterfly.xmlview.ProjectFile;
import butterfly.xmlview.ProjectFolder;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.gui.tree.interfaces.IButterflyTreeNode;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.INode;
/**
 * Insert the type's description here.
 * Creation date: (11/25/2002 9:57:32 AM)
 * @author: 
 */
public class ProjectTreeEditor
	extends AbstractTreeEditor
	implements IDocumentListener, IActionRequester {
	private IActionLookup actionLookup_;
	private IDocumentTree tree_;
	private Hashtable documentLookup_;
	private static Icon folderIcon_ = null;
	private static Icon fileIcon_ = null;
	private static Logger logger_ = Logger.getLogger(ProjectTreeEditor.class);

	protected class DocumentTreeNode
		extends DefaultMutableTreeNode
		implements IButterflyTreeNode {
		private Icon icon_;
		public DocumentTreeNode(Object obj) {
			super(obj);
			icon_ = new ImageIcon("Document.gif");
		}
		public void setIcon(Icon i) {
			icon_ = i;
		}
		public Icon getIcon() {
			return icon_;
		}
	}

	protected class AddFileAction extends AbstractAction {

		private DefaultTreeModel treeModel_;
		private IProjectFolder selectedFolder_;
		private DefaultMutableTreeNode folderNode_;
		private IProjectFile projectFile_;

		public void setTreeModel(DefaultTreeModel model) {
			treeModel_ = model;
		}
		public void setProjectFolder(IProjectFolder folder) {
			selectedFolder_ = folder;
		}
		public void setFolderNode(DefaultMutableTreeNode node) {
			folderNode_ = node;
		}

		public void actionPerformed(java.awt.event.ActionEvent ae) {
			if(projectFile_ == null){
				try{
			IFileChooseAction choose =
				(IFileChooseAction) getActionLookup().getAction(
					IFileChooseAction.ROLE);
			choose.setMode(choose.OPEN_MODE);
			choose.actionPerformed(null);
			File file = choose.getSelectedFile();
			projectFile_ =
						new ProjectFile(file.getCanonicalPath());
				}catch(Exception e){e.printStackTrace();}
			
			}
			if (projectFile_ != null) {
				try {
					DefaultMutableTreeNode parent = null;
					

					selectedFolder_.addFile(projectFile_);
					parent = folderNode_;
					//(DefaultMutableTreeNode)nodeLookup_.get(selectedFolder_);

					DefaultMutableTreeNode tnode =
						new DefaultMutableTreeNode(projectFile_);
					//registerNode(pfile,tnode);
					//loadProject(getProject());
					//logger_.debug("Parent: "+parent+" of "+tnode);
					treeModel_.insertNodeInto(
						tnode,
						parent,
						parent.getChildCount());
					treeModel_.insertNodeInto(
						new DefaultMutableTreeNode("loading..."),
						tnode,
						0);
					//project_.setDirty(true);
					//logger_.debug("file added");
				} catch (Exception e) {
					//logger_.debug(e);
				}
			}
			projectFile_ = null;
		}

		/**
		 * Returns the projectFile.
		 * @return IProjectFile
		 */
		public IProjectFile getProjectFile() {
			return projectFile_;
		}

		/**
		 * Sets the projectFile.
		 * @param projectFile The projectFile to set
		 */
		public void setProjectFile(IProjectFile projectFile) {
			projectFile_ = projectFile;
		}

	}
	
	protected class RenameAction extends AbstractAction{
		
		private IProjectElement element_;
		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public RenameAction(IProjectElement el){
			element_ = el;	
		}
		
		public void actionPerformed(ActionEvent ae) {
						IXmlViewInformer informer =
				(IXmlViewInformer) getComponentLookup().getComponent(
					IXmlViewInformer.ROLE);
			String name =
				informer.displayQuery("Enter the new name for the folder");
			if (name != null) {
				if (name.length() > 1) {
					try {
						element_.setName(name);
					} catch (Exception e) {
						// logger_.debug(e);
					}
				}
			}
		}

		/**
		 * Returns the element.
		 * @return ProjectElement
		 */
		public IProjectElement getElement() {
			return element_;
		}

		/**
		 * Sets the element.
		 * @param element The element to set
		 */
		public void setElement(ProjectElement element) {
			element_ = element;
		}

	}
	
	protected class RemoveFileAction extends AbstractAction {
		//private IDocumentListener listener_;
		private DefaultTreeModel treeModel_;
		private IProjectFile selectedFile_;
		private DefaultMutableTreeNode fileNode_;
		public void setTreeModel(DefaultTreeModel model) {
			treeModel_ = model;
		}
		public void setProjectFile(IProjectFile folder) {
			selectedFile_ = folder;
		}
		public void setFileNode(DefaultMutableTreeNode node) {
			fileNode_ = node;
		}

		public void actionPerformed(java.awt.event.ActionEvent ae) {
			if (selectedFile_ != null) {

				//if(doc != null){
				//selectedFile_.getProject().removeDocumentListener(listener_);
				//}
				selectedFile_.getParentFolder().removeFile(selectedFile_);
				treeModel_.removeNodeFromParent(
					(DefaultMutableTreeNode) fileNode_);
				selectedFile_ = null;
				//project_.setDirty(true);
				//loadProject(project_);
			}
		}

	}
	protected class AddFolderAction extends AbstractAction {
		private DefaultTreeModel treeModel_;
		private IProjectFolder selectedFolder_;
		private DefaultMutableTreeNode folderNode_;

		public void setTreeModel(DefaultTreeModel model) {
			treeModel_ = model;
		}
		public void setProjectFolder(IProjectFolder folder) {
			selectedFolder_ = folder;
		}
		public void setFolderNode(DefaultMutableTreeNode node) {
			folderNode_ = node;
		}

		public void actionPerformed(java.awt.event.ActionEvent ae) {
			IXmlViewInformer informer =
				(IXmlViewInformer) getComponentLookup().getComponent(
					IXmlViewInformer.ROLE);
			String name =
				informer.displayQuery("Enter the name for the new folder");
			if (name != null) {
				if (name.length() > 1) {
					try {
						DefaultMutableTreeNode parent = null;
						ProjectFolder pfolder = new ProjectFolder(null, name);
						// if (selectedFolder_ != null) {
						selectedFolder_.addFolder(pfolder);
						// logger_.debug("Selected folder: "+selectedFolder_);
						// parent = (DefaultMutableTreeNode)nodeLookup_.get(selectedFolder_);
						parent = folderNode_;
						//logger_.debug("folder node:"+parent);
						//} else {
						//getProject().getRootFolder().addFolder(pfolder);
						//parent = (DefaultMutableTreeNode)nodeLookup_.get(getProject().getRootFolder());
						//}
						//loadProject(getProject());
						DefaultMutableTreeNode tnode =
							new DefaultMutableTreeNode(pfolder);
						//registerNode(pfolder,tnode);
						//loadProject(getProject());
						treeModel_.insertNodeInto(
							tnode,
							parent,
							parent.getChildCount());
						//project_.setDirty(true);
					} catch (Exception e) {
						// logger_.debug(e);
					}
				}
			}
		}

	}
	protected class RemoveFolderAction extends AbstractAction {

		//private JTree tree_;
		private DefaultTreeModel treeModel_;
		private IProjectFolder selectedFolder_;
		private DefaultMutableTreeNode folderNode_;
		public void actionPerformed(java.awt.event.ActionEvent ae) {
			if (selectedFolder_ != null) {
				//logger_.debug("removing folder "+selectedFolder_);
				selectedFolder_.getParentFolder().removeFolder(selectedFolder_);
				treeModel_.removeNodeFromParent(folderNode_);
				selectedFolder_ = null;
				//logger_.debug("updating browser");
				//project_.setDirty(true);
				//loadProject(project_);
			}

		}
		public void setTreeModel(DefaultTreeModel model) {
			treeModel_ = model;
		}
		public void setProjectFolder(IProjectFolder folder) {
			selectedFolder_ = folder;
		}
		public void setFolderNode(DefaultMutableTreeNode node) {
			folderNode_ = node;
		}
	}
	/**
	 * ProjectTreeEditor constructor comment.
	 */
	public ProjectTreeEditor(IDocumentTree tree) {
		super();
		tree_ = tree;
		documentLookup_ = new Hashtable();
		folderIcon_ = new ImageIcon("graphics/folder.gif");
		fileIcon_ = new ImageIcon("graphics/file.gif");
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 1:13:40 PM)
	 * @param pop javax.swing.JMenu
	 */
	public void buildEditingMenuForNode(
		butterfly.xmlview.gui.tree.interfaces.IDocumentTree tree,
		java.lang.Object node,
		javax.swing.JPopupMenu pop) {
		IProjectFolder selectedFolder = null;
		IProjectFile selectedFile = null;
		DefaultMutableTreeNode fileNode = null;
		DefaultMutableTreeNode folderNode = null;
		IProject project = null;
		folderNode = tree.getSelectedNode();
		if (folderNode != null) {
			if (folderNode.getUserObject() instanceof IProjectFile) {
				selectedFile = (IProjectFile) folderNode.getUserObject();
				fileNode = folderNode;
				folderNode = (DefaultMutableTreeNode) folderNode.getParent();
			}
			selectedFolder = (IProjectFolder) folderNode.getUserObject();
		}
		if (selectedFolder != null) {
			project = selectedFolder.getProject();
			System.out.println("project:"+project);
		}
		

		if (pop == null) {
			pop = new JPopupMenu();
		}
		IProjectElement pel = null;
		if(selectedFile != null){
			pel = selectedFile;
		}
		else{
			pel = selectedFolder;
		}
		pop.add(new RenameAction(pel)).setText("Rename");
		pop.addSeparator();
		if (node instanceof IProjectFolder) {
			AddFileAction addfile = new AddFileAction();
			addfile.setFolderNode(folderNode);
			addfile.setTreeModel(tree.getTreeModel());
			addfile.setProjectFolder(selectedFolder);
			pop.add(addfile).setText("Add File");
			
		}
		RemoveFileAction removefile = new RemoveFileAction();
		removefile.setProjectFile(selectedFile);
		removefile.setTreeModel(tree.getTreeModel());
		removefile.setFileNode(fileNode);
		pop.add(removefile).setText("Remove File");
		if (node instanceof IProjectFolder) {
			AddFolderAction addfolder = new AddFolderAction();
			addfolder.setProjectFolder(selectedFolder);
			addfolder.setFolderNode(folderNode);
			addfolder.setTreeModel(tree.getTreeModel());
			pop.add(addfolder).setText("Add Folder");

			RemoveFolderAction removefolder = new RemoveFolderAction();
			removefolder.setFolderNode(folderNode);
			removefolder.setProjectFolder(selectedFolder);
			removefolder.setTreeModel(tree.getTreeModel());
			pop.add(removefolder).setText("Remove Folder");
		}
		pop.addSeparator();
		IFileSaveAction save =
			(IFileSaveAction) getActionLookup().getAction(IFileSaveAction.ROLE);
		save.setDocument(project);
		pop.add((javax.swing.Action) save).setText("Save Project");

		if (node instanceof IProjectFolder) {
			if (selectedFile == null) {
				pop.getComponent(1).setEnabled(false);
			} else {
				pop.getComponent(1).setEnabled(true);
			}
			if (selectedFolder == null) {
				pop.getComponent(3).setEnabled(false);
			} else {
				pop.getComponent(3).setEnabled(true);
			}
			if (project != null) {
				// if (!project.isDirty()) {
				//    pop.getComponent(4).setEnabled(false);
				// } else {
				pop.getComponent(4).setEnabled(true);
				// }
			} else {
				pop.getComponent(4).setEnabled(false);
			}
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 10:02:01 AM)
	 * @return butterfly.actions.interfaces.IActionLookup
	 */
	public butterfly.actions.interfaces.IActionLookup getActionLookup() {
		return actionLookup_;
	}
	/**
	 * getActionsForNode method comment.
	 */
	public butterfly.actions.interfaces.IButterflyAction[] getActionsForNode(
		butterfly.xmlview.gui.tree.interfaces.IDocumentTree tree,
		java.lang.Object node) {
		return null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 9:57:32 AM)
	 * @return butterfly.actions.interfaces.IButterflyAction
	 * @param node java.lang.Object
	 */
	public butterfly.actions.interfaces.IButterflyAction[] getActionsForNode(
		javax.swing.JTree t,
		Object node) {
		return null;
	}
	JLabel render = new JLabel();
	ImageIcon foldericon = new ImageIcon("icons/package.jpg");
	ImageIcon fileicon = new ImageIcon("icons/stock_new-16.png");
	JLabel label = new JLabel();
	public java.awt.Component getTreeCellRendererComponent(
		IDocumentTree tree,
		Object value,
		boolean selected,
		boolean expanded,
		boolean leaf,
		int row,
		boolean hasFocus) {
		label.setText(value.toString());
		label.setIcon(null);
		label.setOpaque(false);
		label.setBackground(null);
		label.setToolTipText(null);
		if (value instanceof IProjectFile) {
			label.setIcon(fileicon);
			label.setFont(label.getFont().deriveFont(java.awt.Font.BOLD));
			label.setOpaque(false);
			//label.setBackground(java.awt.Color.lightGray);
			//label.setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.Color.black));
			if (selected) {
				label.setOpaque(true);
				label.setBackground(java.awt.Color.cyan);
			}
			return label;
		}
		if (value instanceof IProjectFolder) {
			//JLabel label =
			//	new JLabel(value.toString(), folderIcon_, JLabel.LEFT);
			label.setFont(label.getFont().deriveFont(java.awt.Font.BOLD));
			label.setOpaque(false);
			//label.setBackground(java.awt.color.)
			//label.setBackground(java.awt.Color.lightGray);
			//label.setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.Color.black));
			if (selected) {
				label.setOpaque(true);
				label.setBackground(java.awt.Color.cyan);
			}
			label.setIcon(foldericon);
			return label;
		}
		return null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 1:32:35 PM)
	 * @param evt butterfly.xmlview.model.interfaces.IDocumentEvent
	 */
	public void handleDocumentEvent(
		butterfly.xmlview.model.interfaces.IDocumentEvent evt) {
		System.out.println("eventid:"+evt.getType()+" node:"+evt.getChangedNode());
		if(evt.getType() == evt.NODES_ADDED){
			INode node = evt.getChangedNode();
			INode parent = evt.getParent();
			if(parent instanceof IProjectFolder &&
			    node instanceof IProjectFile){
				addFile((IProjectFolder)parent,(IProjectFile)node);    	
			}
		}
		//if(evt.getDocument() == null){return;}
		//tree_.saveExpandedPaths();
		//DefaultMutableTreeNode node =
		//(DefaultMutableTreeNode) documentLookup_.get(evt.getDocument());
		//DefaultTreeModel treeModel = tree_.getTreeModel();
		//Enumeration children = node.children();
		//while (children.hasMoreElements()) {
		//treeModel.removeNodeFromParent((DefaultMutableTreeNode) children.nextElement());
		//}
		////visitNode(treeModel,node, evt.getDocument().getRoot());
		//tree_.expandSavedPaths();

		//if (evt.getType() == evt.NODES_REMOVED || evt.getType() == evt.NODES_ADDED) {
		//logger_.debug("children added :to tree");
		//IMultiNode parent = (IMultiNode)evt.getParent();
		//logger_.debug("EventParent:"+parent);
		//DefaultMutableTreeNode tparent = tree_.getTreeNode(parent);
		//if (tparent != null) {
		//logger_.debug("updating the event's parent");
		//Enumeration e = tparent.children();
		//while(e.hasMoreElements()){
		//tree_.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)e.nextElement());
		//}
		//for(int i = 0; i < parent.childCount(); i++){
		////     logger_.debug("adding child:"+parent.childAt(i));
		////tree_.addNode(tparent,parent.childAt(i));
		//}
		////tparent.removeAllChildren();
		////INode[] nodes = evt.getChangedNodes();
		////logger_.debug("updating the effected children");
		////if (nodes != null) {
		////for (int i = 0; i < nodes.length; i++) {
		////logger_.debug("updating child:"+nodes[i]);
		////addNode(tparent, nodes[i]);
		////}
		////}
		//}
		//else{
		//// logger_.debug("refreshing the tree since the parent of the event was not found.");
		////tree_.removeAll();
		////loadDocument(evt.getDocument());
		//}
		//}

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 3:48:39 PM)
	 * @return javax.swing.tree.DefaultMutableTreeNode
	 * @param node java.lang.Object
	 */
	public DefaultMutableTreeNode makeNode(Object node) {
		if (node instanceof IProjectFile) {
			DefaultMutableTreeNode nnode = new DocumentTreeNode(node);
			nnode.add(new DefaultMutableTreeNode("loading..."));
			return nnode;
		}
		return super.makeNode(node);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 10:01:00 AM)
	 */
	public void requestActions() {
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 10:02:01 AM)
	 * @param newActionLookup butterfly.actions.interfaces.IActionLookup
	 */
	public void setActionLookup(
		butterfly.actions.interfaces.IActionLookup newActionLookup) {
		actionLookup_ = newActionLookup;
	}
	public void treeExpanded(
		IDocumentTree tree,
		javax.swing.event.TreeExpansionEvent event) {
		logger_.debug("project tree expanded");

		DefaultMutableTreeNode node =
			(DefaultMutableTreeNode) event.getPath().getLastPathComponent();
		if (node.getUserObject() instanceof IProjectFile) {
			DefaultTreeModel treeModel = tree.getTreeModel();
			if (((DefaultMutableTreeNode) node.getChildAt(0))
				.getUserObject()
				.equals("loading...")
				|| ((DefaultMutableTreeNode) node.getChildAt(0))
					.getUserObject()
					.equals(
					"Document source unavailable")) {
				//node.removeAllChildren();
				treeModel.removeNodeFromParent(
					(DefaultMutableTreeNode) node.getChildAt(0));

			} else {
				logger_.debug(
					((DefaultMutableTreeNode) node.getChildAt(0))
						.getUserObject());
			}
			if (node.isLeaf()) {
				try {
					IProjectFile file = (IProjectFile) node.getUserObject();

					IFileOpenAction action =
						(IFileOpenAction) getActionLookup().getAction(
							IFileOpenAction.ROLE);
					action.setShowFile(false);
					action.setFile(new File(file.getPath()));
					action.actionPerformed(null);
					IDocument doc = action.getDocument();
					if (tree instanceof IDocumentListener) {
						doc.addDocumentListener((IDocumentListener) tree);
					}
					documentLookup_.put(file, doc);
					documentLookup_.put(doc, node);
					logger_.debug("loading the document into the tree...");
					//  doc.addDocumentListener(this);
					// visitNode(treeModel,node,doc.getRoot());
					logger_.debug("docroot: " + doc.getRoot());
					tree.addNode(node, doc.getRoot());

				} catch (Exception e) {
					e.printStackTrace();
					logger_.debug("unable to load file into tree", e);
					// node.removeAllChildren();
					DefaultMutableTreeNode tnode =
						(DefaultMutableTreeNode) node;
					for (int i = 0; i < node.getChildCount(); i++) {
						treeModel.removeNodeFromParent(
							(DefaultMutableTreeNode) node.getChildAt(i));
					}
					treeModel.insertNodeInto(
						new DefaultMutableTreeNode("Document source unavailable"),
						node,
						node.getChildCount());
				}
			} else {
				logger_.debug("the file is already open.");
			}
		}
	}
	public void treeNodesRemoved(
		IDocumentTree tree,
		javax.swing.event.TreeModelEvent e) {
		Object[] nodes = e.getChildren();
		for (int i = 0; i < nodes.length; i++) {
			DefaultMutableTreeNode node = (DefaultMutableTreeNode) nodes[i];
			if (node.getUserObject() instanceof IProjectFile) {
				IDocument doc =
					(IDocument) documentLookup_.get(node.getUserObject());
				if (doc != null) {
					doc.removeDocumentListener(this);
				}
			}
		}
	}
	public void valueChanged(
		IDocumentTree tree,
		javax.swing.event.TreeSelectionEvent e) {

		DefaultMutableTreeNode node =
			(DefaultMutableTreeNode) e.getPath().getLastPathComponent();

		//if(!(node.getUserObject() instanceof IProjectElement)){
		//return;
		//}

		Object el = node.getUserObject();
		if (el instanceof IProjectFile) {
			ProjectFileSelectionEvent evt = new ProjectFileSelectionEvent(this);
			Hashtable table = new Hashtable();
			table.put("selected-file", ((IProjectFile) el).getPath());
			evt.setEventData(table);
			tree.fireStateEvent(evt);
		}

	}
	
	public void addFile(IProjectFolder parent, IProjectFile file){
		AddFileAction add = new AddFileAction();
		add.setProjectFile(file);
		add.setProjectFolder(parent);
		add.setFolderNode(tree_.getTreeNode(parent));
		add.actionPerformed(null);	
	}
	
	
}
