/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import javax.swing.tree.DefaultMutableTreeNode;

import butterfly.actions.interfaces.IFocusOnElementAction;
import butterfly.actions.interfaces.IFocusOnXPathAction;
import butterfly.xmlview.IProjectFile;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/25/2002 10:39:39 PM)
 * @author: 
 */
public class ProjectXmlTreeEditor extends XmlTreeEditor {
/**
 * ProjectXmlTreeEditor constructor comment.
 */
public ProjectXmlTreeEditor() {
	super();
}
public void valueChanged(
    IDocumentTree tree,
    javax.swing.event.TreeSelectionEvent e) {

    DefaultMutableTreeNode node =
        (DefaultMutableTreeNode) e.getPath().getLastPathComponent();

    //if(!(node.getUserObject() instanceof IProjectElement)){
    //return;
    //}

    Object el = node.getUserObject();
    if (el instanceof INode) {
        while (!(node.getUserObject() instanceof IProjectFile)) {
            node = (DefaultMutableTreeNode) node.getParent();
            if (node == null) {
                return;
            }
        }
        IProjectFile file = (IProjectFile) node.getUserObject();
        //IFileOpenAction getdoc = (IFileOpenAction)getActionLookup().getAction(IFileOpenAction.ROLE);
        IDocument doc = ((INode) el).getDocument();
        String xpath = "";
        if (el instanceof INode) {
           INode element = (ISourceNode)el;

           // xpath = element.getPath();//((IXmlDocument) doc).getXPath(element);
            if (element instanceof ISourceNode) {
                int index = ((ISourceNode) element).getStart();
                //System.out.println(
                    //"index:"
                        //+ index
                        //+ " calc-xpath:"
                        //+ xpath
                        //+ " parse-xpath:"
                        //+ butterfly.xmlview.model.XmlUtilities.indexToXPath(doc.toString(), index));
                IFocusOnElementAction act =
                    (IFocusOnElementAction) getActionLookup().getAction(
                        butterfly.actions.interfaces.IFocusOnElementAction.ROLE);
                act.setDocument(doc);
                act.setNode(element);
                act.actionPerformed(null);
                return;
            }
        } else {
            xpath = ((INode)el).getPath();//((IXmlDocument) doc).getXPath((IValueNode) el);
        }

        IFocusOnXPathAction act =
            (IFocusOnXPathAction) getActionLookup().getAction(IFocusOnXPathAction.ROLE);
        act.setDocument((IXmlDocument) doc);
        act.setXPath(xpath);

    }

}
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#getTreeCellRendererComponent(IDocumentTree, Object, boolean, boolean, boolean, int, boolean)
	 */
	

}
