/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.components.interfaces.IComponent;
import butterfly.components.interfaces.IComponentLookup;
import butterfly.components.interfaces.IComponentRequester;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditor;
import butterfly.xmlview.gui.tree.interfaces.ITreeEditorLookup;
/**
 * Insert the type's description here.
 * Creation date: (11/24/2002 5:47:16 PM)
 * @author: 
 */
public class TreeEditorLookup implements IComponent,ITreeEditorLookup, Configurable, IComponentRequester,IActionRequester {
	private Hashtable editors_;
	private ITreeEditor defaultEditor_;
	private Configuration configuration_;
	private IComponentLookup lookup_;
	private IActionLookup actionLookup_;
	private static Logger logger_ = Logger.getLogger(TreeEditorLookup.class);

	public static final String EDITOR_ROLE = "role";
	public static final String EDITOR_KEY = "key";
	public static final String DEFAULT_EDITOR = "default";
/**
 * TreeEditorLookup constructor comment.
 */
public TreeEditorLookup() {
	super();
	editors_ = new Hashtable();
}
/**
 * Insert the method's description here.
 * Creation date: (11/24/2002 5:52:25 PM)
 * @param conf org.apache.avalon.framework.configuration.Configuration
 */
public void buildLookup(Configuration conf) {
    try {
        String def = conf.getAttribute(DEFAULT_EDITOR);
        Configuration[] eds = conf.getChildren();
        for (int i = 0; i < eds.length; i++) {
            String role = eds[i].getAttribute(EDITOR_ROLE);
            String key = eds[i].getAttribute(EDITOR_KEY);
            Class keyc = Class.forName(key);
            ITreeEditor editor = (ITreeEditor) lookup_.getComponent(role);
            if (editor != null) {
                editors_.put(keyc, editor);
                if (role.equals(def)) {
                    defaultEditor_ = editor;
                }
            }
            logger_.debug("Added tree editor for role:"+role);
        }

    } catch (Exception e) {
        e.printStackTrace();
    }

}
/**
 * configure method comment.
 */
public void configure(org.apache.avalon.framework.configuration.Configuration arg1) throws org.apache.avalon.framework.configuration.ConfigurationException {
	configuration_ = arg1;	
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:22:18 AM)
 * @return butterfly.actions.interfaces.IActionLookup
 */
public butterfly.actions.interfaces.IActionLookup getActionLookup() {
	return actionLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/24/2002 5:47:16 PM)
 * @return butterfly.xmlview.gui.tree.interfaces.ITreeEditor
 * @param key java.lang.Object
 */
public butterfly.xmlview.gui.tree.interfaces.ITreeEditor getTreeEditor(Object key) {
	Enumeration keys = editors_.keys();
	ITreeEditor ed = null;
	while(keys.hasMoreElements()){
		Class c = (Class)keys.nextElement();
		//logger_.debug("Checking to see if "+c.getName()+" is assignable from "+key.getClass().getName());
		if(c.isAssignableFrom(key.getClass())){
			ed = (ITreeEditor)editors_.get(c);
			break;
		}
	}
	
	if(ed == null){
		ed = defaultEditor_;
	}
	return ed;
}
/**
 * Insert the method's description here.
 * Creation date: (11/24/2002 5:47:16 PM)
 * @param key java.lang.Object
 * @param ed butterfly.xmlview.gui.tree.interfaces.ITreeEditor
 */
public void registerTreeEditor(Class key, butterfly.xmlview.gui.tree.interfaces.ITreeEditor ed) {
	editors_.put(key,ed);	
}
/**
 * Insert the method's description here.
 * Creation date: (11/24/2002 5:47:16 PM)
 * @param key java.lang.Object
 * @param ed butterfly.xmlview.gui.tree.interfaces.ITreeEditor
 */
public void registerTreeEditor(Object key, butterfly.xmlview.gui.tree.interfaces.ITreeEditor ed) {
	editors_.put(key.getClass(),ed);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:22:10 AM)
 */
public void requestActions() {}
/**
 * Insert the method's description here.
 * Creation date: (11/24/2002 5:51:15 PM)
 */
public void requestComponents() {
	buildLookup(configuration_);	
}
/**
 * Insert the method's description here.
 * Creation date: (12/6/2002 12:22:18 AM)
 * @param newActionLookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup newActionLookup) {
	actionLookup_ = newActionLookup;
	if(editors_ == null){return;}
	Enumeration keys = editors_.keys();
	ITreeEditor ed = null;
	while(keys.hasMoreElements()){
		Class c = (Class)keys.nextElement();
		//logger_.debug("Checking to see if "+c.getName()+" is assignable from "+key.getClass().getName());
		//if(c.isAssignableFrom(key.getClass())){
			ed = (ITreeEditor)editors_.get(c);
			if(ed instanceof IActionRequester){
				((IActionRequester)ed).setActionLookup(actionLookup_);
			}
		//	break;
		//}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/24/2002 5:51:15 PM)
 * @param lookup butterfly.components.interfaces.IComponentLookup
 */
public void setComponentLookup(butterfly.components.interfaces.IComponentLookup lookup) {
	lookup_ = lookup;
	if(editors_ == null){return;}
	Enumeration keys = editors_.keys();
	ITreeEditor ed = null;
	while(keys.hasMoreElements()){
		Class c = (Class)keys.nextElement();
		//logger_.debug("Checking to see if "+c.getName()+" is assignable from "+key.getClass().getName());
		//if(c.isAssignableFrom(key.getClass())){
			ed = (ITreeEditor)editors_.get(c);
			if(ed instanceof IComponentRequester){
				((IComponentRequester)ed).setComponentLookup(lookup_);
			}
		//	break;
		//}
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/24/2002 5:47:16 PM)
 * @param key java.lang.Object
 * @param ed butterfly.xmlview.gui.tree.interfaces.ITreeEditor
 */
public void unRegisterTreeEditor(butterfly.xmlview.gui.tree.interfaces.ITreeEditor ed) {
	//editors_.remove()	
}
}
