/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.gui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import org.apache.log4j.Logger;

import butterfly.actions.ButterflyAction;
import butterfly.statemachine.StateEvent;
import butterfly.xmlview.gui.interfaces.IDocumentEditor;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.gui.tree.interfaces.IDocumentTree;
import butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderingComponent;
import butterfly.xmlview.gui.tree.interfaces.IXmlTreeEditor;
import butterfly.xmlview.model.CDataNode;
import butterfly.xmlview.model.Comment;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.ProcessingInstruction;
import butterfly.xmlview.model.TagInfo;
import butterfly.xmlview.model.ValueNode;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.ICDATANode;
import butterfly.xmlview.model.interfaces.IComment;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentDeclaration;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.IMultiNode;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IProcessingInstruction;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.ITagInfo;
import butterfly.xmlview.model.interfaces.IValidatedDocument;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;


/**
 * Insert the type's description here.
 * Creation date: (11/24/2002 6:14:24 PM)
 * @author: 
 */
public class XmlTreeEditor
	extends AbstractTreeEditor
	implements IXmlTreeEditor {
	private static Logger logger_ = Logger.getLogger(XmlTreeEditor.class);
	private XmlTreeEditor treeEditor_;

	private INode[] clipboard_ = new INode[0];

	private boolean showAttributes_ = false;
	private boolean allowUndeclaredElements_ = true;
	private boolean dropDownMenusEnabled_=false;
	private static final ImageIcon copyicon_ =new ImageIcon("icons/stock_copy-16.png");
	private static final ImageIcon pasteicon_ =new ImageIcon("icons/stock_paste-16.png");
	private static final ImageIcon cuticon_ =new ImageIcon("icons/stock_cut-16.png");
	private static final ImageIcon appendc_ =new ImageIcon("icons/stock_append-child-16.png");
	private static final ImageIcon appends_ =new ImageIcon("icons/stock_append-sib-16.png");
	private static final ImageIcon delete_ =new ImageIcon("icons/stock_delete-16.png");

	
	class CopyNodesAction extends NodeAction {

		/**
		 * Constructor for CopyNodesAction.
		 * @param tree
		 */
		public CopyNodesAction(IDocumentTree tree) {
			super(tree,copyicon_);
		}

		/**
		 * Constructor for CopyNodesAction.
		 */
		public CopyNodesAction() {
			super();
		}

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			//DefaultMutableTreeNode node = getTree().get
			//need to get the selected nodes
			//and put them into clipboard_
			DefaultMutableTreeNode[] nodes = getTree().getSelectedTreeNodes();
			if (nodes == null) {
				clipboard_ = new INode[0];
				return;
			}
			clipboard_ = new INode[nodes.length];
			for (int i = 0; i < nodes.length; i++) {
				clipboard_[i] = (INode) nodes[i].getUserObject();
			}
		}

	}

	class PasteNodesSibAction extends PasteNodesAction {
		public PasteNodesSibAction(IDocumentTree tree) {
			super(tree);
		}

		/**
		 * Constructor for PasteNodesAction.
		 */
		public PasteNodesSibAction() {
			super();
		}

		/**
		 * @see butterfly.xmlview.gui.tree.XmlTreeEditor.PasteNodesAction#getParent(INode)
		 */
		public INode getParent(INode sel) {
			return sel.getParent();
		}

		/**
		 * @see butterfly.xmlview.gui.tree.XmlTreeEditor.PasteNodesAction#where(INode, INode)
		 */
		public int where(INode node, INode node2) {
			return node.indexOfChild(node2) + 1;
		}

	}

	class PasteNodesAction extends NodeAction {

		/**
		 * Constructor for PasteNodesAction.
		 * @param tree
		 */
		public PasteNodesAction(IDocumentTree tree) {
			super(tree);
		}

		/**
		 * Constructor for PasteNodesAction.
		 */
		public PasteNodesAction() {
			super();
		}

		/**
		 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
		 */
		public void actionPerformed(ActionEvent e) {
			DefaultMutableTreeNode tnode = getTree().getSelectedNode();
			INode node = (INode) tnode.getUserObject();
			if (node != null) {
				int where = where(getParent(node), node);
				INode parent = getParent(node);
				IDocument doc = parent.getDocument();
				for (int i = 0; i < clipboard_.length; i++) {
					doc.addChild(
						parent,
						clipboard_[i].createCopy(true),
						where + i,
						true);
				}
			}
		}

		public int where(INode node, INode node2) {
			return 0;
		}

		public INode getParent(INode sel) {
			return sel;
		}

		/**
		 * @see butterfly.xmlview.gui.tree.XmlTreeEditor.NodeAction#getTree()
		 */

	}

	class AddChildAction extends AddElementAction {
		public AddChildAction(String name, IDocumentTree tree) {
			super(name, tree);
			this.putValue(this.SMALL_ICON,appendc_);
		}
		public int getIndex(INode parent, INode el) {
			return el.childCount();
		}
		/**
		 * @see butterfly.xmlview.gui.tree.XmlTreeEditor.AddElementAction#getParent(INode)
		 */
		public INode getParent(INode selectednode) {
			return selectednode;
		}

	}

	abstract class AddElementAction extends ElementAction {
		/**
		 * Constructor for AddElementAction.
		 * @param name
		 * @param tree
		 */
		public AddElementAction(String name, IDocumentTree tree) {
			super(name, tree);
		}

		/**
		 * Constructor for AddElementAction.
		 */
		public AddElementAction() {
			super();
		}

		public abstract INode getParent(INode selectednode);
		public abstract int getIndex(INode parent, INode el);
		public INode getNode(INode parent){
			TagInfo info = new TagInfo(ITagInfo.ELEMENT_TAG);
			info.setName(getElementName());
			INode element =
					((IValidatedDocument) parent.getDocument()).createNode(
						info);
			return element;
		}
		public void actionPerformed(ActionEvent ae) {
			DefaultMutableTreeNode[] nodes = getTree().getSelectedTreeNodes();
			DefaultTreeModel model = getTree().getTreeModel();
			
			DefaultMutableTreeNode node = null;
			for(int i = 0; i < nodes.length; i++){
			node = nodes[i];
			INode el = (INode) node.getUserObject();
			INode parent = getParent(el); //el.getParent();
			if (parent != null && parent instanceof IElement) {
				//Element element = new Element(getElementName());
				int index = getIndex(parent, el);
				//((IMultiNode)parent).indexOfChild(el);
//				TagInfo info = new TagInfo(ITagInfo.ELEMENT_TAG);
//				info.setName(getElementName());
//				INode element =
//					((IValidatedDocument) parent.getDocument()).createNode(
//						info);
				INode element = getNode(parent);
				parent.getDocument().addChild(parent, element, index, true);
				//System.out.println(parent.getDocument().toString());
				//((IMultiNode)parent).addChild(index,element);
				//String xpath = ((IXmlDocument)parent.getDocument()).getXPath((IElement)parent);
				//((IXmlDocument)parent.getDocument()).updateElement(getTree(),xpath,(IElement)parent);

			}
			}
		}
	}

	abstract class NodeAction extends ButterflyAction {
		private IDocumentTree tree_;

		public NodeAction(IDocumentTree tree) {

			tree_ = tree;
		}
		public NodeAction(IDocumentTree tree,Icon icon) {
			super(null,icon);
			tree_ = tree;
		}
		public NodeAction() {
		}

		public void setTree(IDocumentTree tree) {
			tree_ = tree;
		}
		public IDocumentTree getTree() {
			return tree_;
		}
		public DefaultMutableTreeNode getTreeNode() {
			DefaultMutableTreeNode node = getTree().getSelectedNode();
			return node;
		}
		public Object getUserObject() {
			DefaultMutableTreeNode node = getTreeNode();
			if (node != null) {
				return node.getUserObject();
			}
			return null;
		}
	}

	abstract class ElementAction extends NodeAction {
		private IDocumentTree tree_;
		private String elementName_;

		public ElementAction(String name, IDocumentTree tree) {
			super(tree);
			elementName_ = name;

		}
		public ElementAction() {
		}

		public void setElementName(String name) {
			elementName_ = name;
		}
		public String getElementName() {
			if (elementName_ == null) {
				IXmlViewInformer informer =
					(IXmlViewInformer) getComponentLookup().getComponent(
						IXmlViewInformer.ROLE);
				String name =
					informer.displayQuery("Enter the name for the new Element");
				return name;
			}
			return elementName_;
		}
		public String getName() {
			if (elementName_ != null) {
				return elementName_;
			}
			return "New Element";
		}

	}
	public class AddSiblingAfterAction extends AddElementAction {
		public AddSiblingAfterAction(String name, IDocumentTree tree) {
			super(name, tree);
			this.putValue(this.SMALL_ICON,appends_);
		}
		public int getIndex(INode parent, INode el) {
			return parent.indexOfChild(el) + 1;
		}
		/**
		 * @see butterfly.xmlview.gui.tree.XmlTreeEditor.AddElementAction#getParent(INode)
		 */
		public INode getParent(INode selectednode) {
			return selectednode.getParent();
		}

	}
	class AddSiblingBeforeAction extends ElementAction {
		public AddSiblingBeforeAction(String name, IDocumentTree tree) {
			super(name, tree);
		}
		public void actionPerformed(ActionEvent ae) {
			System.out.println("adding new node");
			DefaultMutableTreeNode node = getTree().getSelectedNode();
			DefaultTreeModel model = getTree().getTreeModel();
			INode el = (INode) node.getUserObject();
			INode parent = el.getParent();
			if (parent != null && parent instanceof IElement) {
				//Element element = new Element(getElementName());
				int index = ((IMultiNode) parent).indexOfChild(el);
				TagInfo info = new TagInfo(ITagInfo.ELEMENT_TAG);
				info.setName(getElementName());
				INode element =
					((IValidatedDocument) parent.getDocument()).createNode(
						info);
				parent.getDocument().addChild(parent, element, index, true);
				System.out.println(parent.getDocument().toString());
				//((IMultiNode)parent).addChild(index,element);
				//String xpath = ((IXmlDocument)parent.getDocument()).getXPath((IElement)parent);
				//((IXmlDocument)parent.getDocument()).updateElement(getTree(),xpath,(IElement)parent);

			}
		}
	}
	class RemoveElementAction extends RemoveNodeAction {
		public RemoveElementAction(IDocumentTree tree) {
			super(tree);
			putValue(this.SMALL_ICON,delete_);
		}

	}
	class RemoveNodeAction extends NodeAction {
		public RemoveNodeAction(IDocumentTree tree) {
			super(tree);
		}
		public void actionPerformed(ActionEvent ae) {
			DefaultMutableTreeNode[] nodes = getTree().getSelectedTreeNodes();
			//DefaultTreeModel model = getTree().getTreeModel();
			DefaultMutableTreeNode node = null;
			for(int i = 0; i < nodes.length; i++){
				node = nodes[i];
				INode el = (INode)node.getUserObject();
				INode parent = el.getParent();
				if(el.getDocument() != null && !(el instanceof DocumentRoot)){
					el.getDocument().removeChild(parent,el,true);
				}
			}
			//if(parent != null && parent instanceof IElement){
			//((IMultiNode)parent).removeChild(el);
			//String xpath = ((IXmlDocument)parent.getDocument()).getXPath((IElement)parent);
			//((IXmlDocument)parent.getDocument()).updateElement(getTree(),xpath,(IElement)parent);
			//model.removeNodeFromParent(node);
			//}
		}
	}

	class EditTextNodeAction extends NodeAction {
		public EditTextNodeAction(IDocumentTree tree) {
			super(tree);
		}
		public void actionPerformed(ActionEvent ae) {

			//IValueNode node = (IValueNode)getUserObject();
			//JTextArea pane = new JTextArea();
			//pane.setText(node.toString());
			//pane.setMinimumSize(new java.awt.Dimension(300,300));
			//pane.setRows(10);
			//Object[] message = {pane};
			//String[] options = {"Ok"};
			//int result = JOptionPane.showOptionDialog( 
			//(java.awt.Component)getTree(),                             // the parent that the dialog blocks 
			//message,                                    // the dialog message array 
			//"Enter the text for the node", // the title of the dialog window 
			//JOptionPane.DEFAULT_OPTION,                 // option type 
			//JOptionPane.INFORMATION_MESSAGE,            // message type 
			//null,                                       // optional icon, use null to use the default icon 
			//options,                                    // options string array, will be made into buttons 
			//options[0]                                  // option that should be made into a default button 
			//);
			//node.setData(pane.getText());
			//((IXmlDocument)node.getDocument()).updateElement(getTree(),((IXmlDocument)node.getDocument()).getXPath((IElement)node.getParent()),(IElement)node.getParent());
		}

	}
	/**
	 * XmlTreeEditor constructor comment.
	 */
	public XmlTreeEditor() {
		super();
		treeEditor_ = this;

	}
	
	public void buildAddSiblingMenuForNode(IDocumentTree tree,Object node, JPopupMenu pop){
		if (node instanceof IElement) {
			IElement el = (IElement) node;
			INode parent = el.getParent();
			//JMenu insert = new JMenu("Append");
			String[] siblings=new String[0];
			if (parent instanceof IElement) {
				siblings = getChildElementNames((IElement) parent);
			}
				List siblist = Arrays.asList(siblings);
				Collections.sort(siblist,String.CASE_INSENSITIVE_ORDER);
				siblings = (String[])siblist.toArray(new String[0]);
				//JMenu before = new JMenu("Insert Sibling (after)");
				JPopupMenu after = pop;
				//insert.add(before);
				//insert.add(after);
				int sibcount = 0;
				if (siblings != null) {
					sibcount = siblings.length;
					for (int i = 0; i < siblings.length; i++) {
						AddSiblingAfterAction af =
						new AddSiblingAfterAction(siblings[i], tree);
						//AddSiblingBeforeAction bf = new AddSiblingBeforeAction(siblings[i],tree);
						after.add(af).setText(af.getName());
						//before.add(bf).setText(bf.getName());
					}
				}
				AddSiblingAfterAction addspi = new AddSiblingAfterAction(null,tree){
					
					public INode getNode(INode parent){
						ProcessingInstruction pi= new ProcessingInstruction();
						pi.setTarget("New");
						pi.setValue("Processing Instruction");
						return pi;
					}	
				};
				after.add(addspi).setText("New Processing Instruction");
				AddSiblingAfterAction addsvn = new AddSiblingAfterAction(null,tree){
					
					public INode getNode(INode parent){
						return new ValueNode("Enter your text here.");
					}	
				};
				
				after.add(addsvn).setText("New Text Node");
				if(el.childCount()==1){
					if(el.childAt(0) instanceof ValueNode){
						addsvn.setEnabled(false);	
					}	
				}
				AddChildAction addcdata = new AddChildAction(null,tree){
					
					public INode getNode(INode parent){
						return new CDataNode();
					}	
				};
				after.add(addcdata).setText("New CDATA Section");
				AddSiblingAfterAction addscom = new AddSiblingAfterAction(null,tree){
					
					public INode getNode(INode parent){
						return new Comment("Enter your comment here");
					}	
				};
				after.add(addscom).setText("New Comment");
				if (allowsUndeclaredElements()) {
					AddSiblingAfterAction afn =
					new AddSiblingAfterAction(null, tree);
					//AddSiblingBeforeAction bfn = new AddSiblingBeforeAction(null,tree);

					//before.add(bfn).setText(bfn.getName());
					after.add(afn).setText(afn.getName());
				}
				if (sibcount == 0 && !allowsUndeclaredElements()) {
					after.setEnabled(false);
				}

				//pop.add(before);
				//pop.add(after);
				//pop.add(insert);
			}
		
	
	}
	
	public void buildAddChildMenuForNode(IDocumentTree tree,Object node, JPopupMenu pop){
		if (node instanceof IElement) {
			IElement el = (IElement) node;
			INode parent = el.getParent();
			//JMenu insert = new JMenu("Append");
			//if (parent instanceof IElement) {
				
			String[] children = getChildElementNames(el);
			List siblist = Arrays.asList(children);
			Collections.sort(siblist,String.CASE_INSENSITIVE_ORDER);
			children = (String[])siblist.toArray(new String[0]);
			int childcount = 0;
			JPopupMenu addchild = pop;
			if (children != null) {
				childcount = children.length;
				for (int i = 0; i < children.length; i++) {
					AddChildAction addc = new AddChildAction(children[i], tree);
					addchild.add(addc).setText(addc.getName());
				}
			}
			if (allowsUndeclaredElements()) {
				AddChildAction addcn = new AddChildAction(null, tree);
				addchild.add(addcn).setText(addcn.getName());
			} else {
				if (childcount == 0) {
					addchild.setEnabled(false);
				}
			}
			//insert.add(addchild);
			//pop.add(addchild);
			AddChildAction addpi = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					ProcessingInstruction pi= new ProcessingInstruction();
					pi.setTarget("New");
					pi.setValue("Processing Instruction");
					return pi;
				}	
			};
			addchild.add(addpi).setText("New Processing Instruction");
			AddChildAction addvn = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					return new ValueNode("Enter your text here.");
				}	
			};
			
			addchild.add(addvn).setText("New Text Node");
			if(el.childCount()==1){
				if(el.childAt(0) instanceof ValueNode){
					addvn.setEnabled(false);	
				}	
			}
			AddChildAction addcdata = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					return new CDataNode();
				}	
			};
			addchild.add(addcdata).setText("New CDATA Section");
			AddChildAction addcom = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					return new Comment("Enter your comment here");
				}	
			};
			addchild.add(addcom).setText("New Comment");
			}
		//}
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 1:13:57 PM)
	 * @param pop javax.swing.JMenu
	 */
	public void buildEditingMenuForNode(
		butterfly.xmlview.gui.tree.interfaces.IDocumentTree tree,
		java.lang.Object node,
		javax.swing.JPopupMenu pop) {
		logger_.debug("building editing menu for " + node);
		
		if (node instanceof IElement) {
			IElement el = (IElement) node;
			INode parent = el.getParent();
			//JMenu insert = new JMenu("Append");
			String[] siblings=new String[0];
			if (parent instanceof IElement) {
				siblings = getChildElementNames((IElement) parent);
			}
				List siblist = Arrays.asList(siblings);
				Collections.sort(siblist,String.CASE_INSENSITIVE_ORDER);
				siblings = (String[])siblist.toArray(new String[0]);
				//JMenu before = new JMenu("Insert Sibling (after)");
				JMenu after = new JMenu("Append Sibling");
				//insert.add(before);
				//insert.add(after);
				int sibcount = 0;
				if (siblings != null) {
					sibcount = siblings.length;
					for (int i = 0; i < siblings.length; i++) {
						AddSiblingAfterAction af =
							new AddSiblingAfterAction(siblings[i], tree);
						//AddSiblingBeforeAction bf = new AddSiblingBeforeAction(siblings[i],tree);
						after.add(af).setText(af.getName());
						//before.add(bf).setText(bf.getName());
					}
				}
				AddSiblingAfterAction addspi = new AddSiblingAfterAction(null,tree){
					
					public INode getNode(INode parent){
						ProcessingInstruction pi= new ProcessingInstruction();
						pi.setTarget("New");
						pi.setValue("Processing Instruction");
						return pi;
					}	
				};
				after.add(addspi).setText("New Processing Instruction");
				AddSiblingAfterAction addsvn = new AddSiblingAfterAction(null,tree){
					
					public INode getNode(INode parent){
						return new ValueNode("Enter your text here.");
					}	
				};
				
				after.add(addsvn).setText("New Text Node");
				if(el.childCount()==1){
					if(el.childAt(0) instanceof ValueNode){
						addsvn.setEnabled(false);	
					}	
				}
				AddSiblingAfterAction addsdata = new AddSiblingAfterAction(null,tree){
					
					public INode getNode(INode parent){
						return new CDataNode();
					}	
				};
				after.add(addsdata).setText("New CDATA Section");
				AddSiblingAfterAction addscom = new AddSiblingAfterAction(null,tree){
					
					public INode getNode(INode parent){
						return new Comment("Enter your comment here");
					}	
				};
				after.add(addscom).setText("New Comment");
				if (allowsUndeclaredElements()) {
					AddSiblingAfterAction afn =
						new AddSiblingAfterAction(null, tree);
					//AddSiblingBeforeAction bfn = new AddSiblingBeforeAction(null,tree);

					//before.add(bfn).setText(bfn.getName());
					after.add(afn).setText(afn.getName());
				}
				if (sibcount == 0 && !allowsUndeclaredElements()) {
					after.setEnabled(false);
				}

				//pop.add(before);
				pop.add(after);
				//pop.add(insert);
		//	}
			String[] children = getChildElementNames(el);
			siblist = Arrays.asList(children);
			Collections.sort(siblist,String.CASE_INSENSITIVE_ORDER);
			children = (String[])siblist.toArray(new String[0]);
			int childcount = 0;
			JMenu addchild = new JMenu("Append Child");
			if (children != null) {
				childcount = children.length;
				for (int i = 0; i < children.length; i++) {
					AddChildAction addc = new AddChildAction(children[i], tree);
					addchild.add(addc).setText(addc.getName());
				}
			}
			if (allowsUndeclaredElements()) {
				AddChildAction addcn = new AddChildAction(null, tree);
				addchild.add(addcn).setText(addcn.getName());
			} else {
				if (childcount == 0) {
					addchild.setEnabled(false);
				}
			}
			//insert.add(addchild);
			pop.add(addchild);
			AddChildAction addpi = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					ProcessingInstruction pi= new ProcessingInstruction();
					pi.setTarget("New");
					pi.setValue("Processing Instruction");
					return pi;
				}	
			};
			addchild.add(addpi).setText("New Processing Instruction");
			AddChildAction addvn = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					return new ValueNode("Enter your text here.");
				}	
			};
			
			addchild.add(addvn).setText("New Text Node");
			if(el.childCount()==1){
				if(el.childAt(0) instanceof ValueNode){
					addvn.setEnabled(false);	
				}	
			}
			AddChildAction addcdata = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					return new CDataNode();
				}	
			};
			addchild.add(addcdata).setText("New CDATA Section");
			AddChildAction addcom = new AddChildAction(null,tree){
				
				public INode getNode(INode parent){
					return new Comment("Enter your comment here");
				}	
			};
			addchild.add(addcom).setText("New Comment");
			//pop.add(addchild);

			
			pop.addSeparator();
			pop.add(new CopyNodesAction(tree)).setText("Copy Nodes");
			JMenu paste = new JMenu("Paste Nodes");
			PasteNodesAction pastec = new PasteNodesAction(tree);
			paste.add(pastec).setText("Append as Children");
			PasteNodesSibAction pastes = new PasteNodesSibAction(tree);
			paste.add(pastes).setText("Append as Siblings");
			pop.add(paste).setText("Paste Nodes");
			paste.setEnabled(clipboard_.length > 0);
			pop.addSeparator();
			pop.add(new RemoveElementAction(tree)).setText("Delete");

		}
		if (node instanceof IValueNode) {
			//pop.add(new EditTextNodeAction(tree)).setText("Edit Text");
			pop.add(new RemoveElementAction(tree)).setText("Delete");
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/25/2002 1:13:57 PM)
	 * @return butterfly.actions.interfaces.IButterflyAction
	 * @param node java.lang.Object
	 */
	public butterfly.actions.interfaces.IButterflyAction[] getActionsForNode(
		butterfly.xmlview.gui.tree.interfaces.IDocumentTree tree,
		java.lang.Object node) {
		return null;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/27/2002 1:13:17 PM)
	 * @return java.lang.String[]
	 * @param el butterfly.xmlview.model.interfaces.IElement
	 */
	public String[] getChildElementNames(IElement el) {
		IXmlDocument doc = (IXmlDocument) el.getDocument();
		if (doc == null) {
			return null;
		}
		IElementStructure structure = null;
		try {
			structure =
				doc.getElementStructure(el.getLocalName(), el.getNameSpace());

		} catch (Exception e) {
		}
		if (structure == null) {
			return null;
		}
		String[] children = new String[structure.subElementCount()];
		for (int i = 0; i < children.length; i++) {
			children[i] = structure.subElementAt(i).getName();
		}
		return children;
	}

	JTextArea ta = new JTextArea();
	JLabel comp =new JLabel(){
		public Dimension getPreferredSize(){
			Dimension pref = super.getPreferredSize();
			if(pref.width < 400){
				pref.width=400;	
			}	
			return pref;
		}	
	};
	
	
	
	ElementLabel ecomp = new ElementLabel();
	class ElementLabel extends RenderingComponent{
		private JLabel label_;
		private Object key_;
		private JLabel sib_;
		private JLabel child_;
		
		public ElementLabel(){
			setLayout(new GridBagLayout());
			label_=new JLabel();
			GridBagConstraints cons = new GridBagConstraints();
			cons.fill=cons.NONE;
			cons.gridy=0;
			cons.gridx=0;
			cons.gridwidth=1;
			cons.gridheight=1;
			cons.weightx=0;
			cons.weighty=1;
			cons.ipadx=25;
			add(label_,cons);
			cons.weightx=0;
			cons.fill=cons.NONE;
			cons.gridx++;
			cons.gridy=0;
			cons.ipadx=2;
			child_=new JLabel(new ImageIcon("icons/add_child.png"));
			add(child_,cons);
			cons.gridx++;
			cons.ipadx=2;
			sib_=new JLabel(new ImageIcon("icons/add_sib.png"));
			add(sib_,cons);
			cons.weightx=1;
			cons.fill=cons.BOTH;
			cons.gridx++;
			JPanel fill = new JPanel();
			fill.setOpaque(false);
			add(fill,cons);
			setOpaque(false);
			label_.setOpaque(false);
		}
		
		
		public void setIcon(Icon icon){
			label_.setIcon(icon);
		}
		public void setText(String txt){
			label_.setText(txt);
		}
		public Dimension getPreferredSize(){
			Dimension pref = super.getPreferredSize();
			if(pref.width < 400){
				pref.width=400;	
			}	
			return pref;
		}	
		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderingComponent#mousePressed(java.lang.Object, java.awt.event.MouseEvent)
		 */
	
		private JPopupMenu pop_ = new JPopupMenu();
		public void componentActivated(Object key, Component comp, Rectangle bounds, MouseEvent me,int x, int y){
			if(comp == child_ || comp== sib_){
				if(comp == child_){
					pop_.removeAll();
					buildAddChildMenuForNode(tree_,key,pop_);
				}
				else if(comp == sib_){
					pop_.removeAll();
					buildAddSiblingMenuForNode(tree_,key,pop_);
				}
				pop_.setLocation(bounds.x+x,bounds.y+y+bounds.height);
				pop_.setVisible(true);
				
			}
			else{
				pop_.setVisible(false);
			}
		}

		public void closeMenu(){
			pop_.setVisible(false);
		}

		/* (non-Javadoc)
		 * @see butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderingComponent#focusLost(java.lang.Object)
		 */
		public void focusLost(Object val) {
			// TODO Auto-generated method stub
			pop_.setVisible(false);
		}

	}
	ImageIcon elementicon = new ImageIcon("icons/element.jpg");
	ImageIcon scratchicon = new ImageIcon("icons/scratchtag.jpg");
	ImageIcon proicon = new ImageIcon("icons/pi.jpg");
	ImageIcon comicon = new ImageIcon("icons/comment.jpg");
	ImageIcon rooticon = new ImageIcon("icons/documentroot.gif");
	private FocusListener focusListener_;
	private IDocumentTree tree_;
	public Component getTreeCellRendererComponent(
		IDocumentTree tree,
		Object value,
		boolean selected,
		boolean expanded,
		boolean leaf,
		int row,
		boolean hasFocus) {
		tree_=tree;
		comp.setIcon(null);
		comp.setToolTipText(null);
		if (value instanceof IValueNode
			&& !(value instanceof IScratchTag)
			|| value instanceof IComment) {

			ta.setText(value.toString());
			ta.setOpaque(false);
			ta.setBackground(null);
			if (tree instanceof JTree) {
				if (!((JTree) tree).isEditable()) {
					if (selected) {
						//comp.set
						ta.setOpaque(true);
						ta.setBackground(java.awt.Color.cyan);
					
						//comp.setFont(comp.getFont().deriveFont(java.awt.Font.BOLD));
						//comp.setForeground(java.awt.Color.blue);
					}
					ta.setForeground(Color.DARK_GRAY);
					//ta.add(new JLabel(comicon));
				}
				
			}
			if(((INode)value).hasWarningMarkers()){
				ta.setForeground(Color.MAGENTA);
			}
			else{
				ta.setForeground(Color.BLACK);	
			}
			//ta.setPreferredSize(new Dimension(400,ta.getPreferredSize().height));
			//JTextArea ta= new JTextArea(value.toString());	
			//ta.setBorder(new LineBorder(Color.gray));
			return ta;
		}

		comp.setText(value.toString());
		comp.setForeground(Color.BLACK);
		//JLabel comp = new JLabel(value.toString());
		if (value instanceof IElement && !showAttributes_) {
			comp.setText(((IElement) value).getName());
		}
		if (value instanceof IElement && showAttributes_) {
			String val = value.toString();
			val = val.trim();
			val = val.substring(1, val.length() - 1);
			comp.setText(val);
		}
		//IXmlDocument doc = (IXmlDocument)((INode)value).getDocument();
		String xpath = null;
		if (value instanceof IElement) {
			comp.setForeground(java.awt.Color.blue);
			comp.setIcon(elementicon);
			//xpath = doc.getXPath((IElement)value);
			//if(xpath != null){
			//comp.setToolTipText("XPath: "+xpath);
			//}
		}
		if(value instanceof DocumentRoot){
			comp.setIcon(rooticon);	
		}
		
		if (value instanceof IScratchTag) {
			comp.setForeground(java.awt.Color.red);
			comp.setIcon(scratchicon);
			comp.setToolTipText(((IScratchTag) value).getErrorMessage());
		} else if (value instanceof INode) {
			IMarker[] markers = ((INode) value).getMarkers();
			if (markers != null) {
				String msg = "<html>";
				for (int i = 0; i < markers.length; i++) {
					msg
						+= markers[i].getMessage().replaceAll(
							"[\\<]",
							"&lt;").replaceAll(
							"[\\>]",
							"&gt;")
						+ "<br> ";

				}
				msg += "</html>";
				comp.setToolTipText(msg);
				comp.setOpaque(true);
				comp.setBackground(Color.MAGENTA);
			}
		}
		if(value instanceof IProcessingInstruction || value instanceof IDocumentDeclaration){
			comp.setIcon(proicon);	
		}
		if(value instanceof IComment){
			comp.setIcon(comicon);	
		}

		//	else if(value instanceof IValueNode){
		//		JTextArea comp2 = new JTextArea(value.toString());
		//		if(selected){
		//		comp2.setOpaque(true);
		//		comp2.setBackground(java.awt.Color.cyan);
		//		}
		//		//xpath = doc.getXPath((IValueNode)value);
		//		//if(xpath != null){
		//			//comp.setToolTipText("XPath: "+xpath);
		//		//}
		//	}
		if (selected) {
			//comp.set
			comp.setOpaque(true);
			comp.setBackground(java.awt.Color.cyan);
			//comp.setFont(comp.getFont().deriveFont(java.awt.Font.BOLD));
			//comp.setForeground(java.awt.Color.blue);
		} else {
			comp.setOpaque(false);
			comp.setBackground(null);
		}
		
		if(((INode)value).hasWarningMarkers()){
				comp.setForeground(Color.magenta);
			}
			else{
				comp.setForeground(Color.black);	
		}
		if(value instanceof IElement && dropDownMenusEnabled_){
			ecomp.setText(((IElement)value).getName());
			ecomp.setIcon(elementicon);
			if(selected){
				ecomp.setOpaque(true);
				ecomp.setBackground(java.awt.Color.cyan);
			}
			else{
				ecomp.setOpaque(false);
			}
			ecomp.setKey(value);
			if(focusListener_==null){
				focusListener_=new FocusListener() {
					public void focusGained(FocusEvent e) {
						// TODO Auto-generated method stub

					}

					public void focusLost(FocusEvent e) {
						// TODO Auto-generated method stub
						ecomp.closeMenu();
					}
				};
				((JTree)tree).addFocusListener(focusListener_);
			}
			//panel.setSize(comp.getPreferredSize().width)
			return ecomp;
		}

		return comp;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/29/2002 6:04:14 PM)
	 * @param tree butterfly.xmlview.gui.tree.interfaces.IDocumentTree
	 * @param evt javax.swing.event.TreeModelEvent
	 */
	public void treeNodesChanged(
		IDocumentTree tree,
		javax.swing.event.TreeModelEvent e) {
		logger_.debug("updating tree nodes");

		//DefaultMutableTreeNode node;
		//node = (DefaultMutableTreeNode)
		//(e.getTreePath().getLastPathComponent());

		//try {
		//int index = e.getChildIndices()[0];
		//node = (DefaultMutableTreeNode)
		//(node.getChildAt(index));
		//} catch (NullPointerException exc) {
		//return;    
		//}

		//String xmlnode = (String)node.getUserObject();
		//INode oldl = null;
		//IMultiNode parent = null;
		//DefaultMutableTreeNode tparent = ((DefaultMutableTreeNode)node.getParent());
		//if(tparent == null){
		////the root is being edited....need to handle this
		//}
		//else{
		//int index = tparent.getIndex(node);
		//parent = (IMultiNode)tparent.getUserObject();
		//oldl = parent.childAt(index);
		//}

		//if(oldl == null){
		//return;
		//}
		//if(oldl instanceof IElement){
		//IElement nel = ElementParser.parseElement(xmlnode);

		//IElement current = (IElement)oldl;

		//if(nel != null){
		//String xpath = ((IXmlDocument)parent.getDocument()).getXPath(current);
		//current.setName(nel.getName());
		//current.clearAttributes();
		//for(int i = 0; i < nel.attributeCount(); i++){
		//current.addAttribute(nel.attributeAt(i));
		//}
		//((IXmlDocument)parent.getDocument()).updateElementTag(xpath,current);
		//}
		//node.setUserObject(current);
		////logger_.debug("updating model..");

		//}
		//if(oldl instanceof IValueNode){
		//IValueNode vnode = (IValueNode)oldl;
		//vnode.setData(xmlnode);
		//String xpath = ((IXmlDocument)parent.getDocument()).getXPath(vnode);
		//((IXmlDocument)parent.getDocument()).updateElementText(xpath,vnode);
		//node.setUserObject(vnode);
		//}

	}
	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#valueChanged(IDocumentTree, TreeSelectionEvent)
	 */
	public void valueChanged(IDocumentTree tree, TreeSelectionEvent e) {
		DefaultMutableTreeNode tnode =
			(DefaultMutableTreeNode) e.getPath().getLastPathComponent();
		INode node = (INode) tnode.getUserObject();
		logger_.debug("selected:" + node);
		StateEvent se =
			new StateEvent(IDocumentEditor.NODE_SELECTION_EVENT, tree);
		Hashtable data = new Hashtable();
		data.put(IDocumentEditor.SELECTED_NODE_KEY, node);
		se.setEventData(data);
		tree.fireStateEvent(se);
		//		if (node instanceof ISourceNode) {
		//              //  int index = ((ISourceNode) element).getStart();
		//                //System.out.println(
		//                    //"index:"
		//                        //+ index
		//                        //+ " calc-xpath:"
		//                        //+ xpath
		//                        //+ " parse-xpath:"
		//                        //+ butterfly.xmlview.model.XmlUtilities.indexToXPath(doc.toString(), index));
		//                IFocusOnElementAction act =
		//                    (IFocusOnElementAction) getActionLookup().getAction(
		//                        butterfly.actions.interfaces.IFocusOnElementAction.ROLE);
		//                act.setDocument(node.getDocument());
		//                act.setNode(node);
		//                act.actionPerformed(null);
		//               // return;
		//            }
	}

	/**
	 * Returns the showAttributes.
	 * @return boolean
	 */
	public boolean attributesAreShowing() {
		return showAttributes_;
	}

	/**
	 * Sets the showAttributes.
	 * @param showAttributes The showAttributes to set
	 */
	public void setShowAttributes(boolean showAttributes) {
		showAttributes_ = showAttributes;

	}

	/**
	 * Returns the allowUndeclaredElements.
	 * @return boolean
	 */
	public boolean allowsUndeclaredElements() {
		return allowUndeclaredElements_;
	}

	/**
	 * Sets the allowUndeclaredElements.
	 * @param allowUndeclaredElements The allowUndeclaredElements to set
	 */
	public void setAllowUndeclaredElements(boolean allowUndeclaredElements) {
		allowUndeclaredElements_ = allowUndeclaredElements;
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#nodeEdited(Object, Object)
	 */
	public Object nodeEdited(Object obj, Object nval) {
		
		INode node = (INode) obj;
		XmlDocument doc = (XmlDocument) node.getDocument();
//		if (obj instanceof IValueNode && !(nval instanceof ICDATANode)) {
//			String val=(String)nval;
//			if(val.indexOf("<")>0 || val.indexOf(">") >0){
//				XmlDocument tdoc = new XmlDocument(val);
//				INode old = (INode)obj;
//				INode parent = old.getParent();
//				doc.removeChild(parent,old,true);
//				INode root = tdoc.getRoot();
//				INode curr = null;
//				for(int i = 0; i < root.childCount(); i++){
//					curr = root.childAt(i);
//					
//					doc.addChild(parent,curr,i,true);
//				}
//				return curr;
//			}

//		}
		
		if(obj instanceof ICDATANode){
			String val = nval.toString();
//			val = val.replaceAll("\\!\\[CDATA\\[","");
//			logger_.debug("ends with:"+val);
//			if(val.trim().endsWith("]]")){
//				val = val.substring(0,val.lastIndexOf("]]"));
//			}
			((ICDATANode)obj).setData(val);
			doc.updateNode(((ICDATANode)obj));
			return obj;
		}
		
		if(nval instanceof String){
			String val = ""+nval;
			if(val.length() < 1){
				doc.removeChild(node.getParent(),node,true);	
				return "";
			}	
			else{
				nval = nval.toString().replaceAll("[<>]","");
					
			}
			
		}
		
		
		
		
		if (obj instanceof IValueNode) {
			((IValueNode) obj).setData(nval);

		}
		if (obj instanceof Comment) {
			String val = "" + nval;
			val = val.replaceAll("<[\\!][\\-]{2}", "");
			val = val.replaceAll("[\\-]{2}>", "");
			val = val.replaceAll("[\\-]{2}", "");
			if(val.trim().startsWith("!")){
				val = val.trim().substring(1);
			}
			((Comment) obj).setText("<!--"+val.trim()+"-->");
		}
		if (obj instanceof IElement) {
			String name = nval.toString().trim();
			if (name.startsWith("<") && name.endsWith(">")) {
				int end = name.length() - 1;
				int sp = name.indexOf(" ");
				if (sp > -1) {
					end = sp;
				}
				name = name.substring(1, end);
			}

			if (name.indexOf(" ") >= 0
				|| name.indexOf("<") >= 0
				|| name.indexOf(">") >= 0
				|| name.indexOf("&") >= 0
				|| name.indexOf("\"") >= 0
				|| name.indexOf("\'") >= 0
				|| name.indexOf("\\") >= 0
				|| name.indexOf("/") >= 0
				|| name.indexOf("?") >= 0) {
				return obj;
			}
			System.out.println("setting name to:" + name);
			((IElement) obj).setName(nval.toString());
		}
		if(obj instanceof IProcessingInstruction){
			//((IProcessingInstruction)obj).
		}
		if (obj instanceof IDTDNode) {
			return obj;
		}
		doc.updateNode(node, true);
		return obj;
	}

	/**
	 * @see butterfly.xmlview.gui.tree.interfaces.ITreeEditor#isEditable(Object)
	 */
	public boolean isEditable(Object obj) {
		if (obj instanceof IScratchTag) {
			return false;
		}
		if (obj instanceof IValueNode) {
			return true;
		}
		if (obj instanceof IComment) {
			return true;
		}
		return super.isEditable(obj);
	}

	/**
	 * @return Returns the dropDownMenusEnabled_.
	 */
	public boolean dropDownMenusAreEnabled() {
		return dropDownMenusEnabled_;
	}

	/**
	 * @param dropDownMenusEnabled_ The dropDownMenusEnabled_ to set.
	 */
	public void setDropDownMenusEnabled(boolean dropDownMenusEnabled) {
		this.dropDownMenusEnabled_ = dropDownMenusEnabled;
	}

}
