/*
 * Created on Jun 17, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package butterfly.xmlview.gui.xrender;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.IValueNode;

/**
 * @author Jules White
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class BasicLabelRenderer extends NodeRenderer implements ActionListener{
	private JPanel panel_;
	private JPanel titleArea_;
	private JComponent startTag_;
	private JButton collapse_ = new JButton("[-]");
	private Insets childInsets_=new Insets(0,20,0,0);
	private GridBagConstraints constraints_=new GridBagConstraints(0,0,1,1,1,1,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0);
	private boolean showChildren_=true;
	
	public BasicLabelRenderer(NodeRenderer parent,INode node) {
		super(parent,node);
		collapse_.addActionListener(this);
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.xrender.NodeRenderer#getRenderingComponent()
	 */
	public JComponent getRenderingComponent() {
		if(panel_==null){
			panel_=new JPanel();
			panel_.setBorder(new LineBorder(Color.black));
			panel_.setLayout(new GridBagLayout());
			constraints_.gridx=0;
			constraints_.fill=GridBagConstraints.NONE;
			titleArea_=new JPanel();
			titleArea_.setLayout(new GridBagLayout());
			titleArea_.setBackground(Color.LIGHT_GRAY);
			if(getNode().childCount()>0){
				titleArea_.add(collapse_,constraints_);
			}
			startTag_=renderStart(getNode());	
			constraints_.fill=GridBagConstraints.BOTH;
			constraints_.gridx=1;
			titleArea_.add(startTag_,constraints_);
			constraints_.gridwidth=2;
			panel_.add(titleArea_,constraints_);
			constraints_.gridwidth=1;
			int last = 0;
			if(getNode().childCount()>0){
				NodeRenderer[] children = getChildren();
				constraints_.insets=childInsets_;
				for(int i = 0; i < children.length; i++){
					constraints_.gridy=i+1;
					last = i+1;
					panel_.add(children[i].getRenderingComponent(),constraints_);
				}
				constraints_.insets=new Insets(0,0,0,0);
//				if(getNode() instanceof IElement){
//					constraints_.gridy=GridBagConstraints.PAGE_END;
//					endTag_=renderEnd(getNode());
//					panel_.add(endTag_,constraints_);
//				}
				
			}
			
		}
		return panel_;
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.xrender.NodeRenderer#addChild(butterfly.xmlview.gui.xrender.NodeRenderer, int)
	 */
	public void addChild(NodeRenderer child, int where) {
		// TODO Auto-generated method stub
		super.addChild(child, where);
		constraints_.gridy=where+1;
		constraints_.gridx=1;
		constraints_.insets=childInsets_;
		child.getRenderingComponent().setVisible(showChildren_);
		getRenderingComponent().add(child.getRenderingComponent(),constraints_,where);
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.xrender.NodeRenderer#removeChild(int)
	 */
	public void removeChild(int index) {
		// TODO Auto-generated method stub
		super.removeChild(index);
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.xrender.NodeRenderer#removeChild(butterfly.xmlview.gui.xrender.NodeRenderer)
	 */
	public void removeChild(NodeRenderer child) {
		// TODO Auto-generated method stub
		super.removeChild(child);
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(showChildren_){
			collapse_.setText("[+]");
		}else{
			collapse_.setText("[-]");
		}
		showChildren_=!showChildren_;
		JComponent canvas = getRenderingComponent();
		for(int i = 0; i < canvas.getComponentCount(); i++){
			JComponent comp = (JComponent)canvas.getComponent(i);
			if(!comp.equals(startTag_) && !comp.equals(titleArea_) && !comp.equals(collapse_)){
				comp.setVisible(showChildren_);
			}
		}
	}
	
	public JComponent renderStart(INode node){
		if(node instanceof IValueNode){
			return new JTextArea(node.toString());
		}
		else{
			startTag_ =new JLabel(getNode().toString());
			((JLabel)startTag_).setHorizontalAlignment(JLabel.LEFT);
			return startTag_;
		}
		
	}
	public JComponent renderEnd(INode node){
		return new JLabel(((ISourceElement)getNode()).toEndString());
	}
}
