/*
 * Created on Jun 17, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package butterfly.xmlview.gui.xrender;

import java.awt.Dimension;
import java.util.Hashtable;

import butterfly.xmlview.gui.xrender.interfaces.INodeRendererLayout;
import butterfly.xmlview.model.interfaces.INode;


/**
 * @author Jules White
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class BasicTreeLayout implements INodeRendererLayout {
	private Hashtable rowCache_ = new Hashtable();
	private int rowHeight_=20;
	private int rowIndent_=20;
	private int maxWidth_=0;
	
	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.xrender.interfaces.INodeRendererLayout#layoutRenderer(butterfly.xmlview.gui.xrender.DocumentRenderer, butterfly.xmlview.gui.xrender.NodeRenderer)
	 */
	public void layoutRenderer(DocumentRenderer docrend, NodeRenderer rend) {
		rend.getParent().getRenderingComponent().add(rend.getRenderingComponent());
		int row = getRow(rend.getNode());
		int depth = getDepth(rend.getNode());
		int width = rowIndent_*depth+rend.getRenderingComponent().getWidth();
		if(width > maxWidth_){
			maxWidth_=width;
		}
		rend.getRenderingComponent().setLocation(rowIndent_*depth,rowHeight_*row);
		System.out.println("node at row:"+row+" will be:"+rend.getNode());
		Dimension preferred = new Dimension(maxWidth_,rowCache_.size()*rowHeight_);
		docrend.getCanvas().setPreferredSize(preferred);
		
	}

	public int getDepth(INode node){
		int depth = 0;
		INode curr = node;
		while(curr != null){
			curr = curr.getParent();
			depth++;
		}
		return depth;
	}
	
	public int getRow(INode node){
		Integer row = (Integer)rowCache_.get(node);
		if(row == null){
			if(node.getParent() != null){
				int where = node.getParent().indexOfChild(node);
				if(where > 0){
					INode before = node.getParent().childAt(where-1);
					row = new Integer(getRowAfter(before));
				}
				else{
					row = new Integer(getRow(node.getParent())+1);
				}
			}
			else{
				row = new Integer(0);
			}
		}
		rowCache_.put(node,row);
		return row.intValue();
	}
	
	public int getRowAfter(INode node){
		if(node.childCount()>0){
			return getRowAfter(node.childAt(node.childCount()-1))+1;
		}
		else{
			return getRow(node)+1;
		}
	}
}
