/*
 * Created on Jun 17, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package butterfly.xmlview.gui.xrender;



import java.awt.Dimension;
import java.util.Hashtable;

import javax.swing.JComponent;
import javax.swing.JPanel;



import butterfly.xmlview.gui.xrender.interfaces.INodeRendererLayout;
import butterfly.xmlview.gui.xrender.interfaces.IRendererFactory;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.INode;

/**
 * @author Jules White
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DocumentRenderer implements IDocumentListener{
	private IDocument document_;
	private IRendererFactory rendererFactory_;
	private NodeRenderer root_;
	private INodeRendererLayout rendererLayout_;
	private Hashtable rendererLookup_=new Hashtable(17);
	private JComponent canvas_;
	
	public DocumentRenderer(){
		canvas_=new JPanel();
		
	}
	
	/**
	 * @return Returns the document.
	 */
	public IDocument getDocument() {
		return document_;
	}
	/**
	 * @param document The document to set.
	 */
	public void loadDocument(IDocument document) {
		if(document_!=null){
			document_.removeDocumentListener(this);
		}
		document_ = document;
		loadNode(null,document.getRoot(),0);
		document_.addDocumentListener(this);
	}
	/**
	 * @return Returns the rendererFactory.
	 */
	public IRendererFactory getRendererFactory() {
		return rendererFactory_;
	}
	/**
	 * @param rendererFactory The rendererFactory to set.
	 */
	public void setRendererFactory(IRendererFactory rendererFactory) {
		rendererFactory_ = rendererFactory;
	}
	/**
	 * @return Returns the root.
	 */
	public NodeRenderer getRoot() {
		return root_;
	}
	
	/**
	 * @return Returns the rendererLayout.
	 */
	public INodeRendererLayout getRendererLayout() {
		return rendererLayout_;
	}
	/**
	 * @param rendererLayout The rendererLayout to set.
	 */
	public void setRendererLayout(INodeRendererLayout rendererLayout) {
		rendererLayout_ = rendererLayout;
	}
	
	protected NodeRenderer loadNode(NodeRenderer parent, INode node, int where){
		NodeRenderer rend = rendererFactory_.getRenderer(this,parent,node);
		if(parent != null){
			parent.addChild(rend,where);
		}else{
			root_=rend;
			getCanvas().add(root_.getRenderingComponent());
		}
		registerRenderer(rend);
		for(int i = 0; i < node.childCount(); i++){
			loadNode(rend,node.childAt(i),i);
		}
		
		return rend;
	}
	
	protected void layoutRenderer(NodeRenderer rend){
		rendererLayout_.layoutRenderer(this,rend);
	}
	
	protected void registerRenderer(NodeRenderer rend){
		rendererLookup_.put(rend.getNode(),rend);
	}
	protected void unRegisterRenderer(NodeRenderer rend){
		rendererLookup_.remove(rend.getNode());
	}
	public NodeRenderer getRenderer(INode node){
		return (NodeRenderer)rendererLookup_.get(node);
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.model.interfaces.IDocumentListener#handleDocumentEvent(butterfly.xmlview.model.interfaces.IDocumentEvent)
	 */
	public void handleDocumentEvent(IDocumentEvent evt) {
		if(evt.getType() == IDocumentEvent.NODES_REMOVED){
			INode node = evt.getChangedNode();
			NodeRenderer rend = getRenderer(node);
			rend.getParent().removeChild(rend);
			unRegisterRenderer(rend);
		}
		else if(evt.getType()== IDocumentEvent.NODES_ADDED){
			INode node = evt.getChangedNode();
			int where = node.getParent().indexOfChild(node);
			NodeRenderer prend = getRenderer(node.getParent());
			loadNode(prend,node,where);
		}
		else if(evt.getType() == IDocumentEvent.NODES_CHANGED){
			NodeRenderer rend = getRenderer(evt.getChangedNode());
			rend.update();
		}
		else if(evt.getType() == IDocumentEvent.NODES_MOVED){
			NodeRenderer oldparent = getRenderer(evt.getParent());
			NodeRenderer newparent = getRenderer(evt.getChangedNode());
			INode[] nodes = evt.getChangedNodes();
			int start = evt.getChangedIndex();
			for(int i = 0; i < nodes.length; i++){
				NodeRenderer rend = getRenderer(nodes[i]);
				oldparent.removeChild(rend);
				newparent.addChild(rend,start+i);
			}
		}

	}
	/**
	 * @return Returns the canvas.
	 */
	public JComponent getCanvas() {
		return canvas_;
	}
	/**
	 * @param canvas The canvas to set.
	 */
	public void setCanvas(JComponent canvas) {
		canvas_ = canvas;
	}
}
