/*
 * Created on Jun 17, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package butterfly.xmlview.gui.xrender;

import java.awt.Dimension;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import butterfly.xmlview.gui.xrender.interfaces.IRendererFactory;
import butterfly.xmlview.io.XmlViewFileSystem;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IValueNode;

/**
 * @author Jules White
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DocumentRendererComponent extends JPanel {
	int rowHeight_= 20;
	int indent_= 20;
	int count_=0;
	public void loadDocument(IDocument doc){
		setLayout(null);
		loadNode(doc.getRoot(),1);
	}
	
	public void loadNode(INode node, int depth){
		count_++;
		JComponent label = null;
		if(node instanceof IValueNode){
			label = new JTextArea(node.toString());
		}
		else{
			label = new JLabel(node.toString());
		}
		label.setSize(label.getPreferredSize());
		add(label);
		//System.out.println("Rendering: "+count_+" to "+(depth*indent_)+","+(row*rowHeight_));
		label.setLocation(depth*indent_,count_*rowHeight_);
		for(int i = 0; i < node.childCount(); i++){
			loadNode(node.childAt(i),depth+1);
		}
	}
	
	/* (non-Javadoc)
	 * @see java.awt.Component#getPreferredSize()
	 */
	public Dimension getPreferredSize() {
		// TODO Auto-generated method stub
		return new Dimension(count_*indent_,count_*rowHeight_);
		
	}
	public static void main(String[] args){
		try{
			JFrame f = new JFrame();
			f.setSize(500,500);
			DocumentRenderer drc = new DocumentRenderer();
			drc.setRendererFactory(new LabelRendererFactory());
			f.setContentPane(new JScrollPane(drc.getCanvas()));
			String content = XmlViewFileSystem.readFileS(args[0]);
			XmlDocument doc = new XmlDocument(content);
			
			drc.loadDocument(doc);
		
			f.show();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
}
