package butterfly.xmlview.help;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import butterfly.xmlview.help.interfaces.IDescription;
import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IElement;

/**
 * @author Jules White
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ZvonDocumentation extends NodeDocumentation implements ContentHandler{
	private Hashtable objectDescriptions_=new Hashtable();
	private String namespace_;
	
	private boolean inStandard_;
	private boolean inSubElements_;
	private boolean inAttribute_;
	private StringBuffer annotation_=new StringBuffer(300);
	private XmlDescription currentDescription_;
	private ElementDescription elementDescription_;
	
	private static Hashtable docs_=new Hashtable();
	
	private ZvonDocumentation(String ns){
		namespace_=ns;	
	}
	
	
	public static ZvonDocumentation getDocumentation(File file, String namespace) throws SAXException, IOException{
		ZvonDocumentation zdoc = new ZvonDocumentation(namespace);
		FileInputStream str = new FileInputStream(file);
		BufferedInputStream bin = new BufferedInputStream(str);
		InputSource src = new InputSource(bin);
		SAXParser parser = new SAXParser(new org.apache.xerces.parsers.StandardParserConfiguration());
		parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd",false);
		parser.setFeature("http://xml.org/sax/features/external-general-entities",false);
		parser.setFeature("http://xml.org/sax/features/external-parameter-entities",false);
		parser.setContentHandler(zdoc);
		parser.parse(src);
		return zdoc;
	}
	
	
	protected ElementDescription getElementDescription(String name){
		ElementDescription ed = (ElementDescription)objectDescriptions_.get(name);
		if(ed==null){
			ed = new ElementDescription(namespace_,name,"No Description");	
			objectDescriptions_.put(name,ed);
		}
		return ed;
	}
	
	protected AttributeDescription getAttributeDescription(String name){
		AttributeDescription ed = (AttributeDescription)objectDescriptions_.get("@"+name);
		if(ed==null){
			ed = new AttributeDescription(namespace_,name,"No Description");	
			objectDescriptions_.put("@"+name,ed);
		}
		return ed;
	}
	
	/**
	 * @see butterfly.xmlview.help.interfaces.IDocumentation#getDescription(Object)
	 */
	public IDescription getDescription(Object obj) {
		IDescription desc = null;
		if(obj instanceof IElement){
			desc=(IDescription)objectDescriptions_.get(((IElement)obj).getLocalName());
		}
		else if(obj instanceof IAttribute){
			desc=(IDescription)objectDescriptions_.get(((IAttribute)obj).getLocalName());
		}
		return desc;
	}

	
	/**
	 * @see org.xml.sax.ContentHandler#characters(char[], int, int)
	 */
	public void characters(char[] ch, int start, int length)
		throws SAXException {
			if(inStandard_){
				annotation_.append(ch,start,length);	
			}
	}

	/**
	 * @see org.xml.sax.ContentHandler#endDocument()
	 */
	public void endDocument() throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#endElement(String, String, String)
	 */
	public void endElement(String namespaceURI, String localName, String qName)
		throws SAXException {
			if(localName.equals("standard")){
				currentDescription_.setAnnotation(annotation_.toString());
				annotation_.delete(0,annotation_.length());
				inStandard_=false;
			}
			if(localName.equals("attribute")){
				currentDescription_=elementDescription_;	
			}
	}

	/**
	 * @see org.xml.sax.ContentHandler#startDocument()
	 */
	public void startDocument() throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#startElement(String, String, String, Attributes)
	 */
	public void startElement(
		String namespaceURI,
		String localName,
		String qName,
		Attributes atts)
		throws SAXException {
			annotation_.delete(0,annotation_.length());
			if(localName.equals("element")){
				processElement(atts);
			}
			else if(localName.equals("attribute")){
				processAttribute(atts);	
			}
			else if(localName.equals("standard")){
				inStandard_=true;
			}
	}

	protected void processAttribute(Attributes atts){	
		currentDescription_ = getAttributeDescription(atts.getValue("name"));
		elementDescription_.addAttribute((AttributeDescription)currentDescription_);
	}

	protected void processElement(Attributes atts){
		
		elementDescription_ = getElementDescription(atts.getValue("name"));
		currentDescription_=elementDescription_;
		if(atts.getIndex("children")>-1){
			StringTokenizer children = new StringTokenizer(atts.getValue("children"));
			int total = children.countTokens();
			ElementDescription[] sub = new ElementDescription[total];
			int count = 0;
			while(children.hasMoreTokens()){
				String next = children.nextToken();
				sub[count]=getElementDescription(next);
				count++;
			}
			((ElementDescription)currentDescription_).setSubElements(sub);
		}		
	}


	public void printDescription(IDescription desc){
		if(desc instanceof AttributeDescription){
			System.out.println("  @["+desc.getTitle()+"]:"+desc.getDescription());
		}
		else if(desc instanceof ElementDescription){
			System.out.println("<"+desc.getTitle()+">:"+desc.getDescription());
			ElementDescription[] children = ((ElementDescription)desc).getSubElements();
			AttributeDescription[] attrs = ((ElementDescription)desc).getAttributes();
			System.out.println("[Attributes]:");
			for(int i = 0; i < attrs.length; i++){
				printDescription(attrs[i]);
			}
			String cstr = "children: (";
			if(children!=null){
			for(int i = 0; i < children.length; i++){
				cstr+=children[i].getName()+" ";	
			}
			}
			cstr+=")";
			System.out.println(cstr);
		}	
	}

	public void printDocumentation(){
		Enumeration enum = objectDescriptions_.keys();	
		while(enum.hasMoreElements()){
			Object el = enum.nextElement();
			IDescription desc = (IDescription)objectDescriptions_.get(el);
			if(desc instanceof ElementDescription){
				printDescription(desc);	
			}	
		}
	}

	/**
	 * @see org.xml.sax.ContentHandler#endPrefixMapping(String)
	 */
	public void endPrefixMapping(String prefix) throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#ignorableWhitespace(char[], int, int)
	 */
	public void ignorableWhitespace(char[] ch, int start, int length)
		throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#processingInstruction(String, String)
	 */
	public void processingInstruction(String target, String data)
		throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#setDocumentLocator(Locator)
	 */
	public void setDocumentLocator(Locator locator) {
	}

	/**
	 * @see org.xml.sax.ContentHandler#skippedEntity(String)
	 */
	public void skippedEntity(String name) throws SAXException {
	}

	/**
	 * @see org.xml.sax.ContentHandler#startPrefixMapping(String, String)
	 */
	public void startPrefixMapping(String prefix, String uri)
		throws SAXException {
	}

	public static void main(String[] args){
		try{
			ZvonDocumentation zdoc = ZvonDocumentation.getDocumentation(new File(args[0]),args[1]);
			zdoc.printDocumentation();
		}catch(Exception e){
			e.printStackTrace();	
		}	
	}

}
