/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.io;

import java.io.File;
import java.util.Stack;
import java.util.Vector;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.log4j.Logger;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IFileSaveAction;
import butterfly.xmlview.io.interfaces.IDocumentAccessHistory;
import butterfly.xmlview.model.BasicDocument;
import butterfly.xmlview.model.interfaces.IDocument;
/**
 * Insert the type's description here.
 * Creation date: (11/22/2002 9:12:12 PM)
 * @author: 
 */
public class DocumentAccessHistory implements IActionRequester,Configurable,IDocumentAccessHistory{
	private Vector history_;
	
	private int maxDocuments_ = 10;
	private IActionLookup actionLookup_;
	private Configuration historyConfiguration_;
	private String historyFile_;
	public static final String DOCUMENT_PATH_ATTRIBUTE = "path";
	public static final String HISTORY_FILE_ATTRIBUTE = "history-file";
	private static Logger logger_ = Logger.getLogger(DocumentAccessHistory.class);
/**
 * DocumentAccessHistory constructor comment.
 */
public DocumentAccessHistory() {
	super();
	history_ = new Stack();
	//historyLookup_ = new Hashtable();
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 9:13:55 PM)
 */
public void clearHistory() {
	history_.clear();	
}
/**
 * configure method comment.
 */
public void configure(org.apache.avalon.framework.configuration.Configuration arg1) throws org.apache.avalon.framework.configuration.ConfigurationException {
	try{
	if(historyConfiguration_ == null){
		historyFile_ = arg1.getAttribute(HISTORY_FILE_ATTRIBUTE,"none");
		DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
		historyConfiguration_ = builder.buildFromFile(new File(historyFile_));
			
	}
	Configuration[] files = historyConfiguration_.getChildren();
	for(int i = 0; i < files.length; i++){
		logger_.debug("Adding "+files[i].getAttribute(DOCUMENT_PATH_ATTRIBUTE,"unknown")+" to the document history list");
		history_.add(files[i].getAttribute(DOCUMENT_PATH_ATTRIBUTE,"unknown"));
	}
	}catch(Exception e){
		e.printStackTrace();
	}
		
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 9:13:32 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void documentOpened(IDocument doc) {
	if(history_.contains(doc.getSourceFileName())){
		history_.remove(doc.getSourceFileName());
	}
	if(history_.size() >= maxDocuments_){
		history_.removeElementAt(maxDocuments_ - 1);
	}
	history_.add(0,doc.getSourceFileName());
	
	BasicDocument hdoc = new BasicDocument();
	hdoc.setText(toXml());
	hdoc.setSourceFileName(historyFile_);
	IFileSaveAction save = (IFileSaveAction)getActionLookup().getAction(IFileSaveAction.ROLE);
	save.setDocument(hdoc);
	save.actionPerformed(null);
}
/**
 * Insert the method's description here.
 * Creation date: (11/23/2002 7:49:50 PM)
 * @return butterfly.actions.interfaces.IActionLookup
 */
public butterfly.actions.interfaces.IActionLookup getActionLookup() {
	return actionLookup_;
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 9:14:52 PM)
 * @return java.lang.String[]
 */
public String[] getDocumentList() {
	return (String[])history_.toArray(new String[0]);
}
/**
 * Insert the method's description here.
 * Creation date: (11/23/2002 7:49:34 PM)
 */
public void requestActions() {
	
}
/**
 * Insert the method's description here.
 * Creation date: (11/23/2002 7:49:50 PM)
 * @param newActionLookup butterfly.actions.interfaces.IActionLookup
 */
public void setActionLookup(butterfly.actions.interfaces.IActionLookup newActionLookup) {
	actionLookup_ = newActionLookup;
}
/**
 * Insert the method's description here.
 * Creation date: (11/23/2002 8:35:36 PM)
 */
public String toXml() {
	String xml = "<history>\n";
	for(int i = 0; i < history_.size(); i++){
		xml += "<file path=\""+history_.elementAt(i)+"\"/>\n";
	}
	xml += "</history>";
	return xml;
}
}
