/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.io;

import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.io.interfaces.IDocumentCache;
import java.util.Hashtable;
/**
 * Insert the type's description here.
 * Creation date: (11/22/2002 8:52:15 PM)
 * @author: 
 */
public class DocumentCache implements IDocumentCache{
	private Hashtable cache_ = new Hashtable(5);
	/**
 * DocumentCache constructor comment.
 */
public DocumentCache() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 8:54:14 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void cacheDocument(IDocument doc) {
	if(doc.getSourceFileName()!= null){
		cache_.put(doc.getSourceFileName(),doc);	
	}
}

public IDocument[] getCacheContents(){
	return (IDocument[])cache_.values().toArray(new IDocument[0]);	
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 8:56:51 PM)
 */
public void clearCache() {
	cache_.clear();	
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 8:56:03 PM)
 * @return butterfly.xmlview.model.interfaces.IDocument
 * @param path java.lang.String
 */
public IDocument getDocument(String path) {
	return (IDocument)cache_.get(path);
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 8:57:32 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void removeDocument(IDocument doc) {
	if(doc.getSourceFileName()!=null){
		cache_.remove(doc.getSourceFileName());	
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/22/2002 8:57:32 PM)
 * @param doc butterfly.xmlview.model.interfaces.IDocument
 */
public void removeDocument(String path) {
	cache_.remove(path);	
}
}
