/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;

import org.apache.xerces.impl.io.ASCIIReader;
import org.apache.xerces.impl.io.UCSReader;
import org.apache.xerces.impl.io.UTF8Reader;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;

import butterfly.xmlview.model.interfaces.IDocument;

/**
 * Insert the type's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @author: 
 */
public class XmlViewFileSystem implements butterfly.xmlview.io.interfaces.IFileSystem {
	private String tempDirectory_ = "tmp/";
	private static int newDocumentCount_ = 1;
/**
 * XmlViewFileSystem constructor comment.
 */
public XmlViewFileSystem() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 1:35:59 PM)
 * @return boolean
 * @param file java.lang.String
 */
public boolean fileExists(java.lang.String file) {
	return false;
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:11:07 AM)
 * @return java.lang.String
 */
public java.lang.String getTempDirectory() {
	return tempDirectory_;
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @return java.lang.String
 * @param name java.lang.String
 */
public String readFile(String name)throws Exception {
	//return loadFile(name);/*
	File file = new File(name);	
	return readFile(file);
	/*StringBuffer contents = new StringBuffer(((int)file.length()));

	FileReader in = null;
	BufferedReader reader = null;
	try{
		in = new FileReader(file);
		reader = new BufferedReader(in);

		String line = null;
		while( (line = reader.readLine()) != null){
			contents.append(line);
			contents.append("\n");
		}
		in.close();
		reader.close();
	}catch(Exception e){
		try{
			in.close();
			reader.close();
		}catch(Exception e2){}
		throw e;
	}
	return contents.toString();//*/
}


/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @return java.lang.String
 * @param name java.lang.String
 */
public String readFile(File file)throws Exception {
	//return loadFile(name);/*
	//File file = new File(name);	
	StringBuffer contents = new StringBuffer(((int)file.length()));

	//FileReader in = null;
	//BufferedReader reader = null;
	
	URL url = file.toURL();
	XMLInputSource src = new XMLInputSource(url.toExternalForm(),url.toString(),null);
	
		
	Reader in = getReader("dc",src,false,true);
	BufferedReader reader = new BufferedReader(in);
	try{
		//in = new FileReader(file);
		//reader = new BufferedReader(in);

		String line = null;
		while( (line = reader.readLine()) != null){
			contents.append(line);
			contents.append("\n");
		}
		in.close();
		reader.close();
	}catch(Exception e){
		try{
			in.close();
			reader.close();
		}catch(Exception e2){}
		throw e;
	}
	return contents.toString();//*/
}


/*
public String loadFile(String filen) {

		//System.out.println("Loading the registry.\n\n");
		String content = "";
		try {
			nsDetector det = new nsDetector() ;
			det.Init(new nsICharsetDetectionObserver() {
                public void Notify(String charset) {
                    //HtmlCharsetDetector.found = true ;
                    System.out.println("CHARSET = " + charset);
                }
       		 });
			File file = new File(filen);
			FileInputStream input = new FileInputStream(file);
			FileChannel channel = input.getChannel();
			int fileLength = (int) channel.size();
			MappedByteBuffer buffer =
				channel.map(FileChannel.MapMode.READ_ONLY, 0, fileLength);
			//byte[] buf = new byte[1024];
			//while((buffer.get(buf))!=-1){
				det.DoIt(buffer.array(),buffer.array().length, false);
			//}
			Charset charset = Charset.forName("ISO-8859-1");
			CharsetDecoder decoder = charset.newDecoder();
			CharBuffer charBuffer = decoder.decode(buffer);
			String str = charBuffer.toString();
			//System.out.println("loaded:");
			return str;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return content;
	}*/
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @return java.lang.String
 * @param name java.lang.String
 */
public String readTempFile(String name)throws Exception {
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @return java.lang.String
 * @param name java.lang.String
 */
public void saveFile(String name, String content) throws Exception {
    File file = new File(name);
    FileWriter writer = null;
    try {
        writer = new FileWriter(file);
        writer.write(content);
        writer.flush();
        writer.close();
    } catch (Exception e) {
        try {
            writer.close();
        } catch (Exception e2) {
        }
        throw e;
    }

}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @return java.lang.String
 * @param name java.lang.String
 */
public File saveTempFile(String name, String content)throws Exception {
	String where = tempDirectory_+name;
	File file = new File(where);
	FileWriter fout = new FileWriter(file.getAbsoluteFile());
	BufferedWriter out = new BufferedWriter(fout);
	out.write(content);
	out.flush();
	out.close();
	return file.getAbsoluteFile();
}
/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:11:07 AM)
 * @param newTempDirectory java.lang.String
 */
public void setTempDirectory(java.lang.String newTempDirectory) {
	tempDirectory_ = newTempDirectory;
}

/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @return java.lang.String
 * @param name java.lang.String
 */
public static String readFileS(String name)throws Exception {
	File file = new File(name);	
	StringBuffer contents = new StringBuffer(((int)file.length()));

	FileReader in = null;
	BufferedReader reader = null;
	try{
		in = new FileReader(file);
		reader = new BufferedReader(in);

		String line = null;
		while( (line = reader.readLine()) != null){
			contents.append(line);
			contents.append("\n");
		}
		in.close();
		reader.close();
	}catch(Exception e){
		try{
			in.close();
			reader.close();
		}catch(Exception e2){}
		throw e;
	}
	return contents.toString();
}

/**
 * Insert the method's description here.
 * Creation date: (8/20/2002 11:03:26 AM)
 * @return java.lang.String
 * @param name java.lang.String
 */
public static void saveFileS(String name, String content) throws Exception {
    File file = new File(name);
    FileWriter writer = null;
    try {
        writer = new FileWriter(file);
        writer.write(content);
        writer.flush();
        writer.close();
    } catch (Exception e) {
        try {
            writer.close();
        } catch (Exception e2) {
        }
        throw e;
    }

}
	/**
	 * @see butterfly.xmlview.io.interfaces.IFileSystem#createNewFile(String)
	 */
	public File createNewFile(String ext) {
		File nfile = new File("Document"+newDocumentCount_+"."+ext);
		newDocumentCount_++;
		return nfile;
	}
	
	public static String newFileName(String ext){
		File nfile = new File("Document"+newDocumentCount_+"."+ext);
		newDocumentCount_++;
		return nfile.getName();
	}

	/**
	 * @see butterfly.xmlview.io.interfaces.IFileSystem#isNewFile(String)
	 */
	public boolean isNewFile(File file) {
		return (NEW_FILE_FOLDER.equals(file.getParentFile()));
	}
	
	public static String cset=null;
	public static void main(String[] args){
		XmlViewFileSystem fs = new XmlViewFileSystem();
		try{
		System.out.println(fs.readFile("c:/wordnet.xsd.xml"));
		}catch(Exception e){e.printStackTrace();}
//		File f = new File("c:/wordnet.xsd.xml");
//		try{
//		URL url = f.toURL();
//		XMLInputSource src = new XMLInputSource(url.toExternalForm(),url.toString(),null);
//		XmlViewFileSystem fs = new XmlViewFileSystem();
//		
//			Reader in = fs.getReader("dc",src,false,true);
//			BufferedReader bin = new BufferedReader(in);
//			String line = null;
//			while((line = bin.readLine())!= null){
//				System.out.println(line);	
//			}
//		}catch(Exception e){
//			e.printStackTrace();	
//		}
//		//nsDetector det = new nsDetector() ;	
//		//XmlViewFileSystem fs = new XmlViewFileSystem();
//		//try{fs.loadFile("c:/wordnet.xsd.xml");}catch(Exception e){e.printStackTrace();}
//		//boolean done = false;
//		nsDetector det = new nsDetector() ;
//			det.Init(new nsICharsetDetectionObserver() {
//                public void Notify(String charset) {
//                    //HtmlCharsetDetector.found = true ;
//                    System.out.println("CHARSET = " + charset);
//                    cset=charset;
//                }
//       		 });
//       		 try{
//       		 	File file = new File("c:/wordnet.xsd.xml");
//		FileInputStream input = new FileInputStream(file);
////		FileReader reader = new FileReader(file);
//		//ASCIIReader reader = new ASCIIReader(input,new MessageFormatter() {
////			/**
////			 * @see org.apache.xerces.util.MessageFormatter#formatMessage(Locale, String, Object[])
////			 */
////			public String formatMessage(
////				Locale arg0,
////				String arg1,
////				Object[] arg2)
////				throws MissingResourceException {
////				return arg1;
////			}
////		},Locale.getDefault());
//		
////		BufferedReader buff = new BufferedReader(reader);
////	
////		String line = null;
////		while((line = buff.readLine())!=null){
////			System.out.println(line);	
////		}
//		FileChannel channel = input.getChannel();
//			int fileLength = (int) channel.size();
//			MappedByteBuffer buffer =
//				channel.map(FileChannel.MapMode.READ_ONLY, 0, fileLength);
//		byte[] buf = new byte[1024];
//		int total = 0;
//		while(total < buffer.limit()-1024){
//			//if(!done){
//			buffer.get(buf,total,1024);
//			//buf.put(buffer);
//			if(cset==null){
//			if(det.isAscii(buf,buf.length)){
//				System.out.println("ascii");
//				//break;	
//			}
//			det.DoIt(buf,buf.length,false);
//			}
//			else{
//				break;	
//			}
//			
//		}
//		det.DataEnd();
//		Charset charset = Charset.forName(cset);
//		System.out.println(charset.name());
//		CharsetDecoder decoder = charset.newDecoder();
//		CharBuffer charBuffer = decoder.decode(buffer);
//		
//		System.out.println(charBuffer.toString());
       	//	 }catch(Exception e){e.printStackTrace();}
	}
	
	 public Reader getReader(String name,
                            XMLInputSource xmlInputSource,
                            boolean literal, boolean isExternal)
        throws IOException, XNIException {
        // get information

        final String publicId = xmlInputSource.getPublicId();
        final String literalSystemId = xmlInputSource.getSystemId();
        String baseSystemId = xmlInputSource.getBaseSystemId();
        String encoding = xmlInputSource.getEncoding();
        Boolean isBigEndian = null;

        // create reader
        InputStream stream = null;
        Reader reader = xmlInputSource.getCharacterStream();
        String expandedSystemId = expandSystemId(literalSystemId, baseSystemId);
        if (baseSystemId == null) {
            baseSystemId = expandedSystemId;
        }
        if (reader == null) {
            stream = xmlInputSource.getByteStream();
            if (stream == null) {
                stream = new URL(expandedSystemId).openStream();
            }
            // wrap this stream in RewindableInputStream
            stream = new RewindableInputStream(stream);

            // perform auto-detect of encoding if necessary
            if (encoding == null) {
                // read first four bytes and determine encoding
                final byte[] b4 = new byte[4];
                int count = 0;
                for (; count<4; count++ ) {
                    b4[count] = (byte)stream.read();
                }
                if (count == 4) {
                    Object [] encodingDesc = getEncodingName(b4, count);
                    encoding = (String)(encodingDesc[0]);
                    isBigEndian = (Boolean)(encodingDesc[1]);

                    // removed use of pushback inputstream--neilg
                    /*****
                    // push back the characters we read
                    if (DEBUG_ENCODINGS) {
                        System.out.println("$$$ wrapping input stream in PushbackInputStream");
                    }
                    PushbackInputStream pbstream = new PushbackInputStream(stream, 4);
                    *****/
                    stream.reset();
                    int offset = 0;
                    // Special case UTF-8 files with BOM created by Microsoft
                    // tools. It's more efficient to consume the BOM than make
                    // the reader perform extra checks. -Ac
                    if (count > 2 && encoding.equals("UTF-8")) {
                        int b0 = b4[0] & 0xFF;
                        int b1 = b4[1] & 0xFF;
                        int b2 = b4[2] & 0xFF;
                        if (b0 == 0xEF && b1 == 0xBB && b2 == 0xBF) {
                            // ignore first three bytes...
                            stream.skip(3);
                            /********
                            offset = 3;
                            count -= offset;
                            ***/
                        }
                    }
                    reader = createReader(stream, encoding, isBigEndian);
                }
                else {
                    reader = createReader(stream, encoding, isBigEndian);
                }
            }

            // use specified encoding
            else {
                reader = createReader(stream, encoding, isBigEndian);
            }

            // read one character at a time so we don't jump too far
            // ahead, converting characters from the byte stream in
            // the wrong encoding
           
            //reader = new OneCharReader(reader);
        }
        return reader;
        }
        
        protected final class RewindableInputStream extends InputStream {

        private InputStream fInputStream;
        private byte[] fData;
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream is) {
            fData = new byte[1024];
            fInputStream = is;
            fStartOffset = 0;
            fEndOffset = -1;
            fOffset = 0;
            fLength = 0;
            fMark = 0;
        }

        public void setStartOffset(int offset) {
            fStartOffset = offset;
        }

        public void rewind() {
            fOffset = fStartOffset;
        }

        public int read() throws IOException {
            int b = 0;
            if (fOffset < fLength) {
                return fData[fOffset++] & 0xff;
            }
            if (fOffset == fEndOffset) {
                return -1;
            }
            if (fOffset == fData.length) {
                byte[] newData = new byte[fOffset << 1];
                System.arraycopy(fData, 0, newData, 0, fOffset);
                fData = newData;
            }
            b = fInputStream.read();
            if (b == -1) {
                fEndOffset = fOffset;
                return -1;
            }
            fData[fLength++] = (byte)b;
            fOffset++;
            return b & 0xff;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesLeft = fLength - fOffset;
            if (bytesLeft == 0) {
                if (fOffset == fEndOffset) {
                    return -1;
                }
                // better get some more for the voracious reader...
//                if(fCurrentEntity.mayReadChunks) {
//                    return fInputStream.read(b, off, len);
//                }
                int returnedVal = read();
                if(returnedVal == -1) {
                    fEndOffset = fOffset;
                    return -1;
                }
                b[off] = (byte)returnedVal;
                return 1;
            }
            if (len < bytesLeft) {
                if (len <= 0) {
                    return 0;
                }
            }
            else {
                len = bytesLeft;
            }
            if (b != null) {
                System.arraycopy(fData, fOffset, b, off, len);
            }
            fOffset += len;
            return len;
        }

        public long skip(long n)
            throws IOException
        {
            int bytesLeft;
            if (n <= 0) {
                return 0;
            }
            bytesLeft = fLength - fOffset;
            if (bytesLeft == 0) {
                if (fOffset == fEndOffset) {
                    return 0;
                }
                return fInputStream.skip(n);
            }
            if (n <= bytesLeft) {
                fOffset += n;
                return n;
            }
            fOffset += bytesLeft;
            if (fOffset == fEndOffset) {
                return bytesLeft;
            }
            n -= bytesLeft;
           /*
            * In a manner of speaking, when this class isn't permitting more
            * than one byte at a time to be read, it is "blocking".  The
            * available() method should indicate how much can be read without
            * blocking, so while we're in this mode, it should only indicate
            * that bytes in its buffer are available; otherwise, the result of
            * available() on the underlying InputStream is appropriate.
            */
            return fInputStream.skip(n) + bytesLeft;
        }

        public int available() throws IOException {
            int bytesLeft = fLength - fOffset;
            if (bytesLeft == 0) {
                if (fOffset == fEndOffset) {
                    return -1;
                }
                //return fCurrentEntity.mayReadChunks ? fInputStream.available()
                //                                    : 0;
            }
            return bytesLeft;
        }

        public void mark(int howMuch) {
            fMark = fOffset;
        }

        public void reset() {
            fOffset = fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (fInputStream != null) {
                fInputStream.close();
                fInputStream = null;
            }
        }
    } // end of RewindableInputStream class

	 public static String expandSystemId(String systemId, String baseSystemId) {

        // check for bad parameters id
        if (systemId == null || systemId.length() == 0) {
            return systemId;
        }
        // if id already expanded, return
        try {
            URI uri = new URI(systemId);
            if (uri != null) {
                return systemId;
            }
        }
        catch (URI.MalformedURIException e) {
            // continue on...
        }
        // normalize id
        //String id = fixURI(systemId);

        // normalize base
        URI base = null;
        URI uri = null;
        

        if (uri == null) {
            return systemId;
        }
        return uri.toString();

    } // expandSystemId(String,String):String

protected Object[] getEncodingName(byte[] b4, int count) {

        if (count < 2) {
            return new Object[]{"UTF-8", null};
        }

        // UTF-16, with BOM
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 0xFE && b1 == 0xFF) {
            // UTF-16, big-endian
            return new Object [] {"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 0xFF && b1 == 0xFE) {
            // UTF-16, little-endian
            return new Object [] {"UTF-16LE", new Boolean(false)};
        }

        // default to UTF-8 if we don't have enough bytes to make a
        // good determination of the encoding
        if (count < 3) {
            return new Object [] {"UTF-8", null};
        }

        // UTF-8 with a BOM
        int b2 = b4[2] & 0xFF;
        if (b0 == 0xEF && b1 == 0xBB && b2 == 0xBF) {
            return new Object [] {"UTF-8", null};
        }

        // default to UTF-8 if we don't have enough bytes to make a
        // good determination of the encoding
        if (count < 4) {
            return new Object [] {"UTF-8", null};
        }

        // other encodings
        int b3 = b4[3] & 0xFF;
        if (b0 == 0x00 && b1 == 0x00 && b2 == 0x00 && b3 == 0x3C) {
            // UCS-4, big endian (1234)
            return new Object [] {"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (b0 == 0x3C && b1 == 0x00 && b2 == 0x00 && b3 == 0x00) {
            // UCS-4, little endian (4321)
            return new Object [] {"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (b0 == 0x00 && b1 == 0x00 && b2 == 0x3C && b3 == 0x00) {
            // UCS-4, unusual octet order (2143)
            // REVISIT: What should this be?
            return new Object [] {"ISO-10646-UCS-4", null};
        }
        if (b0 == 0x00 && b1 == 0x3C && b2 == 0x00 && b3 == 0x00) {
            // UCS-4, unusual octect order (3412)
            // REVISIT: What should this be?
            return new Object [] {"ISO-10646-UCS-4", null};
        }
        if (b0 == 0x00 && b1 == 0x3C && b2 == 0x00 && b3 == 0x3F) {
            // UTF-16, big-endian, no BOM
            // (or could turn out to be UCS-2...
            // REVISIT: What should this be?
            return new Object [] {"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 0x3C && b1 == 0x00 && b2 == 0x3F && b3 == 0x00) {
            // UTF-16, little-endian, no BOM
            // (or could turn out to be UCS-2...
            return new Object [] {"UTF-16LE", new Boolean(false)};
        }
        if (b0 == 0x4C && b1 == 0x6F && b2 == 0xA7 && b3 == 0x94) {
            // EBCDIC
            // a la xerces1, return CP037 instead of EBCDIC here
            return new Object [] {"CP037", null};
        }

        // default encoding
        return new Object [] {"UTF-8", null};

    } // getEncodingName(byte[],int):Object[]
    
     protected Reader createReader(InputStream inputStream, String encoding, Boolean isBigEndian)
        throws IOException {

        // normalize encoding name
        if (encoding == null) {
            encoding = "UTF-8";
        }

        // try to use an optimized reader
        String ENCODING = encoding.toUpperCase(Locale.ENGLISH);
        if (ENCODING.equals("UTF-8")) {
            
            return new UTF8Reader(inputStream, 1024, null, Locale.getDefault() );
        }
        if (ENCODING.equals("US-ASCII")) {
            
            return new ASCIIReader(inputStream, 1024,null, Locale.getDefault());
        }
        if(ENCODING.equals("ISO-10646-UCS-4")) {
            if(isBigEndian != null) {
                boolean isBE = isBigEndian.booleanValue();
                if(isBE) {
                    return new UCSReader(inputStream, UCSReader.UCS4BE);
                } else {
                    return new UCSReader(inputStream, UCSReader.UCS4LE);
                }
            } 
        }
        if(ENCODING.equals("ISO-10646-UCS-2")) {
            if(isBigEndian != null) { // sould never happen with this encoding...
                boolean isBE = isBigEndian.booleanValue();
                if(isBE) {
                    return new UCSReader(inputStream, UCSReader.UCS2BE);
                } else {
                    return new UCSReader(inputStream, UCSReader.UCS2LE);
                }
            } 
        }

        // check for valid name
        boolean validIANA = XMLChar.isValidIANAEncoding(encoding);
        boolean validJava = XMLChar.isValidJavaEncoding(encoding);
       
            // NOTE: AndyH suggested that, on failure, we use ISO Latin 1
            //       because every byte is a valid ISO Latin 1 character.
            //       It may not translate correctly but if we failed on
            //       the encoding anyway, then we're expecting the content
            //       of the document to be bad. This will just prevent an
            //       invalid UTF-8 sequence to be detected. This is only
            //       important when continue-after-fatal-error is turned
            //       on. -Ac
            encoding = "ISO-8859-1";
        //}

        // try to use a Java reader
        String javaEncoding = EncodingMap.getIANA2JavaMapping(ENCODING);
        if (javaEncoding == null) {
           
                
                javaEncoding = "ISO8859_1";
            
        }
       
        return new InputStreamReader(inputStream, javaEncoding);

    } // createReader(InputStream,String, Boolean): Reader


	/* (non-Javadoc)
	 * @see butterfly.xmlview.io.interfaces.IFileSystem#saveTempFile(butterfly.xmlview.model.interfaces.IDocument)
	 */
	public File getTempFile(IDocument doc) {
		
		return new File(tempDirectory_+doc.getName()+System.currentTimeMillis());
	}
	
	public static File resolve(String base, String loc) throws Exception{
		if(base != null){
			return resolveFile(new File(base),loc);
		}
		return resolveFile(null,loc);
	}
	
	public static File resolveFile(File base, String loc) throws Exception{
		if(loc.indexOf(":")>-1){
			return new File(new java.net.URI(loc));
		}
		else{
			if(base == null){
				return new File(loc);
			}
			else{
				java.net.URI uri = base.toURI();
				uri = uri.resolve(loc);
				return new File(uri);
			}
		}
	}

}
