/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.grammars;

import java.io.File;
import java.net.URI;
import java.util.Hashtable;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log4j.Logger;

import butterfly.components.interfaces.IComponent;
import butterfly.xmlview.gui.SplashScreen;
import butterfly.xmlview.model.validation.AbstractValidationDocument;
import butterfly.xmlview.model.validation.GenericValidationDocument;
import butterfly.xmlview.model.validation.HybridValidationDocument;
import butterfly.xmlview.model.validation.ValidationDocument;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import butterfly.xmlview.model.validation.interfaces.IGrammarFactory;
import butterfly.xmlview.util.FileSystem;

/**
 * @author Administrator
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */

public class GrammarFactory implements IGrammarFactory,Configurable,IComponent{
	private Hashtable grammars_=new Hashtable();
	private Configuration configuration_;
	private static final Logger logger_ = Logger.getLogger(GrammarFactory.class);
	
	public IValidationDocument getGrammar(URI uri, String namespace, String type){
		return null;
	}
	
	public IValidationDocument getGrammar(String namespace){
		return (IValidationDocument)grammars_.get(namespace);
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.model.validation.interfaces.IGrammarFactory#getGrammar(java.lang.String, java.lang.String, java.lang.String)
	 */
	public IValidationDocument getGrammar(
		String uri,
		String base,
		String namespace,
		String type) {	
		
		try{
			File file = FileSystem.resolve(base,uri);//XmlViewFileSystem.resolve(base,uri);//null;
			return getGrammar(file,namespace);
		}catch(Exception e){
			e.printStackTrace();
		}
		return null;
		}
	
	public IDocument loadDocument(File file){
//		IFileOpenAction open =
//		(IFileOpenAction) actionLookup_.getAction(
//				IFileOpenAction.ROLE);
//		open.setShowFile(false);
//		open.setAccessHistoryEnabled(false);
//		open.setFile(file);
//		open.actionPerformed(null);
		IDocument doc=null;
		if(file.exists()){
		 doc = FileSystem.loadDocument(file);//open.getDocument();
		}
		return doc;
	}
	
	public IValidationDocument getGrammar(
			File file,
			String namespace) {
		IValidationDocument vdoc = null;
		try {
				
				vdoc = (IValidationDocument)grammars_.get(file.getAbsolutePath());
				
				if(vdoc == null){

					IDocument doc = loadDocument(file);
					if(doc != null){
					if (doc instanceof IValidationDocument && doc != null) {
						vdoc = (IValidationDocument) doc;
					}
					if(file.getName().endsWith(".dtd")){
						((AbstractValidationDocument)vdoc).setContentType(IValidationDocument.TEXT_DTD_TYPE);
					}
					if (doc != null && !(doc instanceof IValidationDocument)) {
						ValidationDocument v = new ValidationDocument("text/unknown-validation", doc);
						v.setSourceFileName(doc.getSourceFileName());
						v.getElementStructures();
						vdoc = v;
					}
					}
				}
				
				if(vdoc != null){
					grammars_.put(file.getAbsolutePath(),vdoc);
					if(namespace != null){
						grammars_.put(namespace,vdoc);
					}
				}
			
			return vdoc;
		} catch (Exception e) {
			//e.printStackTrace();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.avalon.framework.configuration.Configurable#configure(org.apache.avalon.framework.configuration.Configuration)
	 */
	public void configure(Configuration arg0) throws ConfigurationException {
		SplashScreen.progress("Loading Grammars...");
		
		// TODO Auto-generated method stub
		Configuration[] grammars = arg0.getChildren();
		for(int i = 0; i < grammars.length; i++){
			String tdoc = grammars[i].getAttribute("template","");
			String tclass = grammars[i].getAttribute("class","");
			
			String vdoc = grammars[i].getAttribute("validation","");
			String type = grammars[i].getAttribute("type","xsd");
			String ns = grammars[i].getAttribute("ns","");
			
			File v = new File(vdoc);
			if(tdoc.trim().length() > 0){
				File t = new File(tdoc);
				loadHybridGrammar(t,v,ns);
			}
			else if(tclass.trim().length()<1){
				IValidationDocument vd = getGrammar(new File(vdoc),null);
				if(vd != null){
					vd.getElementStructures();
					grammars_.put(ns,vd);
				}
			}
			else{
				try{
					IValidationDocument t = (IValidationDocument)Class.forName(tclass).newInstance();
					loadHybridGrammar(t,v,ns);
				}catch (Exception e) {
					logger_.warn("Unable to load grammar: template:"+tdoc+","+tclass+" vdoc:"+vdoc+" ns:"+ns);
					e.printStackTrace();
				}
					// TODO: handle exception
				}
			}
		
		

	}
	
	public void loadHybridGrammar(File tdoc, File vdoc, String namespace){
		//logger_.debug("Loading grammar tdoc:"+tdoc+" vdoc:"+vdoc+" ns:"+namespace);
		XmlDocument td = (XmlDocument)loadDocument(tdoc);
		if(td != null){
		IValidationDocument vd = getGrammar(vdoc,null);
		IValidationDocument hvd = null;
		if(vd == null){
			hvd = new GenericValidationDocument(td);
		}
		else{
			hvd = new HybridValidationDocument(td,vd);
		}
		grammars_.put(namespace,hvd);
		}
		//save the hybrid in the cache
	}
	public void loadHybridGrammar(IValidationDocument tdoc, File vdoc, String namespace){
		//logger_.debug("Loading grammar tdoc:"+tdoc.getName()+" vdoc:"+vdoc+" ns:"+namespace);
		
		IValidationDocument vd = getGrammar(vdoc,null);
		IValidationDocument hvd = null;
		
		if(vdoc != null ){
			if(vd != null){
				hvd = new HybridValidationDocument(tdoc,vd);
			}
		}
		else{
			hvd=tdoc;
		}
		if(hvd != null){
			grammars_.put(namespace,hvd);
		}
		//save the hybrid in the cache
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IActionRequester#requestActions()
	 */
	public void requestActions() {
		
	}

	/* (non-Javadoc)
	 * @see butterfly.actions.interfaces.IActionRequester#setActionLookup(butterfly.actions.interfaces.IActionLookup)
	 */
	

}
