/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.pipeline;

import java.util.Hashtable;
import java.util.Properties;

import javax.xml.transform.Source;

import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.ElementStructure;
import butterfly.xmlview.model.validation.ValidationDocument;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.transformation.Pipeline;
import butterfly.xmlview.model.transformation.interfaces.ITransformation;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class PipelineDocument extends XmlDocument {
	private String namespace_ = "http://butterfly.opensource.cc/pipeline";
	
	class PipelineValidationDocument extends ValidationDocument{
		
		
		ElementStructure sourceElement_;
		ElementStructure transformationElement_;
		ElementStructure pipelineElement_;
		/**
		 * Constructor for PipelineValidationDocument.
		 * @param contenttype
		 */
		public PipelineValidationDocument() {
			super("text/xsd",null);
			buildElementStructure();
		}
		
		public void buildElementStructure(){
			//sourceElement_ = new ElementStructure(namespace_,SourceNode.NAME);
			transformationElement_ = new ElementStructure(namespace_,TransformationNode.NAME);
			pipelineElement_ = new ElementStructure(namespace_,PipelineNode.NAME);
			//pipelineElement_.addSubElement(sourceElement_);
			pipelineElement_.addSubElement(transformationElement_);
			
			IElementStructure[] structs = {pipelineElement_,transformationElement_};
			super.setElementStructures(structs);
		}

		/**
		 * @see butterfly.xmlview.model.interfaces.IValidationDocument#getElementStructure(String, String)
		 */
		public IElementStructure getElementStructure(
			String elname,
			String namespace) {
			if(namespace != null){
				if(namespace.equals(namespace_)){	
					if(elname.equals(SourceNode.NAME)){
						return sourceElement_;
					}
					else if(elname.equals(TransformationNode.NAME)){
						return transformationElement_;
					}
					else if(elname.equals(PipelineNode.NAME)){
						return pipelineElement_;	
					}
				}
			}
			return null;
		}

		

	}
	
	
	public static String PIPELINE_CONTENT_TYPE = "text/xml-pipeline";
	
	private PipelineNode root_= new PipelineNode();
	private Pipeline pipeline_;
	private Hashtable transformationNodes_=new Hashtable(3);
	/**
	 * Constructor for PipeLineDocument.
	 */
	public PipelineDocument(Pipeline pl) {
		super();
		setContentType(PIPELINE_CONTENT_TYPE);	
		root_.addAttribute(new Attribute("xmlns",namespace_));
		while(getRoot().childCount() > 0){
		  removeChild(getRoot(),getRoot().childAt(0),true);
		}
		addChild(getRoot(),root_,0,true);
		pipeline_ = pl;
		setSource(pl.getSource());
		for(int i = 0; i < pl.transformationCount(); i++){
			addTransformation(i,pl.transformationAt(i),pl.propertiesAt(i));	
		}
		setValidationDocument(new PipelineValidationDocument());
	}	

	public void setSource(Source src){
		root_.setSource(src);
//		if(root_.childCount() > 0){
//			if(root_.childAt(0) instanceof SourceNode){
//				removeChild(root_,root_.childAt(0),true);	
//			}	
//		}
//		addChild(root_,new SourceNode(src),0,true);
	}
	
	public void addTransformation(int index, ITransformation trans, Properties props){
		
		TransformationNode node = new TransformationNode(trans,props);
		addChild(root_,node,index,true);
		addChild(node,new ResultNode(),node.childCount(),false);
		transformationNodes_.put(trans,node);
	}
	public void removeTransformation(ITransformation t){
		TransformationNode node = (TransformationNode)transformationNodes_.get(t);
		if(node != null){
			pipeline_.removeTransformation(t);
			removeChild(node.getParent(),node);
		}
	}
	
	
	/**
	 * Returns the pipeline.
	 * @return Pipeline
	 */
	public Pipeline getPipeline() {
		return pipeline_;
	}

	/**
	 * Sets the pipeline.
	 * @param pipeline The pipeline to set
	 */
	public void setPipeline(Pipeline pipeline) {
		pipeline_ = pipeline;
	}

}
