/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.pipeline;

import javax.xml.transform.Source;

import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.Element;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class SourceNode extends Element {
	public static String NAME = "source";
	private Source source_;
	private Attribute sourceAttribute_;
	/**
	 * Constructor for SourceNode.
	 * @param name
	 */
	public SourceNode(Source src) {
		super(NAME);
		setSource(src);
	}

	/**
	 * Returns the source.
	 * @return Source
	 */
	public Source getSource() {
		return source_;
	}

	/**
	 * Sets the source.
	 * @param source The source to set
	 */
	public void setSource(Source source) {
		if(sourceAttribute_ != null){
			removeAttribute(sourceAttribute_);	
		}
		source_ = source;
		if(source != null){
		sourceAttribute_ = new Attribute(this,"id");
		//if(source.getSystemId() != null){
		sourceAttribute_.setData(source.getSystemId());
		//}
		addAttribute(sourceAttribute_);
		}
	}

}
