/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.pipeline;

import java.util.Enumeration;
import java.util.Properties;

import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.transformation.interfaces.ITransformation;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class TransformationNode extends Element {
	public static final String NAME = "transformation";
	private ITransformation transformation_;
	private Properties properties_;
	/**
	 * Constructor for TransformationNode.
	 * @param name
	 */
	public TransformationNode(ITransformation trans, Properties props) {
		super(NAME);
		transformation_ = trans;
		properties_ = props;
		addAttribute(new Attribute("type",trans.getName()));
		if(props != null){
			Enumeration names =props.propertyNames();	
			while(names.hasMoreElements()){
				String name = (String)names.nextElement();
				String value = props.getProperty(name);
				Attribute attr = new Attribute(this,name);
				attr.setData(value);
				addAttribute(attr);	
			}
		}
		//addChild(new ValueNode("Description: "+trans.getDescription()));
			
			
	}
	
	public void setName(){}

	/**
	 * Returns the transformation.
	 * @return ITransformation
	 */
	public ITransformation getTransformation() {
		return transformation_;
	}

	/**
	 * Sets the transformation.
	 * @param transformation The transformation to set
	 */
	public void setTransformation(ITransformation transformation) {
		transformation_ = transformation;
	}

}
