/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.transformation;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

import javax.xml.transform.stream.StreamSource;

import butterfly.xmlview.model.interfaces.IDocument;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DocumentSource extends StreamSource {
	private IDocument document_;
	/**
	 * Constructor for DocumentSource.
	 */
	public DocumentSource(IDocument doc) {
		super();
		document_ = doc;
		if(doc != null){
		if(doc.getSourceFileName() != null){
			setSystemId(new File(doc.getSourceFileName()));
		}
		}
	}

	/**
	 * Constructor for DocumentSource.
	 * @param inputStream
	 */
	public DocumentSource(InputStream inputStream) {
		super(inputStream);
	}

	/**
	 * Constructor for DocumentSource.
	 * @param inputStream
	 * @param systemId
	 */
	public DocumentSource(InputStream inputStream, String systemId) {
		super(inputStream, systemId);
	}

	/**
	 * Constructor for DocumentSource.
	 * @param reader
	 */
	public DocumentSource(Reader reader) {
		super(reader);
	}

	/**
	 * Constructor for DocumentSource.
	 * @param reader
	 * @param systemId
	 */
	public DocumentSource(Reader reader, String systemId) {
		super(reader, systemId);
	}

	/**
	 * Constructor for DocumentSource.
	 * @param systemId
	 */
	public DocumentSource(String systemId) {
		super(systemId);
	}

	/**
	 * Constructor for DocumentSource.
	 * @param f
	 */
	public DocumentSource(File f) {
		super(f);
	}

	/**
	 * @see javax.xml.transform.stream.StreamSource#getPublicId()
	 */
	public String getPublicId() {
		return super.getPublicId();
	}

	/**
	 * @see javax.xml.transform.stream.StreamSource#getReader()
	 */
	public Reader getReader() {
		StringReader r = new StringReader(document_.toString());
		System.out.println(document_.toString());
		return r;
	}

	/**
	 * @see javax.xml.transform.Source#getSystemId()
	 */
	public String getSystemId() {
		if(super.getSystemId() != null){
			return super.getSystemId();
		}
		return document_.getName();
	}

	/**
	 * @see javax.xml.transform.stream.StreamSource#setInputStream(InputStream)
	 */
	public void setInputStream(InputStream inputStream) {
		
	}

	/**
	 * @see javax.xml.transform.stream.StreamSource#setPublicId(String)
	 */
	public void setPublicId(String publicId) {
		super.setPublicId(publicId);
	}

	/**
	 * @see javax.xml.transform.stream.StreamSource#setReader(Reader)
	 */
	public void setReader(Reader reader) {
		
	}

	/**
	 * @see javax.xml.transform.stream.StreamSource#setSystemId(File)
	 */
	public void setSystemId(File f) {
		super.setSystemId(f);
	}

	/**
	 * @see javax.xml.transform.Source#setSystemId(String)
	 */
	public void setSystemId(String systemId) {
		super.setSystemId(systemId);
	}

	/**
	 * Returns the document.
	 * @return IDocument
	 */
	public IDocument getDocument() {
		return document_;
	}

	/**
	 * Sets the document.
	 * @param document The document to set
	 */
	public void setDocument(IDocument document) {
		document_ = document;
	}

}
