/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.transformation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.xalan.trace.TraceListener;

import butterfly.xmlview.model.transformation.interfaces.IPipelineListener;
import butterfly.xmlview.model.transformation.interfaces.ITransformation;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class Pipeline implements ITransformation{
	private ArrayList transformations_ = new ArrayList(1);
	private ArrayList transProps_ = new ArrayList(1);
	private Source source_;
	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getProperties()
	 */
	public Properties getDefaultProperties() {
		return null;
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getPropertyNames()
	 */
	public String[] getPropertyNames() {
		return null;
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#transform(Source, Result, Properties)
	 */
	public void transform(Source source, Properties props, int max,IPipelineListener tl,Result r) throws TransformationException{
		StringReader reader = null;
		StreamSource src = null;
		StringWriter resultstr = new StringWriter();
		StreamResult result = new StreamResult(resultstr);
		
		if(transformationCount() > 0){
			if(max != 1){
			transformationAt(0).transform(source,propertiesAt(0),tl,result);
			String res = resultstr.toString();
			for(int i = 1; i< max-1; i++){
				resultstr=new StringWriter();
				result = new StreamResult(resultstr);
				reader = new StringReader(res);
				src = new StreamSource(reader);
				transformationAt(i).transform(src,propertiesAt(i),tl,result);
				res = resultstr.toString();
			}
			
			reader = new StringReader(res);
			src = new StreamSource(reader);
			transformationAt(max-1).transform(src,propertiesAt(max-1),tl,r);
			}
			else{
				transformationAt(0).transform(source,propertiesAt(0),tl,r);
			}
			
		//	}catch(Exception e){e.printStackTrace();}
			
			//res = so.toString();
			//return res;
		}
		//return "";
	}

	protected String convertLines(String res){
		try{
		StringReader sr = new StringReader(res);
		BufferedReader br = new BufferedReader(sr);
		StringWriter so = new StringWriter();
		BufferedWriter bo = new BufferedWriter(so);
		String line = null;
		
			while((line = br.readLine())!=null){
				bo.write(line);
				bo.write("\n");	
			}
			bo.flush();
			bo.close();
			br.close();
		res=so.toString();
		}catch(Exception e){
			
		}
		return res;
	}
	
	public String transform(Source source, Properties props,int steps,IPipelineListener tl) throws TransformationException{
		StringWriter sw = new StringWriter();
		StreamResult result = new StreamResult(sw);
		transform(source,props,transformationCount(),tl,result);	
		return convertLines(sw.toString());
	}
	public void transform(Source source, Properties props,IPipelineListener tl,Result r) throws TransformationException{
		
		transform(source,props,transformationCount(),tl,r);	
		
	}
	
	public void addTransformation(ITransformation t,Properties p){
		addTransformation(transformationCount(),t,p);
	}
	
	public void addTransformation(int index, ITransformation trans, Properties p){
		transformations_.add(index,trans);	
		transProps_.add(index,p);
	}
	public void removeTransformation(ITransformation trans){
		int index = transformations_.indexOf(trans);
		if(index > -1){
			transformations_.remove(index);
			transProps_.remove(index);
		}
	}
	
	public int transformationCount(){
		return transformations_.size();	
	}
	
	public ITransformation transformationAt(int index){
		return (ITransformation)transformations_.get(index);	
	}
	
	public Properties propertiesAt(int index){
		return (Properties)transProps_.get(index);	
	}
	
	public String execute() throws TransformationException{
		return transform(getSource(),getDefaultProperties(),transformations_.size()-1,null);
	}
	
	public String execute(int steps) throws TransformationException{
		
		return execute(steps,null);
	}
	public void execute(int steps, Result r,IPipelineListener pl)throws TransformationException{
		transform(getSource(),getDefaultProperties(),steps,pl,r);
	}
	public String execute(int steps,IPipelineListener tl) throws TransformationException{
		if(steps == 0){
			if(source_ instanceof DocumentSource){
				return ((DocumentSource)source_).getDocument().toString();
			}
			return source_.toString();
		}	
		return transform(getSource(),getDefaultProperties(),steps,tl);
	}
	

	/**
	 * Returns the source.
	 * @return Source
	 */
	public Source getSource() {
		return source_;
	}

	/**
	 * Sets the source.
	 * @param source The source to set
	 */
	public void setSource(Source source) {
		source_ = source;
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getDescription()
	 */
	public String getDescription() {
		return "An XML Transformation Pipeline";
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getName()
	 */
	public String getName() {
		return "Pipeline";
	}

}
