/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.transformation;

import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import butterfly.xmlview.model.transformation.interfaces.ITransformation;
import butterfly.xmlview.model.transformation.interfaces.ITransformationFactory;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class TransformationFactory implements ITransformationFactory,Configurable,Composable {
	public static final String ROLE_ATTRIBUTE = "role";
	public static final String NAME_ATTRIBUTE = "name";
	
	private ComponentManager manager_;
	private Configuration configuration_;
	/**
	 * Constructor for TransformationFactory.
	 */
	public TransformationFactory() {
		super();
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformationFactory#getTransformationRoles()
	 */
	public String[] getTransformationRoles() {
		return null;
	}
	
	public String[] getTransformationNames() {
		return null;	
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformationFactory#getTransformation(String)
	 */
	public ITransformation getTransformation(String role) {
		return null;
	}

	/**
	 * @see org.apache.avalon.framework.configuration.Configurable#configure(Configuration)
	 */
	public void configure(Configuration arg0) throws ConfigurationException {
		configuration_ = arg0;
		if(manager_ != null){
			init();	
		}
	}

	/**
	 * @see org.apache.avalon.framework.component.Composable#compose(ComponentManager)
	 */
	public void compose(ComponentManager arg0) throws ComponentException {
		manager_ = arg0;
		if(configuration_ != null){
			init();	
		}
	}
	
	private void init(){
		Configuration[] trans = configuration_.getChildren();
		
	}
	
	public void addTransformation(String role,String name){
		
	}

}
