/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.model.transformation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

import javax.xml.transform.Result;
import javax.xml.transform.Source;

import org.apache.xalan.trace.TraceListener;

import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.model.transformation.interfaces.IPipelineListener;
import butterfly.xmlview.model.transformation.interfaces.ITransformation;
import butterfly.xmlview.xslt.interfaces.IXmlViewXsltTransformer;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class XSLTTransformation implements ITransformation {
	public static String XSL_PROPERTY = "xsl";
	/**
	 * Constructor for XSLTTransformation.
	 */
	public XSLTTransformation() {
		super();
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#transform(Source, Properties)
	 */
	public void transform(Source source, Properties props,IPipelineListener tl,Result r) {
		String result;
		try{
			IXmlViewXsltTransformer transformer =
            (IXmlViewXsltTransformer) ButterflyApplication.getInstance().getComponent(
                IXmlViewXsltTransformer.ROLE);	
            transformer.transform(source,props,tl,r);
		}
		catch(Exception e){
			e.printStackTrace();
			StringWriter ew = new StringWriter();
			PrintWriter pw = new PrintWriter(ew);
			e.printStackTrace(pw);
			result = "<error>"+ew.toString()+"</error>";
		}
	//	return result;
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getPropertyNames()
	 */
	public String[] getPropertyNames() {
		return new String[]{XSL_PROPERTY};
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getProperties()
	 */
	public Properties getDefaultProperties() {
		return new Properties();
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getName()
	 */
	public String getName() {
		return "XSL Transformation";
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getDescription()
	 */
	public String getDescription() {
		return "A transformation using an XSL stylesheet." ;
	}

}
