/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.search;

import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.search.interfaces.ISearch;
import butterfly.xmlview.search.interfaces.ISearchResult;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public abstract class AbstractSearch implements ISearch {
	private IDocument document_;
	private ISearchResult current_;
	/**
	 * Constructor for TextSearch.
	 */
	public AbstractSearch() {
		super();
	}



	/**
	 * @see butterfly.xmlview.search.interfaces.ISearch#next()
	 */
	public ISearchResult next(String srch) {
		ISearchResult curr = next(current(),srch);
		if(curr != null){
			setCurrent(curr);
		}
		return curr;
	}

	/**
	 * @see butterfly.xmlview.search.interfaces.ISearch#previous()
	 */
	public ISearchResult previous(String srch) {
		ISearchResult curr = previous(current(),srch);
		if(curr != null){
			setCurrent(curr);
		}
		return curr;
	}
	
	/**
	 * @see butterfly.xmlview.search.interfaces.ISearch#next()
	 */
	public abstract ISearchResult next(ISearchResult result,String srch) ;

	/**
	 * @see butterfly.xmlview.search.interfaces.ISearch#previous()
	 */
	public abstract ISearchResult previous(ISearchResult result,String srch);

	
	/**
	 * Returns the current.
	 * @return ISearchResult
	 */
	public ISearchResult current() {
		return current_;
	}

	/**
	 * Returns the document.
	 * @return IDocument
	 */
	public IDocument getDocument() {
		return document_;
	}

	/**
	 * Sets the current.
	 * @param current The current to set
	 */
	public void setCurrent(ISearchResult current) {
		current_ = current;
	}

	/**
	 * Sets the document.
	 * @param document The document to set
	 */
	public void setDocument(IDocument document) {
		setCurrent(null);
		document_ = document;
	}

	

}
