/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.search;

import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.search.interfaces.ISearchResult;

/**
 * @author jules
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class SearchResult implements ISearchResult {
	private int start_=-1;
	private int length_=-1;
	private INode node_;
	/**
	 * Constructor for SearchResult.
	 */
	public SearchResult() {
		super();
	}
	public SearchResult(INode node, int start, int length) {
		super();
		node_ = node;
		start_ = start;
		length_ = length;
	}
	public SearchResult(INode node) {
		super();
		node_ = node;
		start_ =node.getStart();
		length_ = node.getLength();
	}
	public SearchResult(int start, int length) {
		super();
		
		start_ = start;
		length_ = length;
	}
	

	
	/**
	 * Returns the length.
	 * @return int
	 */
	public int getLength() {
		return length_;
	}

	/**
	 * Returns the node.
	 * @return INode
	 */
	public INode getNode() {
		return node_;
	}

	/**
	 * Returns the start.
	 * @return int
	 */
	public int getStart() {
		return start_;
	}

	/**
	 * Sets the length.
	 * @param length The length to set
	 */
	public void setLength(int length) {
		length_ = length;
	}

	/**
	 * Sets the node.
	 * @param node The node to set
	 */
	public void setNode(INode node) {
		node_ = node;
	}

	/**
	 * Sets the start.
	 * @param start The start to set
	 */
	public void setStart(int start) {
		start_ = start;
	}

}
