/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.test;

import java.awt.Color;
import java.awt.Insets;

import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultHighlighter;

import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;

import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.SplashScreen;
import butterfly.xmlview.model.ScratchTag;
//import org.outerj.pollo.plaf.*;
//import net.sourceforge.mlf.metouia.*;
/**
 * Insert the type's description here.
 * Creation date: (8/17/2002 1:44:25 AM)
 * @author: 
 */
public class Main {

	ExcaliburComponentManager manager = new ExcaliburComponentManager();
/**
 * Main constructor comment.
 */
public Main() {
	super();
}
    public void dispose()
    {
        this.manager.dispose();
    }
public void initialize(String[] args) throws Exception {
	SplashScreen ss = new SplashScreen();
	
	
		
	
	
	
    DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
   
    Configuration sysConfig = builder.buildFromFile("butterfly.conf");
    Configuration roleConfig = builder.buildFromFile("butterfly.roles");
org.apache.log.Logger l = Hierarchy.getDefaultHierarchy()
                           .getLoggerFor("Initializer") ;
   
    DefaultRoleManager roles = new DefaultRoleManager();
    roles.enableLogging(new LogKitLogger(l));
	//roles.enableLogging(new LogKitLogger(Hierarchy.getDefaultHierarchy().getLoggerFor("document.roles")));
	
   
    if(args.length == 0 || !args[0].equals("-d")){
    	LogTarget[] t = new LogTarget[0];
    	l.setLogTargets(t);
    }
    else{
    	Logger.getDefaultHierarchy().setThreshold(Level.OFF);
    }
    
    
    
    roles.configure(roleConfig);
    
	manager.setLogger(l );
    
	//manager.enableLogging(new LogKitLogger(Hierarchy.getDefaultHierarchy()
     //                      .getLoggerFor("document")));
    manager.contextualize(new DefaultContext());
    manager.setRoleManager(roles);
    manager.configure(sysConfig);
    manager.initialize();

   	ButterflyApplication app = (ButterflyApplication)manager.lookup("butterfly.xmlview.ButterflyApplication");
   	app.setApplicationProperty(ButterflyApplication.APPLICATION_ARGUMENTS,args);
    app.init();
   	ss.setVisible(false);
   	
   // IButterflyDesktop desktop = (IButterflyDesktop)manager.lookup(IButterflyDesktop.ROLE);
}
/**
 * Insert the method's description here.
 * Creation date: (8/17/2002 1:44:42 AM)
 * @param args java.lang.String[]
 */
public static void main(String[] args) {

    try {
    	System.setProperty("java.protocol.handler.pkgs","butterfly.protocols");
//    	System.out.println(System.getProperty("java.protocol.handler.pkgs"));
//    	System.out.println("Running URL initialization test...");
//    	URL url = new URL("butterfly://c:/categories.xml");
//    	InputStream str =url.openConnection().getInputStream();
//    	System.out.println("Stream fetched = "+(str!=null));
    	ScratchTag t = new ScratchTag(null,-1,-1);
    	UIManager.setLookAndFeel(new MetouiaLookAndFeel());
    	UIManager.put("TabbedPane.tabInsets",new Insets(0,5,0,5));
        UIManager.put("TabbedPane.selectedTabPadInsets",new Insets(0,0,0,0));
        UIManager.put("TabbedPane.tabAreaInsets",new Insets(0,0,0,0));
        UIManager.put("TabbedPane.contentBorderInsets",new Insets(0,0,0,0));
    	UIManager.put("Menu.margin",new Insets(5,70,5,5));
    	UIManager.put("Menu.borderPainted",Boolean.FALSE);
    	UIManager.put("PopupMenu.border",new LineBorder(Color.BLACK,1));
    	UIManager.put("PopupMenu.background",Color.WHITE);
    	//UIManager.put("PopupMenu.foreground",Color.WHITE);
    	UIManager.put("TabbedPane.selected",Color.WHITE);
    	UIManager.put("TabbedPane.unselected",new Color(238, 238, 230));
    	
    	//UIManager.getDefaults().putDefaults(new Object[]{"PopupMenuSeparatorUI","com.stefankrause.xplookandfeel.XPPopupMenuSeparatorUI"});
    	UIManager.put("TextArea.caretBlinkRate",new Integer(500));
    	//UIManager.setLookAndFeel(new ButterflyLF());
    	//UIManager.setLookAndFeel("com.shfarr.ui.plaf.fh.FhLookAndFeel");
      
       Main m = new Main();
       m.initialize(args);
    } catch (Exception e) {
        e.printStackTrace();
    }
}
}
