/*
 * The Butterfly XML Editor
 * http://www.butterflyxml.org
 * 
 * Copyright (C) 2004  Jules White
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Original Author: Jules White
 * Contributor(s):
 */
package butterfly.xmlview.xslt;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.batik.ext.swing.GridBagConstants;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;

import sun.security.action.GetLongAction;

import butterfly.actions.interfaces.IActionLookup;
import butterfly.actions.interfaces.IActionRequester;
import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.xmlview.model.XmlDocument;

import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.transformation.DocumentSource;
import butterfly.xmlview.model.transformation.TransformationException;
import butterfly.xmlview.model.transformation.interfaces.IPipelineListener;
import butterfly.xmlview.model.transformation.interfaces.ITransformation;
import butterfly.xmlview.xslt.interfaces.IXmlViewXsltTransformer;
/**
 * Insert the type's description here.
 * Creation date: (8/19/2002 4:38:02 PM)
 * @author: 
 */
public class XmlViewXsltTransformer
	implements IXmlViewXsltTransformer, ITransformation, IActionRequester {

	public static final String XSL_FILE_KEY = "xsl";

	public static final String[] PROPERTY_NAMES = { XSL_FILE_KEY };

	private IActionLookup actionLookup_;

	private Properties properties_ = new Properties();
	private TransformerImpl transformer_;
	private XmlDocument xslDocument_;
	/**
	 * Insert the method's description here.
	 * Creation date: (8/19/2002 5:29:36 PM)
	 * @param args java.lang.String[]
	 */
//	public static void main(String[] args) {
//		try {
//			java.io.FileReader in = new java.io.FileReader(args[0]);
//			java.io.BufferedReader reader = new java.io.BufferedReader(in);
//
//			String line = "";
//			String xml = "";
//			while ((line = reader.readLine()) != null) {
//				xml += line + "\n";
//			}
//
//			in = new java.io.FileReader(args[1]);
//			reader = new java.io.BufferedReader(in);
//
//			line = "";
//			String xsl = "";
//			while ((line = reader.readLine()) != null) {
//				xsl += line + "\n";
//			}
//			XmlViewXsltTransformer xslt = new XmlViewXsltTransformer();
//			System.out.println("output: " + xslt.transform(xml, xsl));
//
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//
//	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/19/2002 4:39:45 PM)
	 * @return java.lang.String
	 * @param xml java.lang.String
	 * @param xsl java.lang.String
	 */
	public String transform(String xml, String xsl) throws Exception {
		TransformerFactory tfactory = TransformerFactory.newInstance();

		// Create a transformer for the stylesheet.
		StringReader xslsrc = new StringReader(xsl);
		Transformer transformer =
			tfactory.newTransformer(new StreamSource(xslsrc));

		// Transform the source XML to System.out.
		StringReader xmlsrc = new StringReader(xml);
		StringWriter result = new StringWriter();

		transformer.transform(
			new StreamSource(xmlsrc),
			new StreamResult(result));

		return result.toString();
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getDescription()
	 */
	public String getDescription() {
		return "An XSL transformation.";
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getName()
	 */
	public String getName() {
		return "XSL Transformation";
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getProperties()
	 */
	public Properties getDefaultProperties() {
		return new Properties();
	}

	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#getPropertyNames()
	 */
	public String[] getPropertyNames() {
		return PROPERTY_NAMES;
	}

//	//class TraceGui implements TraceListener{
//	/*	private JTextArea events_;
//		private Thread xslThread_;
//		public TraceGui(){
//			JFrame f = new JFrame();
//			f.setSize(400,400);
//			f.getContentPane().setLayout(new GridBagLayout());
//			GridBagConstraints cons = new GridBagConstraints();
//			cons.gridx=0;
//			cons.gridy=0;
//			cons.weightx=1;
//			cons.weighty=1;
//			cons.fill=cons.BOTH;
//			events_=new JTextArea();
//			f.getContentPane().add(new JScrollPane(events_),cons);
//			JButton step = new JButton(">");
//			step.addActionListener(new ActionListener() {
//				public void actionPerformed(ActionEvent e) {
//					// TODO Auto-generated method stub
//					step();
//				}
//			});
//			cons.fill=cons.HORIZONTAL;
//			cons.gridy++;
//			f.getContentPane().add(step,cons);
//			f.show();
//		}
//		public synchronized void step(){
//			notifyAll();
//		}
//		public synchronized void pause(){
//			try{
//				wait();
//			}catch(Exception e){
//				e.printStackTrace();
//			}*/
//		//}
//			/* (non-Javadoc)
//		 * @see org.apache.xalan.trace.TraceListener#generated(org.apache.xalan.trace.GenerateEvent)
//		 */
//		public void generated(GenerateEvent ev) {
//			// TODO Auto-generated method stub
//			xslThread_=Thread.currentThread();
//			events_.setText("Generated:"+ev.m_name+"\n"+events_.getText());
//			pause();
//		}
//
//		/* (non-Javadoc)
//		 * @see org.apache.xalan.trace.TraceListener#selected(org.apache.xalan.trace.SelectionEvent)
//		 */
//		public void selected(SelectionEvent ev) throws TransformerException {
//			// TODO Auto-generated method stub
//
//		}
//
//		/* (non-Javadoc)
//		 * @see org.apache.xalan.trace.TraceListener#trace(org.apache.xalan.trace.TracerEvent)
//		 */
//		public void trace(TracerEvent ev) {
//			// TODO Auto-generated method stub
//
//		}
//
//}
	
	public String transform(Source source, Properties props,IPipelineListener tl) throws TransformationException{
		StringWriter sw = new StringWriter();
		StreamResult result = new StreamResult(sw);
		transform(source,props,tl,result);
		return sw.toString();
	}
	
	
	
	public TransformerImpl setup(XmlDocument doc) throws Exception{
		
		DocumentSource xslsrc = new DocumentSource(doc);
		TransformerFactory tfactory = TransformerFactoryImpl.newInstance();
		xslDocument_=doc;
		transformer_ = (TransformerImpl)tfactory.newTransformer(xslsrc);
		return transformer_;
	}
	
	public void transform(Source source, IPipelineListener tl, Result r)throws TransformationException{
		try {
			Transformer transformer = transformer_;
//			XsltDebugger debugger= new XsltDebugger();
			
			//debugger.debug((XmlDocument)((DocumentSource)source).getDocument(),(XmlDocument)doc);
			//debugger.createGui();
			if( tl instanceof TraceListener){
				((TransformerImpl)transformer).getTraceManager().addTraceListener((TraceListener)tl);
			}
			if(tl instanceof XsltDebugger){
				((XsltDebugger)tl).debug((XmlDocument)((DocumentSource)source).getDocument(),(XmlDocument)xslDocument_);
			}
			if(tl!=null){
				tl.startingTransformation(source,properties_,r);
			}
			//Result r = new StreamResult(result);
			transformer.transform(source, r);
			if(tl!=null){
				tl.transformationFinished(source,properties_,r);
			}
		} catch (Exception e) {
			TransformationException te = new TransformationException(e);
			te.source=this;
			te.properties=properties_;
			throw te;
		}
	}
	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#transform(Source, Properties)
	 */
	public void transform(Source source, Properties props,IPipelineListener tl,Result r) throws TransformationException{
			//System.out.println("Transforming with: "+source.getSystemId());
			if(props == null){
				TransformationException te = new TransformationException("No properties were specified for the XSL transformation.");
				te.source=this;
				te.properties=props;
				throw te;	
			}
			if(props.getProperty(XSL_FILE_KEY)==null){
				TransformationException te = new TransformationException("No XSL file was specified for the transformation.");
				te.source=this;
				te.properties=props;
				throw te;
			}
			IDocument doc = loadXslDocument(props);
			//System.out.println("xsl:"+doc.toString());
			if(doc == null || doc.toString() == null){
				TransformationException te = new TransformationException("Unable to load the XSL file:"+props.getProperty(XSL_FILE_KEY));
				te.source=this;
				te.properties=props;
				throw te;	
			}
			DocumentSource xslsrc = new DocumentSource(doc);
			TransformerFactory tfactory = TransformerFactory.newInstance();
			//StringWriter result = new StringWriter();
			// Create a transformer for the stylesheet.
		try {
			Transformer transformer = tfactory.newTransformer(xslsrc);
//			XsltDebugger debugger= new XsltDebugger();
			
			//debugger.debug((XmlDocument)((DocumentSource)source).getDocument(),(XmlDocument)doc);
			//debugger.createGui();
			if( tl instanceof TraceListener){
			((TransformerImpl)transformer).getTraceManager().addTraceListener((TraceListener)tl);
			}
			if(tl instanceof XsltDebugger){
				((XsltDebugger)tl).debug((XmlDocument)((DocumentSource)source).getDocument(),(XmlDocument)doc);
			}
			if(tl!=null){
				tl.startingTransformation(source,props,r);
			}
			//Result r = new StreamResult(result);
			transformer.transform(source, r);
			if(tl!=null){
				tl.transformationFinished(source,props,r);
			}
		} catch (Exception e) {
			TransformationException te = new TransformationException(e);
			te.source=this;
			te.properties=props;
			throw te;
		}

		//return result.toString();
	}
	
	/**
	 * @see butterfly.xmlview.model.transformation.interfaces.ITransformation#transform(Source, Properties)
	 */
	public void transform(Source source, XmlDocument doc,IPipelineListener tl,Result r) throws TransformationException{
		//System.out.println("Transforming with: "+source.getSystemId());
		
		
		DocumentSource xslsrc = new DocumentSource(doc);
		TransformerFactory tfactory = TransformerFactory.newInstance();
		//StringWriter result = new StringWriter();
		// Create a transformer for the stylesheet.
		try {
			Transformer transformer = tfactory.newTransformer(xslsrc);
//			XsltDebugger debugger= new XsltDebugger();
			
			//debugger.debug((XmlDocument)((DocumentSource)source).getDocument(),(XmlDocument)doc);
			//debugger.createGui();
			if( tl instanceof TraceListener){
				((TransformerImpl)transformer).getTraceManager().addTraceListener((TraceListener)tl);
			}
			if(tl instanceof XsltDebugger){
				((XsltDebugger)tl).debug((XmlDocument)((DocumentSource)source).getDocument(),(XmlDocument)doc);
			}
			if(tl!=null){
				tl.startingTransformation(source,null,r);
			}
			//Result r = new StreamResult(result);
			transformer.transform(source, r);
			if(tl!=null){
				tl.transformationFinished(source,null,r);
			}
		} catch (Exception e) {
			TransformationException te = new TransformationException(e);
			te.source=this;
			
			throw te;
		}

		//return result.toString();
	}

	private IDocument loadXslDocument(Properties p) {
		String filen = p.getProperty(XSL_FILE_KEY);
		//System.out.println("loading"+filen);
		File file = new File(filen);
		IFileOpenAction open =
			(IFileOpenAction) actionLookup_.getAction(IFileOpenAction.ROLE);
		open.setFile(file);
	//	open.setTypeToOpenAs("text/plain");
		open.setShowFile(false);
		open.actionPerformed(null);
		IDocument doc = open.getDocument();
		return doc;
	}
	/**
	 * @see butterfly.actions.interfaces.IActionRequester#requestActions()
	 */
	public void requestActions() {
	}

	/**
	 * @see butterfly.actions.interfaces.IActionRequester#setActionLookup(IActionLookup)
	 */
	public void setActionLookup(IActionLookup lookup) {
		actionLookup_ = lookup;
	}
	
	public static void main(String[] args){
		try{
			System.out.println("Starting Transformation");
			TransformerFactory tfactory = TransformerFactory.newInstance();
			
			// Create a transformer for the stylesheet.
			
			Transformer transformer =
			tfactory.newTransformer(new StreamSource(new File(args[1])));
			StreamSource in = new StreamSource(new File(args[0]));
			StringWriter sw = new StringWriter();
			transformer.transform(in,new StreamResult(sw));
			System.out.println("Result:"+sw.toString());
		}catch(Exception e){
			e.printStackTrace();
		}
		
	}

}
