/*
 * Created on Apr 7, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package butterfly.xmlview.xslt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

import org.apache.xalan.templates.ElemApplyTemplates;
import org.apache.xalan.templates.ElemCallTemplate;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.trace.EndSelectionEvent;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListenerEx2;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;

import butterfly.actions.GoToLineAction;
import butterfly.actions.interfaces.IFileChooseAction;
import butterfly.actions.interfaces.IFileOpenAction;
import butterfly.xmlview.ButterflyApplication;
import butterfly.xmlview.gui.MultiViewComponent;
import butterfly.xmlview.gui.TableUI;
import butterfly.xmlview.gui.XmlSourceEditor;
import butterfly.xmlview.gui.XmlViewInformer;
import butterfly.xmlview.gui.interfaces.INodeSelectionListener;
import butterfly.xmlview.gui.interfaces.IXmlRenderer;
import butterfly.xmlview.gui.interfaces.IXmlViewInformer;
import butterfly.xmlview.gui.tree.DocumentTree;
import butterfly.xmlview.gui.tree.TreeEditorLookup;
import butterfly.xmlview.gui.tree.XmlTreeEditor;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import butterfly.xmlview.model.transformation.DocumentResult;
import butterfly.xmlview.model.transformation.DocumentSource;
import butterfly.xmlview.model.transformation.interfaces.IPipelineListener;
import butterfly.xmlview.xslt.interfaces.IXsltDebuggerListener;

/**
 * @author jules
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class XsltDebugger implements TraceListenerEx2,IPipelineListener,IDocumentListener,IXmlRenderer{
	
	abstract class BreakpointAction extends AbstractAction{
		public void actionPerformed(ActionEvent ae){
			int where = xslSource_.getCaret().getDot();
			if(where > -1 && where < xsl_.length()-1){
				int line = getLine(xsl_,where);
				handleBreakpoint(line);
			}
		}
		public Breakpoint getBreakpoint(int line){
			return (Breakpoint)breakpoints_.get(new Integer(line));
		}
		public boolean breakpointExists(int where){
			
			if(where > -1 && where < xsl_.length()-1){
				int line = getLine(xsl_,where);
				return getBreakpoint(line)!=null;
			}
			return false;
		}
		abstract void handleBreakpoint(int line);
	}
	public class AddBreakpointAction extends BreakpointAction{
		public AddBreakpointAction(){
			putValue(NAME,"Add Breakpoint");
		}
			/* (non-Javadoc)
		 * @see butterfly.xmlview.xslt.XsltDebugger.BreakpointAction#handleBreakpoint(int)
		 */
		void handleBreakpoint(int line) {
			// TODO Auto-generated method stub
			Breakpoint p = new Breakpoint(line);
			addBreakpoint(line);
		}

}
	
	public  class RemoveBreakpointAction extends BreakpointAction{
		public RemoveBreakpointAction(){
			putValue(NAME,"Remove Breakpoint");
		}
		void handleBreakpoint(int line) {
			// TODO Auto-generated method stub
			
			removeBreakpoint(line);
		}
	}
	public  class DisableBreakpointAction extends BreakpointAction{
		public  DisableBreakpointAction(){
			putValue(NAME,"Toggle Breakpoint");
		}
		void handleBreakpoint(int line) {
			// TODO Auto-generated method stub
			Breakpoint p = getBreakpoint(line);
			if(p!=null){
				if(p.enabled()){
					disableBreakpoint(line);
				}
				else{
					enableBreakpoint(line);
				}
			}
		}
	}
	
	class Arrow extends JPanel{
		
			/* (non-Javadoc)
		 * @see javax.swing.JComponent#printComponent(java.awt.Graphics)
		 */
		protected void paintComponent(Graphics g) {
			// TODO Auto-generated method stub
			super.paintComponent(g);
			
			g.setColor(Color.blue);
			g.fillPolygon(new int[]{0,getWidth(),0,getWidth(),getWidth()/2},new int[]{0,0,getHeight()-20,getHeight()-20,getHeight()},5);
		}
		public Dimension getPreferredSize(){
			Dimension pref = super.getPreferredSize();
			//if(pref.width < 400){
			pref.width=20;	
			//}	
			return pref;
		}	

}
	

	
	
	private XmlDocument xsl_;
	private XmlDocument xml_;
	private JTextArea events_;
	private JEditorPane xslSource_;
	private JLabel inputSource_;
	private Style activeBreakpointStyle_;
	private Style disabledBreakpointStyle_;
	private JEditorPane resultSource_;
	private JTable callStack_;
	private JLabel contextNode_;
	private JLabel currentElem_;
	private JPanel contentPane_;
	private JTable variableStack_;
	private DocumentTree resultTree_;
	private Vector listeners_=new Vector(1);
	private Stack stack_=new Stack();
	private Stack invocationStack_=new Stack();
	private Stack stackFrames_=new Stack();
	private Hashtable invocationTable_=new Hashtable();
	private Object templateCaller_;
	private Hashtable nodeLookup_=new Hashtable();
	private Hashtable activeElementTable_= new Hashtable();
	private Hashtable breakpoints_=new Hashtable();
	private TransformerImpl transformer_;
	private Vector variables_=new Vector();
	private int playFrom_=-1;
	private boolean stepping_=false;
	private boolean bail_=false;
	private boolean running_=false;
	private JButton play_;
	private JButton pause_;
	private JButton stop_;
	private JButton step_;
	
	
	private Thread debugThread_;
	
	private BreakpointAction addBreakpoint_=new AddBreakpointAction();
	private BreakpointAction removeBreakpoint_= new RemoveBreakpointAction();
	private BreakpointAction disableBreakpoint_= new DisableBreakpointAction();
	/**
	 * 
	 */
	public XsltDebugger() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public void fireSelectedEvent(SelectionEvent se){
		for(int i = 0; i < listeners_.size(); i++){
			((IXsltDebuggerListener)listeners_.elementAt(i)).selectionEvent(se);
		}
	}
	public void fireTraceEvent(TracerEvent se){
		for(int i = 0; i < listeners_.size(); i++){
			((IXsltDebuggerListener)listeners_.elementAt(i)).traceEvent(se);
		}
	}
	public void fireGenerateEvent(GenerateEvent se){
		for(int i = 0; i < listeners_.size(); i++){
			((IXsltDebuggerListener)listeners_.elementAt(i)).generationEvent(se);
		}
	}
	public void fireBreakpointHit(){
		for(int i = 0; i < listeners_.size(); i++){
			((IXsltDebuggerListener)listeners_.elementAt(i)).breakPointHit();
		}
	}
	public void firePaused(){
		for(int i = 0; i < listeners_.size(); i++){
			((IXsltDebuggerListener)listeners_.elementAt(i)).paused();
		}
	}
	public void fireStopped(){
		for(int i = 0; i < listeners_.size(); i++){
			((IXsltDebuggerListener)listeners_.elementAt(i)).stopped();
		}
	}
	
	public void debug(XmlDocument totransform, XmlDocument xsl){
		xsl_=xsl;
		xml_=totransform;
		((XmlSourceEditor)xslSource_).loadDocument(xsl_);
		//createGui();
	}
	
	
	/* (non-Javadoc)
	 * @see org.apache.xalan.trace.TraceListenerEx2#traceEnd(org.apache.xalan.trace.TracerEvent)
	 */
	public void traceEnd(TracerEvent ev) {
		// TODO Auto-generated method stub
		System.out.println("TraceEnd:"+ev.m_styleNode);
		if(ev.m_styleNode instanceof ElemTemplate && stack_.size()>0){
			stack_.pop();
			if(stackFrames_.size()>0){
				stackFrames_.pop();			
				if(stackFrames_.size()>0){
					variables_=(Vector)stackFrames_.peek();
				}
			}
		}
		System.out.println("Updating Variables");
		if(ev.m_styleNode instanceof ElemVariable){
//			try{
//			((ElemVariable)ev.m_styleNode).execute(ev.m_processor);
//			}catch(Exception e){
//				
//			}
			variableInScope((ElemVariable)ev.m_styleNode);
			updateVariables(ev.m_processor);
		}
		System.out.println("<< TraceEnd");
	}

	/* (non-Javadoc)
	 * @see org.apache.xalan.trace.TraceListenerEx#selectEnd(org.apache.xalan.trace.EndSelectionEvent)
	 */
	public void selectEnd(EndSelectionEvent ev) throws TransformerException {
		// TODO Auto-generated method stub

	}

	public void createGui(){
		JFrame f = new JFrame();
		f.setSize(600,600);
		createContentPane();
		f.setContentPane(contentPane_);
		
		f.show();
	}
			
	public void createContentPane(){
			
			contentPane_=new JPanel();
			contentPane_.setLayout(new BorderLayout());
			//contentPane_.setSize(600,600);
			

			
			//controls	
			JToolBar controls = new JToolBar();
			
			JButton play = new JButton(new ImageIcon("icons/stock_play.png"));
			play_=play;
			play.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					// TODO Auto-generated method stub
					play();
				}
			});
			controls.add(play);
			JButton pause = new JButton(new ImageIcon("icons/stock_pause.png"));
			pause_=pause;
			pause.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					// TODO Auto-generated method stub
					pause();
				}
			});
			controls.add(pause);
			JButton stop = new JButton(new ImageIcon("icons/stock_stop-d.png"));
			stop_=stop;
			stop.addActionListener(new ActionListener() {
				private boolean running_=false;
				public void actionPerformed(ActionEvent e) {					
					stop();
				}
			});
			controls.add(stop);
			final JButton step = new JButton(new ImageIcon("icons/stock_step.png"));
			step_=step;
			step.addActionListener(new ActionListener() {
				private boolean running_=false;
				public void actionPerformed(ActionEvent e) {
					
					step();
				}
			});
			controls.add(step);
			JLabel spacer = new JLabel("      ");
			controls.add(spacer);
			JLabel inputsrc = new JLabel("Transformation Input Source: Not Set");
			JButton setsrc = new JButton("[Change]");
			setsrc.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					// TODO Auto-generated method stub
					getInput();
				}
			});
			controls.add(inputsrc);
			controls.add(setsrc);
			setsrc.setFont(setsrc.getFont().deriveFont(Font.BOLD));
			inputSource_=inputsrc;
			contentPane_.add(controls,BorderLayout.NORTH);
			
			play_.setEnabled(true);
			stop_.setEnabled(false);
			step_.setEnabled(false);
			pause_.setEnabled(false);
			
			JPanel main = new JPanel();
			main.setLayout(new BorderLayout());
			contextNode_=new JLabel("Context Node:");
			main.add(contextNode_,BorderLayout.NORTH);
			JSplitPane viewPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
			main.add(viewPane,BorderLayout.CENTER);
			contentPane_.add(main,BorderLayout.CENTER);
			
			//xsl source
			JPanel spane = new JPanel();
			spane.setLayout(new BorderLayout());
			xslSource_=new XmlSourceEditor();
			spane.add(((XmlSourceEditor)xslSource_).getMarkerView(),BorderLayout.WEST);
			spane.add(xslSource_,BorderLayout.CENTER);
//			Style breakpointStyle=((DefaultStyledDocument)xslSource_.getDocument()).addStyle("Breakpoint",null);
//			StyleConstants.setBold(breakpointStyle,true);
//			StyleConstants.setBackground(breakpointStyle,Color.lightGray);
//			activeBreakpointStyle_=((DefaultStyledDocument)xslSource_.getDocument()).addStyle("ActiveBreakpoint",breakpointStyle);
//			StyleConstants.setBackground(activeBreakpointStyle_,new Color(224,148,148));
//			disabledBreakpointStyle_=((DefaultStyledDocument)xslSource_.getDocument()).addStyle("DisabledBreakpoint",breakpointStyle);
//			StyleConstants.setBackground(disabledBreakpointStyle_,Color.lightGray);
			//xslSource_.setEditable(false);
			JScrollPane cont = new JScrollPane(spane);
			cont.setSize(300,600);
			
			//xslSource_.setText(xsl_.toString());	
			((XmlSourceEditor)xslSource_).loadDocument(xsl_);
			
	/*		xslSource_.addMouseListener(new MouseListener() {
				private JPopupMenu menu_;
				public JPopupMenu getMenu(){
					
					if(menu_==null){
						menu_=new JPopupMenu("Breakpoint Control");
						menu_.add(addBreakpoint_);
						menu_.add(removeBreakpoint_);
						menu_.add(disableBreakpoint_);
					}
					addBreakpoint_.setEnabled(!addBreakpoint_.breakpointExists(xslSource_.getCaret().getDot()));
					
					removeBreakpoint_.setEnabled(addBreakpoint_.breakpointExists(xslSource_.getCaret().getDot()));
					disableBreakpoint_.setEnabled(addBreakpoint_.breakpointExists(xslSource_.getCaret().getDot()));
					return menu_;
				}
				public void mouseClicked(MouseEvent e) {
					// TODO Auto-generated method stub
				//	getMenu().setVisible(false);
				}

				public void mouseEntered(MouseEvent e) {
					// TODO Auto-generated method stub

				}

				public void mouseExited(MouseEvent e) {
					// TODO Auto-generated method stub

				}

				public void mousePressed(MouseEvent e) {
					// TODO Auto-generated method stub
					if(e.isPopupTrigger()){
						getMenu().setLocation(e.getX()+xslSource_.getLocationOnScreen().x,e.getY()+xslSource_.getLocationOnScreen().y);
						getMenu().setVisible(true);
					}
					else{
						getMenu().setVisible(false);
					}
				}

				public void mouseReleased(MouseEvent e) {
					// TODO Auto-generated method stub
					if(e.isPopupTrigger()){
						getMenu().setLocation(e.getX()+xslSource_.getLocationOnScreen().x,e.getY()+xslSource_.getLocationOnScreen().y);
						getMenu().setVisible(true);
					}
					else{
					//	getMenu().setVisible(false);
					}
				}
			});*/
			viewPane.setTopComponent(cont);
			
			JSplitPane statePane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
			viewPane.setBottomComponent(statePane);
			
			viewPane.setDividerLocation(300);
			
			
			
			MultiViewComponent left = new MultiViewComponent();
			MultiViewComponent left2 = new MultiViewComponent();
			MultiViewComponent right = new MultiViewComponent();
			JSplitPane leftsub = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,createCallStack(),createVariableStack());
			leftsub.setDividerLocation(230);
			leftsub.setBorder(new EmptyBorder(0,0,0,0));
			statePane.setBorder(new EmptyBorder(0,0,0,0));
			statePane.setLeftComponent(leftsub);
			statePane.setRightComponent(right);
			
			//left.addView("Call Stack",createCallStack());
			
			//left2.addView("Variable Stack",createVariableStack());
			Vector result = new Vector();
			result.add("Root");
			right.addView("Result Tree",createResultTree());
			right.addView("Result Source",createResutSource());
			statePane.setDividerLocation(460);
			/*
			//events
			cons.fill=cons.BOTH;
			cons.gridy+=cons.gridheight;
			cons.gridheight=1;
			events_=new JTextArea();
			f.getContentPane().add(new JScrollPane(events_),cons);
			
			
			
			
			
			
			
			//call stack
			cons.gridy++;
			callStack_=new JTextArea();
			f.getContentPane().add(new JScrollPane(callStack_),cons);
			cons.gridy++;
			
			//context node
			contextNode_=new JLabel("Context Node:");
			f.getContentPane().add(contextNode_,cons);
			cons.gridy++;
			
			//current elem
			currentElem_=new JLabel("Current Elem:");
			f.getContentPane().add(currentElem_,cons);
			*/
			
		}
	
		public boolean atBreakpoint(int line,int col){
			INode node = getNode(xsl_,line,col);
			if(node != null){
			IMarker[] breaks =node.getMarkersWithID(BreakpointMarker.ID);
			if(breaks!=null && breaks.length>0){
				return true;
			}
			}
//			Breakpoint p=(Breakpoint)breakpoints_.get(new Integer(line));
//			if(p!= null && p.enabled()){
//				return true;
//			}
		//	System.out.println("no breakpoint at "+line);
			return false;
		}
		
		public void addBreakpoint(int line){
			breakpoints_.put(new Integer(line),new Breakpoint(line));
			int start = getLineStart(xsl_,line);
			int end = getLineStart(xsl_,line+1);
			((DefaultStyledDocument)xslSource_.getDocument()).setCharacterAttributes(start,end-start,activeBreakpointStyle_,true);
		}
		public void removeBreakpoint(int line){
			breakpoints_.remove(new Integer(line));
			int start = getLineStart(xsl_,line);
			int end = getLineStart(xsl_,line+1);
			((DefaultStyledDocument)xslSource_.getDocument()).setCharacterAttributes(start,end-start,SimpleAttributeSet.EMPTY,true);
		}
		public void disableBreakpoint(int line){
			Breakpoint p = (Breakpoint)breakpoints_.get(new Integer(line));
			if(p!=null){
				p.setEnabed(false);
				int start = getLineStart(xsl_,line);
				int end = getLineStart(xsl_,line+1);
				((DefaultStyledDocument)xslSource_.getDocument()).setCharacterAttributes(start,end-start,disabledBreakpointStyle_,true);
			}
		}
		public void enableBreakpoint(int line){
			Breakpoint p = (Breakpoint)breakpoints_.get(new Integer(line));
			if(p!=null){
				p.setEnabed(true);
				int start = getLineStart(xsl_,line);
				int end = getLineStart(xsl_,line+1);
				((DefaultStyledDocument)xslSource_.getDocument()).setCharacterAttributes(start,end-start,activeBreakpointStyle_,true);
			}
		}
	
		public JPanel createCallStack(){
			JPanel container = new JPanel();
			container.setBorder(new EmptyBorder(0,0,0,0));
			container.setLayout(new GridBagLayout());
			GridBagConstraints cons = new GridBagConstraints();
			cons.gridx=1;
			cons.gridy = 0;
			cons.fill= GridBagConstraints.HORIZONTAL;
			
			DefaultTableModel tableModel = new DefaultTableModel(new String[]{"Call Stack"},0){
				public boolean isCellEditable(int row, int column){
					return false;
				}	
				public Class getColumnClass(int c){
					return String.class;
				}
				public String getColumnName(int col){
					
					return "Call Stack";
				}
			};
			JTable table = new JTable(tableModel);
			callStack_=table;
			table.setUI(new TableUI());
			table.setAutoCreateColumnsFromModel(true);
			
			table.getTableHeader().setBorder(new EmptyBorder(0,0,0,0));
			
			table.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
			table.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent e) {
					// TODO Auto-generated method stub
					int row = callStack_.getSelectedRow();
					if(row > -1 && row < stack_.size()){
					//ElemTemplate template = (ElemTemplate)stack_.elementAt(row);
					ElemTemplateElement el = (ElemTemplateElement)activeElementTable_.get(new Integer(stack_.size()-row-1));
					int start = getLineStart(xsl_,el.getLineNumber());
					int end = getLineStart(xsl_,el.getLineNumber()+1);
					xslSource_.setSelectionStart(start);
					xslSource_.setSelectionEnd(end);
					Vector vars = (Vector)stackFrames_.elementAt(stack_.size()-row-1);
					
					variables_=vars;
					updateVariables(transformer_);
					variables_=(Vector)stackFrames_.peek();
					}
				}
			});
			table.setBorder(new EmptyBorder(0,0,0,0));
//			cons.fill=cons.VERTICAL;
//			cons.gridheight=2;
//			cons.gridwidth=1;
//			cons.weighty=1;
//			cons.gridx=0;
//			//JPanel bling = new Arrow();
//			
//			container.add(bling,cons);
			cons.fill=cons.HORIZONTAL;
			cons.gridheight=1;
			cons.gridx=0;
			cons.gridy=0;
			container.add(table.getTableHeader(),cons);
			cons.gridy++;
			cons.fill=GridBagConstraints.BOTH;
			cons.weightx=1;
			cons.weighty=1;
			container.add(new JScrollPane(table),cons);
			
			
			return container;
		}
		
		public JComponent createResultTree(){
			DefaultMutableTreeNode root = new DefaultMutableTreeNode(new DocumentRoot());
			DefaultTreeModel model = new DefaultTreeModel(root);
			resultTree_ = new DocumentTree(model);
			TreeEditorLookup l = new TreeEditorLookup();
			l.registerTreeEditor(Object.class,new XmlTreeEditor());
			resultTree_.setTreeEditorLookup(l);
			return new JScrollPane(resultTree_);
		}
		
		public JDialog createErrorDialog(){
			JDialog d = new JDialog(new JFrame());
			d.setTitle("Error");
			
			return d;
		}
		
		public JComponent createVariableStack(){
			JPanel container = new JPanel();
			container.setLayout(new GridBagLayout());
			GridBagConstraints cons = new GridBagConstraints();
			cons.gridx=1;
			cons.gridy = 0;
			cons.fill= GridBagConstraints.HORIZONTAL;
			
			DefaultTableModel tableModel = new DefaultTableModel(new String[]{"Variable / Param","Value"},0){
				public boolean isCellEditable(int row, int column){
					return false;
				}	
				public Class getColumnClass(int c){
					return String.class;
				}
				public String getColumnName(int col){
					
					if(col==0){
						return "Variable / Param";
					}
					return "Value";
				}
			};
			JTable table = new JTable(tableModel);
			variableStack_=table;
			table.setUI(new TableUI());
			table.setAutoCreateColumnsFromModel(true);
			
			table.getTableHeader().setBorder(new EmptyBorder(0,0,0,0));
			
			table.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
			table.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent e) {
					// TODO Auto-generated method stub
					int row = variableStack_.getSelectedRow();
					if(row > -1 && row < stack_.size()){
						//ElemTemplate template = (ElemTemplate)stack_.elementAt(row);
						int frame= callStack_.getSelectedRow();
						frame = (frame > -1) ? frame : 0;
						Vector vars = (Vector)stackFrames_.elementAt(stack_.size()-frame-1);
						ElemVariable el = (ElemVariable)vars.elementAt(row);
						int start = getLineStart(xsl_,el.getLineNumber());
						int end = getLineStart(xsl_,el.getLineNumber()+1);
						System.out.println("select: ("+start+","+end+")");
						xslSource_.setSelectionStart(start);
						xslSource_.setSelectionEnd(end);
					
						
						
					}
				}
			});
//			cons.fill=cons.VERTICAL;
//			cons.gridheight=2;
//			cons.gridwidth=1;
//			cons.weighty=1;
//			cons.gridx=0;
//			//JPanel bling = new Arrow();
//			
//			container.add(bling,cons);
			cons.fill=cons.HORIZONTAL;
			cons.gridheight=1;
			cons.gridx=0;
			cons.gridy=0;
			container.add(table.getTableHeader(),cons);
			cons.gridy++;
			cons.fill=GridBagConstraints.BOTH;
			cons.weightx=1;
			cons.weighty=1;
			container.add(new JScrollPane(table),cons);
			
			
			return container;
		}
	
		public JComponent createResutSource(){
			resultSource_=new JEditorPane();
			return new JScrollPane(resultSource_);
		}
	
		public synchronized void step(){
			stepping_=true;
			notifyAll();
			play_.setEnabled(true);
			stop_.setEnabled(true);
			step_.setEnabled(true);
			pause_.setEnabled(true);
		}
		public void checkPause(int line,int col){
		//	System.out.println("Checking for pause at "+line);
			if(stepping_ || atBreakpoint(line,col)){
			//	System.out.println("pausing....");
				pauseExecution();
			}
		}
		
		public void pause(){
			stepping_=true;
			play_.setEnabled(true);
			stop_.setEnabled(true);
			step_.setEnabled(true);
			pause_.setEnabled(false);
		}
		public synchronized void play(){
			if(!running_){
				cleanup();
				startDebugger();
			}
			play_.setEnabled(false);
			stop_.setEnabled(true);
			step_.setEnabled(true);
			pause_.setEnabled(true);
			stepping_=false;
			running_=true;
			notifyAll();
		}
		public synchronized void stop(){
			if(running_){
			bail_=true;
			play_.setEnabled(true);
			stop_.setEnabled(false);
			step_.setEnabled(false);
			pause_.setEnabled(false);
			notifyAll();
			
			running_=false;
			//this is a horrible way to do this
			//but TransformerImpl.stopTransformation() is unimplemented
			//debugThread_.stop();
			if(transformer_!=null){
				transformer_.getTraceManager().removeTraceListener(this);
			}
			}
			
		}
		
		public void cleanup(){
			
			resultTree_.loadDocument(new XmlDocument("<result/>"));
			resultSource_.setText("");
			while(callStack_.getModel().getRowCount()>0){
				((DefaultTableModel)callStack_.getModel()).removeRow(0);
			}
			//xslSource_.setText(xsl_.toString());
			Iterator breaks = breakpoints_.values().iterator();
			while(breaks.hasNext()){
				Breakpoint b = (Breakpoint)breaks.next();
				Style style = null;
				int line = b.getLine();
				if(b.enabled()){
					style = activeBreakpointStyle_;
				}
				else{
					style = disabledBreakpointStyle_;
				}
				int start = getLineStart(xsl_,line);
				int end = getLineStart(xsl_,line+1);
				//((DefaultStyledDocument)xslSource_.getDocument()).setCharacterAttributes(start,end-start,style,true);
			}
			invocationStack_.clear();
			invocationTable_.clear();
			stackFrames_.clear();
			variables_.clear();
			updateVariables(null);
			stack_.clear();
		}
		
		public synchronized void pauseExecution(){
			stepping_=true;
			play_.setEnabled(true);
			stop_.setEnabled(true);
			step_.setEnabled(true);
			pause_.setEnabled(false);
			firePaused();
			try{
				wait();
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		
		private void startDebugger(){
			
			Runnable r = new Runnable(){
				
			public void run(){
			File file = null;
			if(xml_==null){
			
			file =getInput();
//			while(file==null){
//				IFileChooseAction choose = (IFileChooseAction)ButterflyApplication.getInstance().getAction(IFileChooseAction.ROLE);
//				choose.setApproveText("Debug");
//				choose.actionPerformed(null);
//				file = choose.getSelectedFile();
//			}
//			
//			IFileOpenAction open = (IFileOpenAction)ButterflyApplication.getInstance().getAction(IFileOpenAction.ROLE);
//			open.setFile(file);
//			open.setShowFile(false);
//			open.actionPerformed(null);
//			xml_=(XmlDocument)open.getDocument();
			}
			if(xml_==null){
				JOptionPane.showMessageDialog(null,"Transformation Failed: Unable to open: "+file.getName());
				stop();
				return;
			}
			XmlViewXsltTransformer transformer = new XmlViewXsltTransformer();
			
			try{
				transformer_=transformer.setup( xsl_);
				transformer.transform(new DocumentSource(xml_),XsltDebugger.this,new DocumentResult(new XmlDocument()));
			}catch(Exception e){
//				e.printStackTrace();
//				StringWriter sw = new StringWriter();
//				PrintWriter p = new PrintWriter(sw);
//				e.printStackTrace(p);
//				
//				JOptionPane.showMessageDialog(null,"Transformation Failed: "+sw.toString());
				handleException(e);
				stop();
			}
			play_.setEnabled(true);
			stop_.setEnabled(false);
			step_.setEnabled(false);
			pause_.setEnabled(false);
			running_=false;
			}
			};
			Thread t = new Thread(r);
			debugThread_=t;
			t.start();
		}
		
		private File getInput(){
			File file = null;
			
			while(file==null){
				IFileChooseAction choose = (IFileChooseAction)ButterflyApplication.getInstance().getAction(IFileChooseAction.ROLE);
				choose.setApproveText("Debug");
				choose.actionPerformed(null);
				file = choose.getSelectedFile();
			}
			IFileOpenAction open = (IFileOpenAction)ButterflyApplication.getInstance().getAction(IFileOpenAction.ROLE);
			open.setFile(file);
			open.setShowFile(false);
			open.actionPerformed(null);
			setInput((XmlDocument)open.getDocument());
			
			return file;
		}
		
		public void setInput(XmlDocument doc){
			if(running_){
				stop();
			}
			inputSource_.setText("Transformation Input Source: "+doc.getName());
			xml_=doc;
		}
			/* (non-Javadoc)
		 * @see org.apache.xalan.trace.TraceListener#generated(org.apache.xalan.trace.GenerateEvent)
		 */
		public void generated(GenerateEvent ev) {
			// TODO Auto-generated method stub
			if(ev.m_name!=null){
				//events_.setText("Generated Element:"+ev.m_name+"\n"+events_.getText());
			}
			else if(ev.m_characters!=null){
				//String src = new String(ev.m_characters,ev.m_start,ev.m_length);
				//events_.setText("Generated:"+src+"\n"+events_.getText());
			}
			if(stack_.size()>0){
			updateElem(ev.m_processor);
			updateContext(ev.m_processor);
			}
			fireGenerateEvent(ev);
			//pause();
			//updateXslLine(ev.);
			//pause();
		}

	/* (non-Javadoc)
	 * @see org.apache.xalan.trace.TraceListener#selected(org.apache.xalan.trace.SelectionEvent)
	 */
	public void selected(SelectionEvent ev) throws TransformerException {
		// TODO Auto-generated method stub
		//int index = getLineStart(xsl_,ev.m_styleNode.getLineNumber());
		//int end = getLineStart(xsl_,ev.m_styleNode.getLineNumber()+1);
		//String xslsrc = xsl_.toString().substring(index,end);
		//events_.setText("Selection from:"+xslsrc+"\n"+events_.getText());
		updateXslLine(ev.m_styleNode);
		//updateCallStack(ev.m_processor.getTemplateCallstack());
		//updateTemplateStack(ev);
		updateElem(ev.m_processor);
		updateContext(ev.m_processor);
		//if(ev.m_styleNode instanceof ElemVariable){
		//	events_.setText("Variable:"+((ElemVariable)ev.m_styleNode).getName()+"="+((ElemVariable)ev.m_styleNode).getValue(ev.m_processor,ev.m_processor.getCurrentNode())+"\n"+events_.getText());
		//}
		//fireSelectedEvent(ev);*/
		//pause();
	}
	
	public void updateContext(TransformerImpl trans){
		//contextNode_.setText("ContextNode:"+trans.getContextNodeList().)
		try{
		int node = trans.getMatchedNode();
		if(node >-1){
		//contextlist.
		//DTM context = contextlist.getDTM(node);
		contextNode_.setText("Context: "+toXPath(node,trans.getXPathContext()));
		}
		}catch(Exception e){}
		//context.getNode(node).getc
	}
	
	public String toXPath(int node, XPathContext xpcontext){
		
		String xpath = "";
		DTM dtm = xpcontext.getDTM(node);
		int curr = node;
		//System.out.println("getting xpath for node:"+curr);
		while(curr > 0){
			boolean isroot = !(dtm.getParent(curr)>-1);
			String pre= dtm.getPrefix(curr);
			String name = dtm.getLocalName(curr);
			String ns = dtm.getNamespaceURI(curr);
		
			int index =0;
			int sib = curr;
			while((sib=xpcontext.getDTM(sib).getPreviousSibling(sib))>0 && !isroot){
				String cns = xpcontext.getDTM(sib).getNamespaceURI(sib);
				if(xpcontext.getDTM(sib).getLocalName(sib).equals(name)){
					if(ns==cns){
						index++;
					}
					else if(ns != null && ns.equals(cns)){
						index++;
					}
				}
				//
			}
			String subpath="/";
			if(pre != null && pre.length()>0){
				subpath+=pre+":";
			}
			if(!isroot){
			subpath+=name;
			subpath+="["+index+"]";
			
			xpath=subpath+xpath;
			}
			//System.out.println("current hanlde:"+curr);
			curr = dtm.getParent(curr);
			//System.out.println("parent handle:"+curr);
		}
		if(xpath.equals("")){
			xpath="/";
		}
		return xpath;
	}
	
	
	public void updateElem(TransformerImpl trans){
		//currentElem_.setText("Current Elem:"+trans.getCurrentElement());
	}
	
	public int getLineStart(IDocument doc,int line){
		String src = doc.toString();
		int currline = 1;
		int index = 0;
		while(currline < line){
			index = src.indexOf("\n",index)+1;
			if(index < 0){
				break;
			}
			currline++;
		}
		if(currline != line){
			index = src.length();
		}
		return index;
	}
	public int getLine(IDocument doc,int pos){
		String src = doc.toString();
		int currline = 1;
		int index = 0;
		while(index < pos){
			index = src.indexOf("\n",index)+1;
			if(index < 0 || index > pos){
				break;
			}
			currline++;
		}
		
		return currline;
	}

	/* (non-Javadoc)
	 * @see org.apache.xalan.trace.TraceListener#trace(org.apache.xalan.trace.TracerEvent)
	 */
	public void trace(TracerEvent ev) {
		// TODO Auto-generated method stub
//		if(stack_.size()==0){
//			stack_.push(ev.m_processor.getCurrentTemplate());
//			invocationStack_.push(ev.m_styleNode);
//		}
		//System.out.println(">>Trace");
		if(bail_){
			ev.m_processor.stopTransformation();
			bail_=false;
			//System.out.println("Debugging stopped.");
		}
		else{
		if(ev.m_styleNode instanceof ElemTemplate){
			stack_.push(ev.m_styleNode);
			variables_=new Vector();
			stackFrames_.push(variables_);
			if(templateCaller_!=null){
				invocationStack_.push(templateCaller_);
				invocationTable_.put(templateCaller_,ev.m_styleNode);
				templateCaller_=null;
			}
		}
		if(ev.m_styleNode!=null){
			activeElementTable_.put(new Integer(stack_.size()-1),ev.m_styleNode);
		}
		if(ev.m_styleNode instanceof ElemApplyTemplates ||
		    ev.m_styleNode instanceof ElemCallTemplate){
			templateCaller_=ev.m_styleNode;
		}
		
	//	String src = "TracerEvent";
		//events_.setText("Selection from:"+src+"\n"+events_.getText());
		if(atBreakpoint(ev.m_styleNode.getLineNumber(),ev.m_styleNode.getColumnNumber())){
			stepping_=true;
		}
		
		updateXslLine(ev.m_styleNode);
		//updateCallStack(ev.m_processor.getTemplateCallstack());
		updateTemplateStack(ev);
		updateElem(ev.m_processor);
		updateContext(ev.m_processor);
		fireTraceEvent(ev);
		checkPause(ev.m_styleNode.getLineNumber(),ev.m_styleNode.getColumnNumber());
		}
		//System.out.println("<<Trace");
	}
	
	public void updateXslLine(ElemTemplateElement el){
		if(el != null && stepping_){
		int line = el.getLineNumber();
		int index = getLineStart(xsl_,line);
		int end = getLineStart(xsl_,line+1);
		xslSource_.requestFocus();
		
		xslSource_.select(index,end);
	
	
		}
	}
	
	
	public void updateVariables(TransformerImpl trans){
		DefaultTableModel model = (DefaultTableModel)variableStack_.getModel();
		while(model.getRowCount()>0){
			model.removeRow(0);
		}
		for(int i = 0; i < variables_.size();i++){
			ElemVariable var = (ElemVariable)variables_.elementAt(i);
			String first = var.getName().toString();
			String value = "[Unavailable]";
			try{
				value=""+trans.getXPathContext().getVarStack().getLocalVariable(trans.getXPathContext(),var.getIndex());
			}catch(Exception e){
				
				e.printStackTrace();
			}
			model.addRow(new String[]{first,value});
		}
		
	}
	
	public void variableInScope(ElemVariable var){
		
		variables_.add(var);
	}
	public void variableOutOfScope(ElemVariable var){
		//variables_.remove(var);
	}
	
//	public boolean isGlobalVariable(ElemVariable var,TransformerImpl trans){
//		StylesheetRoot sroot = trans.getStylesheet();
//		Vector vars = sroot.getVariablesAndParamsComposed();
//		int i = vars.size();
//		while (--i >= 0)
//		{
//			ElemVariable variable = (ElemVariable)vars.elementAt(i);
//			if(variable.getXSLToken() == Constants.ELEMNAME_PARAMVARIABLE &&
//					variable.getName().equals(var.getName()))
//			{
//				return true;
//			}
//		}
//		return false;
//	}
	
	
	public INode getNode(XmlDocument doc,int line, int col){
		int start = getLineStart(doc,line);
		int index = start+col-1;
		//System.out.println("src->"+doc.toString().substring(index, getLineStart(doc,line+1))+"<--");
		INode node = doc.nodeAt(index);
		if(node == null){
			node = doc.nodeAt(index,2,2);
		}
		if(node instanceof XmlDocument.EndTagPlaceHolder){
			node = ((XmlDocument.EndTagPlaceHolder)node).getElement();
		}
		return node;
	}
	
//	public void updateCallStack(Vector v){
//		DefaultTreeModel model = (DefaultTreeModel)callStack_.getModel();
//		DefaultMutableTreeNode curr = (DefaultMutableTreeNode)callStack_.getModel().getRoot();
//		while(curr.getChildCount()>0){
//			model.removeNodeFromParent((MutableTreeNode)curr.getChildAt(0));
//		}
//		
//		for(int i = 0; i < v.size(); i++){
//			
//			DefaultMutableTreeNode next = new DefaultMutableTreeNode("template match="+v.elementAt(i));
//			model.insertNodeInto(next,curr,curr.getChildCount()); //((ElemTemplate)v.elementAt(i)).getMatch().toString()+" name="+((ElemTemplate)v.elementAt(i)).getMatch().toString()+"\n";
//			curr = next;
//			callStack_.expandRow(i+1);
//		}
//		//callStack_.setText(stk);
//	}
	public void updateTemplateStack(TracerEvent ev){
		//System.out.println("Stack#################");
		DefaultTableModel model = (DefaultTableModel)callStack_.getModel();
		while(model.getRowCount()>0){
			model.removeRow(0);
		}
		for(int i = stack_.size()-1; i >=0; i--){
			//Object key = invocationStack_.elementAt(i);
			ElemTemplate template = (ElemTemplate)stack_.elementAt(i);
			if(template != null){
			if(template.getMatch()!=null){
		//	System.out.println(template.getMatch().getPatternString());
			model.addRow(new String[]{"template match=\""+template.getMatch().getPatternString()+"\""});
			}
			else{
				model.addRow(new String[]{"template name=\""+template.getName().getLocalName()+"\""});
			}
			}
		}
		/*
		System.out.println("####################");
		ObjectStack v = ev.m_processor.getCurrentTemplateElements();
		
		Vector tv = ev.m_processor.getTemplateCallstack();
		for(int i = 0; i < tv.size();i++){
			System.out.println(tv.elementAt(i));
		}
		
		DefaultTableModel model = (DefaultTableModel)callStack_.getModel();
		while(model.getRowCount()>0){
			model.removeRow(0);
		}
	
		for(int i = 0; i < v.size(); i++){
			Object obj=v.elementAt(i);
			if(obj instanceof ElemCallTemplate){
				ElemCallTemplate apply = (ElemCallTemplate)obj;
				INode node = getNode(xsl_,apply.getLineNumber(),apply.getColumnNumber());
				String xpath="";
				System.out.println(node);
				if(node instanceof IElement){
					IAttribute attr = ((IElement)node).getAttribute("select");
					if(attr != null){
						xpath=attr.getData();
					}
				}
				String start = (apply instanceof ElemApplyTemplates) ? "apply-templates" : "call-template";
				String stk = "<apply-templates ";
				if(apply.getName()!=null){
					stk+="name=\""+apply.getName()+"\"";
				}
				else{
					stk+= "select=\""+xpath+"\"";
				}
				stk+=">";
				model.addRow(new String[]{stk,""+apply.getLineNumber()});
			}
		}
		*/
		//callStack_.setText(stk);
	}
	/* (non-Javadoc)
	 * @see butterfly.xmlview.model.transformation.interfaces.IPipelineListener#startingTransformation(javax.xml.transform.Source, java.util.Properties)
	 */
	public void startingTransformation(Source src, Properties props,Result r) {
		// TODO Auto-generated method stub
		if(r instanceof DocumentResult ){
			if(((DocumentResult)r).getDocument()!=null){
				resultTree_.loadDocument(((DocumentResult)r).getDocument());
				((DocumentResult)r).getDocument().addDocumentListener(this);
			}
		}

	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.model.transformation.interfaces.IPipelineListener#transformationFinished(javax.xml.transform.Source, java.util.Properties, javax.xml.transform.Result)
	 */
	public void transformationFinished(
		Source src,
		Properties props,
		Result r) {
		if(src instanceof DocumentSource){
			xml_=(XmlDocument)((DocumentSource)src).getDocument();
		}
		if(r instanceof DocumentResult){
			((DocumentResult)r).getDocument().removeDocumentListener(this);
		}
		//nodeLookup_.clear();
		//invocationStack_.clear();
		//stack_.clear();
		//activeElementTable_.clear();
		//xsl_=null;
		//xml_=null;
		play_.setEnabled(true);
		stop_.setEnabled(false);
		step_.setEnabled(false);
		pause_.setEnabled(false);
		running_=false;
		// TODO Auto-generated method stub

	}
	
	public static void main(String[] args){
		XsltDebugger d = new XsltDebugger();
		d.debug(new XmlDocument("<xml/>"),new XmlDocument("<xsl/>"));
		//d.createGui();
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.model.interfaces.IDocumentListener#handleDocumentEvent(butterfly.xmlview.model.interfaces.IDocumentEvent)
	 */
	public void handleDocumentEvent(IDocumentEvent evt) {
		// TODO Auto-generated method stub
		System.out.println("document event");
		if(evt.getType()==IDocumentEvent.NODES_ADDED){
			
			resultSource_.setText(evt.getDocument().toString());
			
		}
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#addNodeSelectionListener(butterfly.xmlview.gui.interfaces.INodeSelectionListener)
	 */
	public void addNodeSelectionListener(INodeSelectionListener l) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getSelectedTag()
	 */
	public String getSelectedTag() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getSelectedTagXPath()
	 */
	public String getSelectedTagXPath() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#getXmlModel()
	 */
	public IXmlDocument getXmlModel() {
		// TODO Auto-generated method stub
		return xsl_;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#removeNodeSelectionListener(butterfly.xmlview.gui.interfaces.INodeSelectionListener)
	 */
	public void removeNodeSelectionListener(INodeSelectionListener l) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#renderXmlDocument(butterfly.xmlview.model.interfaces.IXmlDocument)
	 */
	public JComponent renderXmlDocument(IXmlDocument doc) {
		// TODO Auto-generated method stub
		xsl_=(XmlDocument)doc;
		if(contentPane_==null){
			createContentPane();
		}
		//contentPane_.setBackground(Color.black);
		
		return contentPane_;
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#setSelectionEnd(int)
	 */
	public void setSelectionEnd(int start) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IXmlRenderer#setSelectionStart(int)
	 */
	public void setSelectionStart(int start) {
		// TODO Auto-generated method stub
		xslSource_.setSelectionStart(start);
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#focusOnNode(butterfly.xmlview.model.interfaces.INode)
	 */
	public void focusOnNode(INode node) {
		// TODO Auto-generated method stub
		((XmlSourceEditor)xslSource_).focusOnNode(node);
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getIDocument()
	 */
	public IDocument getIDocument() {
		// TODO Auto-generated method stub
		return getXmlModel();
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#getSelectedNodes()
	 */
	public INode[] getSelectedNodes() {
		// TODO Auto-generated method stub
		return ((XmlSourceEditor)xslSource_).getSelectedNodes();
	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#loadDocument(butterfly.xmlview.model.interfaces.IDocument)
	 */
	public void loadDocument(IDocument doc) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see butterfly.xmlview.gui.interfaces.IDocumentEditor#setSelection(int, int)
	 */
	public void setSelection(int start, int length) {
		// TODO Auto-generated method stub
		((XmlSourceEditor)xslSource_).setSelection(start,length);
	}
	
	public void handleException(Exception e){
		int line =-1;
		int col = -1;
		e.printStackTrace();
		String msg = "Error:";
		if(e instanceof SAXException){
			SAXException se = (SAXException)e;
			msg=se.getMessage();
		}
		else if(e instanceof TransformerException){
			TransformerException te = (TransformerException)e;
			SourceLocator sl = te.getLocator();
			if(sl!=null){
			
				line = sl.getLineNumber();
				col = sl.getColumnNumber();
			}
			msg = te.getMessage();
		}else{
			msg = e.getMessage();
		}
		
			IXmlViewInformer informer = (IXmlViewInformer)ButterflyApplication.getInstance().getComponent(IXmlViewInformer.ROLE);
			informer.displayError(msg);
			
		if(line > -1){			
			GoToLineAction gotoline= (GoToLineAction)ButterflyApplication.getInstance().getAction("butterfly.actions.GoToLineAction");
			gotoline.setLine(line);
			gotoline.setColumn(col);
			gotoline.actionPerformed(null);			
		}
		
			
		
	}

}

