/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*        Metouia Look And Feel: a free pluggable look and feel for java        *
*                         http://mlf.sourceforge.net                           *
*          (C) Copyright 2002, by Taoufik Romdhane and Contributors.           *
*                                                                              *
*   This library is free software; you can redistribute it and/or modify it    *
*   under the terms of the GNU Lesser General Public License as published by   *
*   the Free Software Foundation; either version 2.1 of the License, or (at    *
*   your option) any later version.                                            *
*                                                                              *
*   This library is distributed in the hope that it will be useful,            *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                       *
*   See the GNU Lesser General Public License for more details.                *
*                                                                              *
*   You should have received a copy of the GNU General Public License along    *
*   with this program; if not, write to the Free Software Foundation, Inc.,    *
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.                    *
*                                                                              *
*  MetouiaTabbedPaneUI.java                                                    *
*   Original Author:  Taoufik Romdhane                                         *
*   Contributor(s):                                                            *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

import butterfly.xmlview.gui.ClosableTabbedPane;

/**
 * This class represents the UI delegate for the JTabbedPane component.
 *
 * @author Taoufik Romdhane
 */
public class MetouiaTabbedPaneUI extends BasicTabbedPaneUI
{
protected int tabWithMouse_ = -1;
protected Rectangle closeButtonBounds_ = new Rectangle(0,0,20,20);
protected Icon closeButtonIcon_ = UIManager.getIcon("InternalFrame.closeIcon");//new ImageIcon("icons/stock_close-16.png");
  
private static ImageIcon tabLeft_= new ImageIcon("icons/tab_area_left.gif");
private static ImageIcon tabRight_=new ImageIcon("icons/tab_area_right.gif");
private class ScrollableTabPanel extends JPanel implements UIResource {
	public ScrollableTabPanel() {
		setLayout(null);
	}
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		MetouiaTabbedPaneUI.this.paintTabArea(g, tabPane.getTabPlacement(),
				tabPane.getSelectedIndex());
		
	}
}

private class ScrollableTabButton extends BasicArrowButton implements UIResource, 
SwingConstants {
	public ScrollableTabButton(int direction) {
		super(direction,
			UIManager.getColor("TabbedPane.selected"),
			UIManager.getColor("TabbedPane.shadow"),
			UIManager.getColor("TabbedPane.darkShadow"),
			UIManager.getColor("TabbedPane.highlight"));
	}
	public boolean scrollsForward() {
		return direction == EAST || direction == SOUTH;
	}
} 

private class ScrollableTabViewport extends JViewport implements UIResource {
	public ScrollableTabViewport() {
		super();
		setScrollMode(SIMPLE_SCROLL_MODE);
	}
}


private class ScrollableTabSupport implements ChangeListener {
	public ScrollableTabViewport viewport;
	public ScrollableTabPanel tabPanel;
	public ScrollableTabButton scrollForwardButton;
	public ScrollableTabButton scrollBackwardButton;
	public int leadingTabIndex;

	private Point tabViewPosition = new Point(0,0);

	ScrollableTabSupport(int tabPlacement) {
		viewport = new ScrollableTabViewport();  
		tabPanel = new ScrollableTabPanel();
		viewport.setView(tabPanel);
		viewport.addChangeListener(this);

		if (tabPlacement == TOP || tabPlacement == BOTTOM) {
			scrollForwardButton = new ScrollableTabButton(EAST);
			scrollBackwardButton = new ScrollableTabButton(WEST);

		} else { // tabPlacement = LEFT || RIGHT
			scrollForwardButton = new ScrollableTabButton(SOUTH);
			scrollBackwardButton = new ScrollableTabButton(NORTH);
		}
	}

	public void scrollForward(int tabPlacement) {
		Dimension viewSize = viewport.getViewSize();
		Rectangle viewRect = viewport.getViewRect();

		if (tabPlacement == TOP || tabPlacement == BOTTOM) {
			if (viewRect.width >= viewSize.width - viewRect.x) {
				return; // no room left to scroll
			}
		} else { // tabPlacement == LEFT || tabPlacement == RIGHT
			if (viewRect.height >= viewSize.height - viewRect.y) {
				return;
			}
		}
		setLeadingTabIndex(tabPlacement, leadingTabIndex+1);
	}

	public void scrollBackward(int tabPlacement) {
		if (leadingTabIndex == 0) {
			return; // no room left to scroll
		}
		setLeadingTabIndex(tabPlacement, leadingTabIndex-1);
	}

	public void setLeadingTabIndex(int tabPlacement, int index) {
		leadingTabIndex = index;	   
		Dimension viewSize = viewport.getViewSize();
		Rectangle viewRect = viewport.getViewRect();

		switch(tabPlacement) {
			case TOP:
			case BOTTOM:
				tabViewPosition.x = leadingTabIndex == 0? 0 : rects[leadingTabIndex].x;

				if ((viewSize.width - tabViewPosition.x) < viewRect.width) {
					// We've scrolled to the end, so adjust the viewport size
					// to ensure the view position remains aligned on a tab boundary
					Dimension extentSize = new Dimension(viewSize.width - tabViewPosition.x, 
							viewRect.height);
					viewport.setExtentSize(extentSize);
				}
				break;
			case LEFT:
			case RIGHT:
				tabViewPosition.y = leadingTabIndex == 0? 0 : rects[leadingTabIndex].y;

				if ((viewSize.height - tabViewPosition.y) < viewRect.height) {
					// We've scrolled to the end, so adjust the viewport size
					// to ensure the view position remains aligned on a tab boundary
					Dimension extentSize = new Dimension(viewRect.width, 
							viewSize.height - tabViewPosition.y);
					viewport.setExtentSize(extentSize);
				}
		}
		viewport.setViewPosition(tabViewPosition);
	}

	public void stateChanged(ChangeEvent e) {
		JViewport viewport = (JViewport)e.getSource();
		int tabPlacement = tabPane.getTabPlacement();
		int tabCount = tabPane.getTabCount();
		Rectangle vpRect = viewport.getBounds();
		Dimension viewSize = viewport.getViewSize();
		Rectangle viewRect = viewport.getViewRect();

		leadingTabIndex = getClosestTab(viewRect.x, viewRect.y);

		// If the tab isn't right aligned, adjust it.
		if (leadingTabIndex + 1 < tabCount) {
			switch (tabPlacement) {
				case TOP:
				case BOTTOM:
					if (rects[leadingTabIndex].x < viewRect.x) {
						leadingTabIndex++;
					}
					break;
				case LEFT:
				case RIGHT:
					if (rects[leadingTabIndex].y < viewRect.y) {
						leadingTabIndex++;
					}
					break;
			}
		}
		Insets contentInsets = getContentBorderInsets(tabPlacement);
		switch(tabPlacement) {
			case LEFT:
				tabPane.repaint(vpRect.x+vpRect.width, vpRect.y,
						contentInsets.left, vpRect.height);
				scrollBackwardButton.setEnabled(viewRect.y > 0);
				scrollForwardButton.setEnabled(leadingTabIndex < tabCount-1 &&
						viewSize.height-viewRect.y > viewRect.height);
				break;
			case RIGHT:
				tabPane.repaint(vpRect.x-contentInsets.right, vpRect.y,
						contentInsets.right, vpRect.height);
				scrollBackwardButton.setEnabled(viewRect.y > 0);
				scrollForwardButton.setEnabled(leadingTabIndex < tabCount-1 &&
						viewSize.height-viewRect.y > viewRect.height);
				break;
			case BOTTOM:
				tabPane.repaint(vpRect.x, vpRect.y-contentInsets.bottom,
						vpRect.width, contentInsets.bottom);
				scrollBackwardButton.setEnabled(viewRect.x > 0);
				scrollForwardButton.setEnabled(leadingTabIndex < tabCount-1 &&
						viewSize.width-viewRect.x > viewRect.width);
				break;
			case TOP:
			default:
				tabPane.repaint(vpRect.x, vpRect.y+vpRect.height,
						vpRect.width, contentInsets.top);
				scrollBackwardButton.setEnabled(viewRect.x > 0);
				scrollForwardButton.setEnabled(leadingTabIndex < tabCount-1 &&
						viewSize.width-viewRect.x > viewRect.width);
		}
	}

	public String toString() {
		return new String("viewport.viewSize="+viewport.getViewSize()+"\n"+
				"viewport.viewRectangle="+viewport.getViewRect()+"\n"+
				"leadingTabIndex="+leadingTabIndex+"\n"+
				"tabViewPosition="+tabViewPosition);
	}

}

  /**
   * The outer highlight color of the border.
   */
//  private Color outerHighlight = MetouiaLookAndFeel.getControlDisabled();
//
//  /**
//   * The inner highlight color of the border.
//   */
//  private Color innerHighlight = MetouiaLookAndFeel.getPrimaryControlHighlight();
//
//  /**
//   * The outer shadow color of the border.
//   */
//  private Color outerShadow = MetouiaLookAndFeel.getControlDarkShadow();
//
//  /**
//   * The inner shadow color of the border.
//   */
//  private Color innerShadow = MetouiaLookAndFeel.getDesktopColor();

  /**
   * Creates the UI delegate for the given component.
   *
   * @param c The component to create its UI delegate.
   * @return The UI delegate for the given component.
   */
  public static ComponentUI createUI(JComponent c)
  {
    return new MetouiaTabbedPaneUI();
  }

  /**
   * Paints the backround of a given tab.
   *
   * @param g The graphics context.
   * @param tabPlacement The placement of the tab to paint.
   * @param tabIndex The index of the tab to paint.
   * @param x The x coordinate of the top left corner.
   * @param y The y coordinate of the top left corner.
   * @param w The width.
   * @param h The height.
   * @param isSelected True if the tab to paint is selected otherwise false.
   */
  protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex,
    int x, int y, int w, int h, boolean isSelected)
  {
    if (isSelected)
    {
    g.setColor(UIManager.getColor("TabbedPane.selected"));
    }
    else
    {
      g.setColor(UIManager.getColor("TabbedPane.unselected"));
      //g.setColor(tabPane.getBackgroundAt(tabIndex));
    }
    if(tabIndex>0){
    switch (tabPlacement)
    {
      case LEFT:
        g.fillRect(x + 1, y + 1, w - 2, h - 3);
        break;
      case RIGHT:
        g.fillRect(x, y + 1, w - 2, h - 3);
        break;
      case BOTTOM:
        g.fillRect(x + 1, y, w - 3, h - 1);
        break;
      case TOP:
      	g.fillRect(x + 1, y + 1, w - 3, h - 1);
      	break;
      default:
        g.fillRect(x + 1, y + 1, w - 3, h - 1);
    }
    }
    else{
    	g.fillRoundRect(x + 1, y + 1, 5,5,2,2);
    	g.fillRect(x + 1, y + 3, 5, h - 1);
    	g.fillRect(x + 3, y + 1, w - 5, h - 1);
    }
  }

  /**
   * Paints the border of a given tab.
   *
   * @param g The graphics context.
   * @param tabPlacement The placement of the tab to paint.
   * @param selectedIndex The index of the selected tab.
   */
  protected void paintContentBorder2(Graphics g, int tabPlacement,
    int selectedIndex)
  {
    int width = tabPane.getWidth();
    int height = tabPane.getHeight();
    Insets insets = tabPane.getInsets();

    int x = insets.left;
    int y = insets.top;
    int w = width - insets.right - insets.left;
    int h = height - insets.top - insets.bottom;

    switch (tabPlacement)
    {
      case LEFT:
        x += calculateTabAreaWidth(tabPlacement, runCount, maxTabWidth);
        w -= (x - insets.left);
        break;
      case RIGHT:
        w -= calculateTabAreaWidth(tabPlacement, runCount, maxTabWidth);
        break;
      case BOTTOM:
        h -= calculateTabAreaHeight(tabPlacement, runCount, maxTabHeight);
        break;
      case TOP:
      default:
        y += calculateTabAreaHeight(tabPlacement, runCount, maxTabHeight);
        h -= (y - insets.top);
    }
    paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);

  }
  
//    public class MouseMotionHandler extends MouseMotionAdapter{
//    	public void mouseMoved(MouseEvent e) {
//    		// TODO Auto-generated method stub
//    		int tabIndex = getTabAtLocation(e.getX(), e.getY());
//    		if(tabIndex>=0){
//    			tabPane.requestFocus();
//    			if(tabWithMouse_>=0){
//    				tabPane.repaint(rects[tabWithMouse_]);
//    			}
//    			tabWithMouse_=tabIndex;
//    			tabPane.repaint(rects[tabIndex]);
//    		}
//    		super.mouseMoved(e);
//    	}
//    }

  	public class MouseHandler extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
        	
            if (!tabPane.isEnabled()) {
                return;
            }
            if(tabPane instanceof ClosableTabbedPane){
            	
            	int x = e.getX();
            	int y = e.getY();
            	int cwidth = 30;
            	int tabCount = rects.length;
            	for (int i = 0; i < tabCount; i++) {
            		if (rects[i].contains(x, y) && rects[i].x+rects[i].width-x<=cwidth && rects[i].x+rects[i].width-x>5) {
            			((ClosableTabbedPane)tabPane).sendCloseRequestEvent(i);
            			return;
            		}
            	}
            }
       
            int tabIndex = getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == tabPane.getSelectedIndex()) {
                    if (tabPane.isRequestFocusEnabled()) {
                        tabPane.requestFocus();
                        tabPane.repaint(rects[tabIndex]);
                    }
                } else {
                    tabPane.setSelectedIndex(tabIndex);
                }
            }
        }
		/* (non-Javadoc)
		 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
		 */
	

    }
  
  	 private int getTabAtLocation(int x, int y) {
	    //ensureCurrentLayout();

        int tabCount = tabPane.getTabCount();
        for (int i = 0; i < tabCount; i++) {
            if (rects[i].contains(x, y)) {
                return i;
            }
        }
        return -1;
    }
  
  
	/**
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#createMouseListener()
	 */
	protected MouseListener createMouseListener() {
		return new MouseHandler();//super.createMouseListener();
	}

	/**
	 * 
	 */
	
	
	protected void paintCloseButton(Graphics g, int tabPlacement, int tabIndex,
    int x, int y, int w, int h){
		//g.translate(x,y);
		//g.setColor(Color.RED);
		//g.fillRect(x+w-closeButtonBounds_.width,0,closeButtonBounds_.width,closeButtonBounds_.height);
		closeButtonIcon_.paintIcon(tabPane,g,x+w-closeButtonBounds_.width-10,1);
	}

	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#paintTab(java.awt.Graphics, int, java.awt.Rectangle[], int, java.awt.Rectangle, java.awt.Rectangle)
	 */
	protected void paintTab(
		Graphics g,
		int tabPlacement,
		Rectangle[] rects,
		int tabIndex,
		Rectangle iconRect,
		Rectangle textRect) {
		// TODO Auto-generated method stub
		//super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
		 String title = tabPane.getTitleAt(tabIndex);
		 Rectangle tabRect = rects[tabIndex];
		 boolean isSelected = tabIndex==tabPane.getSelectedIndex();
	     Font font = tabPane.getFont();
	     FontMetrics metrics = g.getFontMetrics(font);
	     Icon icon = getIconForTab(tabIndex);
	     if(isSelected){
	     g.setColor(Color.white);
	     g.fillRect(tabRect.x+20,tabRect.y,tabRect.width-40,tabRect.height);
	     g.drawImage(tabLeft_.getImage(),tabRect.x,tabRect.y,tabPane);
	     g.drawImage(tabRight_.getImage(),tabRect.x+tabRect.width-20,tabRect.y,tabPane);
	     g.setColor(Color.darkGray);
	     g.drawLine(tabRect.x+20,tabRect.y,tabRect.x+tabRect.width-20,tabRect.y);
	     }
	     layoutLabel(tabPlacement, metrics, tabIndex, title, icon, 
	                    tabRect, iconRect, textRect, isSelected);
	     if(isSelected){
	     	textRect.x+=20;
	     }
	     paintText(g, tabPlacement, font, metrics, 
	                  tabIndex, title, textRect, isSelected);

	     paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);

	     paintFocusIndicator(g, tabPlacement, rects, tabIndex, 
	                  iconRect, textRect, isSelected);
		//if(tabPane.getSelectedIndex()==tabIndex){
		 paintCloseButton(g,tabPlacement,tabIndex,rects[tabIndex].x,rects[tabIndex].y,rects[tabIndex].width,rects[tabIndex].height);
		 if(tabIndex != tabPane.getTabCount()-1){
		 g.setColor(new Color(135,135,135));
		 g.drawLine(tabRect.x+tabRect.width-1,tabRect.y,tabRect.x+tabRect.width-1,2+tabRect.y);
		 g.drawLine(tabRect.x+tabRect.width-1,tabRect.y+5,tabRect.x+tabRect.width-1,7+tabRect.y);
		 g.drawLine(tabRect.x+tabRect.width-1,tabRect.y+10,tabRect.x+tabRect.width-1,12+tabRect.y);
		 g.drawLine(tabRect.x+tabRect.width-1,tabRect.y+14,tabRect.x+tabRect.width-1,16+tabRect.y);
		 }
	}



	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#calculateTabWidth(int, int, java.awt.FontMetrics)
	 */
	protected int calculateTabWidth(
		int tabPlacement,
		int tabIndex,
		FontMetrics metrics) {
		// TODO Auto-generated method stub
		return super.calculateTabWidth(tabPlacement, tabIndex, metrics)+closeButtonBounds_.width;
	}
	
	

	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#layoutLabel(int, java.awt.FontMetrics, int, java.lang.String, javax.swing.Icon, java.awt.Rectangle, java.awt.Rectangle, java.awt.Rectangle, boolean)
	 */
	protected void layoutLabel(
		int tabPlacement,
		FontMetrics metrics,
		int tabIndex,
		String title,
		Icon icon,
		Rectangle tabRect,
		Rectangle iconRect,
		Rectangle textRect,
		boolean isSelected) {
		// TODO Auto-generated method stub
		textRect.x = textRect.y = iconRect.x = iconRect.y = 0;

		View v = getTextViewForTab(tabIndex);
		if (v != null) {
			tabPane.putClientProperty("html", v);
		}

		SwingUtilities.layoutCompoundLabel((JComponent) tabPane,
				metrics, title, icon,
				SwingUtilities.CENTER,
				SwingUtilities.LEFT,
				SwingUtilities.CENTER,
				SwingUtilities.TRAILING,
				tabRect,
				iconRect,
				textRect,
				textIconGap);

		tabPane.putClientProperty("html", null);

		int xNudge = getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
		int yNudge = getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
		iconRect.x += xNudge;
		iconRect.y += yNudge;
		textRect.x += xNudge+3;
		textRect.y += yNudge;
	}
	private int getClosestTab(int x, int y) {
		int min = 0;
		int tabCount = Math.min(rects.length, tabPane.getTabCount());
		int max = tabCount;
		int tabPlacement = tabPane.getTabPlacement();
		boolean useX = (tabPlacement == TOP || tabPlacement == BOTTOM);
		int want = (useX) ? x : y;

		while (min != max) {
			int current = (max + min) / 2;
			int minLoc;
			int maxLoc;

			if (useX) {
				minLoc = rects[current].x;
				maxLoc = minLoc + rects[current].width;
			}
			else {
				minLoc = rects[current].y;
				maxLoc = minLoc + rects[current].height;
			}
			if (want < minLoc) {
				max = current;
				if (min == max) {
					return Math.max(0, current - 1);
				}
			}
			else if (want >= maxLoc) {
				min = current;
				if (max - min <= 1) {
					return Math.max(current + 1, tabCount - 1);
				}
			}
			else {
				return current;
			}
		}
		return min;
	}

	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTabbedPaneUI#getTabInsets(int, int)
	 */
	protected Insets getTabInsets(int tabPlacement, int tabIndex) {
		// TODO Auto-generated method stub
		Insets ins= super.getTabInsets(tabPlacement, tabIndex);
		if(tabIndex==tabPane.getSelectedIndex()){
			ins.left=20;
			ins.right=20;
		}
		return ins;
	}
}