/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*        Metouia Look And Feel: a free pluggable look and feel for java        *
*                         http://mlf.sourceforge.net                           *
*          (C) Copyright 2002, by Taoufik Romdhane and Contributors.           *
*                                                                              *
*   This library is free software; you can redistribute it and/or modify it    *
*   under the terms of the GNU Lesser General Public License as published by   *
*   the Free Software Foundation; either version 2.1 of the License, or (at    *
*   your option) any later version.                                            *
*                                                                              *
*   This library is distributed in the hope that it will be useful,            *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                       *
*   See the GNU Lesser General Public License for more details.                *
*                                                                              *
*   You should have received a copy of the GNU General Public License along    *
*   with this program; if not, write to the Free Software Foundation, Inc.,    *
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.                    *
*                                                                              *
*  MetouiaTreeUI.java                                                          *
*   Original Author:  Taoufik Romdhane                                         *
*   Contributor(s):                                                            *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package net.sourceforge.mlf.metouia;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import butterfly.xmlview.gui.tree.interfaces.IInteractiveTreeCellRenderer;

import sun.rmi.runtime.GetThreadPoolAction;

/**
 * This class represents the UI delegate for the JTree component.
 *
 * @author Taoufik Romdhane
 */
public class MetouiaTreeUI extends BasicTreeUI
{

 public class DelegatingMouseHandler extends MouseHandler{
 	
 	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e) {
		// TODO Auto-generated method stub
		super.mouseDragged(e);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e) {
		// TODO Auto-generated method stub
		super.mouseMoved(e);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {
		if(getCellRenderer() instanceof IInteractiveTreeCellRenderer){
		TreePath path = getClosestPathForLocation(tree, e.getX(),e.getY());

		Rectangle bounds=null;
		if(path != null) {
			bounds = getPathBounds(tree, path);
		}
		if(e.getY() <= (bounds.y + bounds.height)) {
			
		int boxWidth=0;
		if(getExpandedIcon() != null)
			boxWidth = getExpandedIcon().getIconWidth();
		else
			boxWidth = 8;
		if(e.getX() >= (bounds.x+boxWidth)){
				
		
		MouseEvent me = new MouseEvent((Component)e.getSource(),e.getID(),e.getWhen(),e.getModifiers(),e.getX()-(bounds.x),e.getY()-bounds.y,e.getClickCount(),e.isPopupTrigger(),e.getButton());
		TreeNode node = (TreeNode)path.getLastPathComponent();
		((IInteractiveTreeCellRenderer)getCellRenderer()).mousePressed(tree,node,me,tree.getLocationOnScreen().x+bounds.x,tree.getLocationOnScreen().y+bounds.y);
		}
		}
		}
		super.mousePressed(e);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {
		if(getCellRenderer() instanceof IInteractiveTreeCellRenderer){
			TreePath path = getClosestPathForLocation(tree, e.getX(),e.getY());

			Rectangle bounds=null;
			if(path != null) {
				bounds = getPathBounds(tree, path);
			}
			if(e.getY() <= (bounds.y + bounds.height)) {
				
				int boxWidth=0;
				if(getExpandedIcon() != null)
					boxWidth = getExpandedIcon().getIconWidth();
				else
					boxWidth = 8;
				if(e.getX() >= (bounds.x+boxWidth)){
					
					
					MouseEvent me = new MouseEvent((Component)e.getSource(),e.getID(),e.getWhen(),e.getModifiers(),e.getX()-(bounds.x),e.getY()-bounds.y,e.getClickCount(),e.isPopupTrigger(),e.getButton());
					TreeNode node = (TreeNode)path.getLastPathComponent();
					((IInteractiveTreeCellRenderer)getCellRenderer()).mouseReleased(tree,node,me,tree.getLocationOnScreen().x+bounds.x,tree.getLocationOnScreen().y+bounds.y);
				}
			}
		}
		super.mouseReleased(e);
	}

}
	
  /**
   * The expand control image.
   */
  protected static ImageIcon expanded;

  /**
   * The collapse control image.
   */
  protected static ImageIcon collapsed;

  /**
   * Creates the UI delegate for the given tree.
   *
   * @param tree The tree to create its UI delegate.
   */
  public MetouiaTreeUI(JComponent tree)
  {
    expanded = MetouiaLookAndFeel.loadIcon("treeex.gif", this);
    collapsed = MetouiaLookAndFeel.loadIcon("treecol.gif", this);
  }

  /**
   * Creates the UI delegate for the given component.
   *
   * @param tree The component to create its UI delegate.
   * @return The UI delegate for the given component.
   */
  public static ComponentUI createUI(JComponent tree)
  {
    return new MetouiaTreeUI(tree);
  }

  /**
   * Paints the expand (toggle) part of a row. The reciever should
   * NOT modify <code>clipBounds</code>, or <code>insets</code>.
   *
   * @param  g The graphics context to use.
   * @param  bounds The expand control bounds.
   * @param  isExpanded The target state of the expand control.
   * @param  clipBounds Unused argument.
   * @param  insets Unused argument.
   * @param  path Unused argument.
   * @param  row Unused argument.
   * @param  hasBeenExpanded Unused argument.
   * @param  isLeaf Unused argument.
   */
  protected void paintExpandControl(Graphics g, Rectangle clipBounds,
    Insets insets, Rectangle bounds, TreePath path, int row,
    boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf)
  {
    if (isExpanded)
    {
      g.drawImage(expanded.getImage(), bounds.x - 17, bounds.y + 4, null);
    }
    else
    {
      g.drawImage(collapsed.getImage(), bounds.x - 17, bounds.y + 4, null);
    }
  }
	/* (non-Javadoc)
	 * @see javax.swing.plaf.basic.BasicTreeUI#createMouseListener()
	 */
	protected MouseListener createMouseListener() {
		// TODO Auto-generated method stub
		return new DelegatingMouseHandler();
	}

}